/**author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to ineract 
 * with and see the workings of a Towers of Hanoi example
 * version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;

class Disk {
	Image image;
	int curTower,
		nextTower,
		x,
		y;
	
	// constructors
	Disk(){}
	
	Disk(Disk a) {
		this.image = a.image;
		this.curTower = a.curTower;
		this.nextTower = a.nextTower;
		this.x = a.x;
		this.y = a.y;
	}

	Disk(Image image, int curTower, int x, int y) {
		this.image = image;
		this.curTower = curTower;
		this.nextTower = curTower;
		this.x = x;
		this.y = y;
	}
	
	Disk(int curTower, int x, int y) {
		this.curTower = curTower;
		this.nextTower = curTower;
		this.x = x;
		this.y = y;
	}
	
	public void setImage(Image i) {
		this.image = i;
	}
	
	public void reset(int x, int y) {
		this.x = x;
		this.y = y;
		this.curTower = 1;
		this.nextTower = 1;
	}

	// draw the disk
	public void draw(Graphics g, Applet a) {
		g.drawImage(this.image, this.x, this.y, a);
	}
}// end class Disk
		
	

public class TowersOfHanoi extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int _buttonX			= 20,
			  _buttonY			= 100,
			  _wideButton		= 100,
			  _buttonHeight		= 23,
			  _buttonHSpacer	= _buttonHeight + 10,
			  _buttonWSpacer	= _wideButton + 10,
			  _messageWidth		= 370,
			  _messageHeight	= 95,
			  _messageX			= 210,
			  _messageY			= 235,
			  _speedBarX		= _buttonX,
			  _speedBarY		= _messageY + _messageHeight - 15,
			  _speedBarWidth	= (int)(_wideButton * 1.8),
			  _speedBarHieght	= 13,
			  _diskWidth		= 110,
			  _diskHieght		= 20,
			  _towersY			= 180,
			  _tower1X			= 205 - (int)_diskWidth/2,
			  _tower2X			= 355 - (int)_diskWidth/2,
			  _tower3X			= 505 - (int)_diskWidth/2,
			  _arraySize		= 4;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image towersBackground;
	Image[]diskImages ;
	
	// interface peices
	TextArea messageCenter;
	Button startButton, resetButton, pauseButton, continueButton;
	Scrollbar speedBar;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	Applet applet;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	int frameRate = 15;	// animation spped
	
	int towerSize[] = new int[3];
	int towersX[] = new int[3];
	int moveDiskStep = 0;

	// has user paused the applet?
	boolean pause = false;
	
	boolean doneMovingDisks = false;
	boolean movingDisks = false;	
	
	Disk [] disks;
			
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		towersBackground	= this.getImage(this.getCodeBase(), "Background.gif");
		waitForImage(this, towersBackground);
		// create space for the diskImages 
		diskImages = new Image[_arraySize];
		// load the images for the disks	
		diskImages[0] = this.getImage(this.getCodeBase(), "disk0.gif");
		waitForImage(this, diskImages[0]);
		diskImages[1] = this.getImage(this.getCodeBase(), "disk1.gif");
		waitForImage(this, diskImages[1]);
		diskImages[2] = this.getImage(this.getCodeBase(), "disk2.gif");
		waitForImage(this, diskImages[2]);
		diskImages[3] = this.getImage(this.getCodeBase(), "disk3.gif");
		waitForImage(this, diskImages[3]);

		// get this applet
		applet = this;
		
		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);

		towersX[0] = _tower1X;
		towersX[1] = _tower2X;
		towersX[2] = _tower3X;

		disks = new Disk[_arraySize];
		Disk a = new Disk(1, 0, 0);
		for(int i = 0; i < _arraySize; i++) {
			a.x = _tower1X;
			a.y = _towersY - (_diskHieght * (i+1));
			a.setImage(diskImages[i]);
			disks[i] = new Disk(a);
		}
		
		// start moving the towers
		// start, pause, continue are all linked
		startButton = new Button("start!");
		startButton.setBounds(_buttonX, _buttonY, _wideButton, _buttonHeight);
		add(startButton);
		startButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				movingDisks = true;
				moveDiskStep = 1;
				remove(startButton);
				add(pauseButton);
			}
		});

		// pause button
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonX, _buttonY, _wideButton, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!doneMovingDisks) {
					remove(pauseButton);
					add(continueButton);
					pause = true;
				}
				else {
					toolkit.beep();
					messageCenter.append("Hit Reset... then start to play again.\n");
				}
			}
		});

		// continue button
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonX, _buttonY, _wideButton, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});

		// reset button
		resetButton = new Button("reset");
		resetButton.setBounds(_buttonX, _buttonY + _buttonHSpacer, _wideButton, _buttonHeight);
		add(resetButton);
		resetButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				Reset(applet); 
			}
		});
		
		// speedbar
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 30);
		speedBar.setBounds(_buttonX, _speedBarY, _speedBarWidth, _speedBarHieght);
		add(speedBar);
		speedBar.setValue(frameRate);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		messageCenter.append("All disks will be moved to Tower2, moving only 1 disk at a time.\n");
		add(messageCenter);
		
		Reset(this);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		bufferGraphics.drawImage(towersBackground, 0, 0, this);
		bufferGraphics.setColor(Color.black);
		//display animation speed
		bufferGraphics.drawString("Speed = " +frameRate+ " frames/sec", _speedBarX + 50,
								  _messageY + _messageHeight - _buttonHeight);
		
		// draw disks
		for(int i = 0; i < _arraySize; i++)
			disks[i].draw(bufferGraphics, this);
		
		// draw the buffer to the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			if(!pause) {
				// if moving disks then call MoveDisks() to calcualte new positions for disks
				if(movingDisks)
					CasesForDiskMovements();
			}
			repaint();	// repaint the screen
			if(movingDisks) {// only set applet speed while animating
				// sync repaints() from 1 - 30 fps
				sleep = frameRate - (int)(System.currentTimeMillis() - start);
				if(sleep <= 0) sleep = 1;	// never divide by zero
				sleep = 1000 / sleep;
				try { thisThread.sleep(sleep); }
				catch (InterruptedException e) {}
			}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for the image to be loaded before starting the applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
		
// Done()////////////////////////////////////////////////////////////
	public void Done() {
		toolkit.beep();
		moveDiskStep = 0;
		doneMovingDisks = true;
		messageCenter.append("All the disks have been moved to tower2 sucessfully!!!.\n");
	}

// min///////////////////////////////////////////////////////////////////////	
	public int min(int x, int min) {
		if(x < min) return min;
		else return x;
	}		   

// max///////////////////////////////////////////////////////////////////////	
	public int max(int x, int max) {
		if(x > max) return max;
		else return x;
	}		   
	
// Reset()///////////////////////////////////////////////////////////
	public void Reset(Applet a) {
		// we need to figure out which of these 3 buttons is showing and 
		// replace it with the startButton
		if(pause) {// applet is paused so the continueButton must be showing
			a.remove(continueButton);
			a.add(startButton);
		}
		else {// either the startButton or the pauseButton is showing
			if(movingDisks || doneMovingDisks) {// pause button is showing
				a.remove(pauseButton);
				a.add(startButton);
			}
		}

		moveDiskStep = 0;
		movingDisks = false;
		doneMovingDisks = false;
		
		towerSize[0] = 0;
		towerSize[1] = 0;
		towerSize[2] = 0;
		
		Disk z = new Disk(1, 0, 0);
		for(int i = 0; i < _arraySize; i++) {
			towerSize[0]++;
			z.x = _tower1X;
			z.y = _towersY - (_diskHieght * (i+1));
			z.setImage(diskImages[i]);
			disks[i] = new Disk(z);
		}
	}
	
// Sort()////////////////////////////////////////////////////////////
	public void CasesForDiskMovements() {
		switch (moveDiskStep) {// number of steps = 2^n-1 
							   // (where n is the number of disks)
		case 1: // move disk3 from tower1 to tower3
			if(!Move(3, 1, 3)) moveDiskStep = 2;
			break;
		case 2: // move disk2 from tower1 to tower2
			if(!Move(2, 1, 2)) moveDiskStep = 3;
			break;
		case 3: // move disk3 from tower3 to tower2
			if(!Move(3, 3, 2)) moveDiskStep = 4;
			break;
		case 4: // move disk1 from tower1 to tower3
			if(!Move(1, 1, 3)) moveDiskStep = 5;
			break;
		case 5: // move disk3 from tower2 to tower1
			if(!Move(3, 2, 1)) moveDiskStep = 6;
			break;
		case 6: // move disk2 from tower2 to tower3
			if(!Move(2, 2, 3)) moveDiskStep = 7;
			break;
		case 7: // move disk3 from tower1 to tower3
			if(!Move(3, 1, 3)) moveDiskStep = 8;
			break;
		case 8: // move disk0 from tower1 to tower2
			if(!Move(0, 1, 2)) moveDiskStep = 9;
			break;
		case 9: // move disk3 from tower3 to tower2
			if(!Move(3, 3, 2)) moveDiskStep = 10;
			break;
		case 10: // move disk2 from tower3 to tower1
			if(!Move(2, 3, 1)) moveDiskStep = 11;
			break;
		case 11: // move disk3 from tower2 to tower1
			if(!Move(3, 2, 1)) moveDiskStep = 12;
			break;
		case 12: // move disk1 from tower3 to tower2
			if(!Move(1, 3, 2)) moveDiskStep = 13;
			break;
		case 13: // move disk3 from tower1 to tower3
			if(!Move(3, 1, 3)) moveDiskStep = 14;
			break;
		case 14: // move disk2 from tower1 to tower2
			if(!Move(2, 1, 2)) moveDiskStep = 15;
			break;
		case 15: // move disk3 from tower3 to tower2
			if(!Move(3, 3, 2)) {
				Done();
			}
			break;
		default: break;
		}// end switch
	}// end CasesForDiskMovements
	
	// helper function to move disks
	public boolean Move(int disk, int curTower, int nextTower) {
		// there are 2 cases for movement of disks 
		// 1) to the left	(curTower < nextTower)
		// 2) to the right	(curTower > nextTower)
		
		if(curTower < nextTower) {// moving disk to the left
			// now the disk can either go
			// 1) up	(disks[?].y > 50) && (disks[?].x < towersX[nextTower - 1])
			// 2) right	(disks[?].y == 50) && (disks[?].x < towersX[nextTower - 1])
			// 3) down	(disks[?].y < (towerSize[nextTower] + 1) * _diskHieght)
			
			if((disks[disk].y > 50) && (disks[disk].x < towersX[nextTower - 1])) {
				// moving up
				if(disks[disk].y - 10 < 50) 
					disks[disk].y = 50;
				else disks[disk].y -= 10;
			}
			else if((disks[disk].y == 50) && (disks[disk].x < towersX[nextTower - 1])) {
				// move right
				if(disks[disk].x + 10 > towersX[nextTower - 1])
					disks[disk].x = towersX[nextTower - 1];
				else disks[disk].x += 10;
			}
			else if(disks[disk].y < (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght)) {
				// move down
				if(disks[disk].y + 10 > (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght))
					disks[disk].y = (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght);
				else disks[disk].y += 10;
			}
			else {
				towerSize[nextTower - 1]++;
				towerSize[curTower - 1]--;
				return false;	// done moving this disk for now
			}
		}
		else {// move disk to the left
			if((disks[disk].y > 50) && (disks[disk].x > towersX[nextTower - 1])) {
				// moving up
				if(disks[disk].y - 10 < 50) 
					disks[disk].y = 50;
				else disks[disk].y -= 10;
			}
			else if((disks[disk].y == 50) && (disks[disk].x > towersX[nextTower - 1])) {
				// move left
				if(disks[disk].x - 10 < towersX[nextTower - 1])
					disks[disk].x = towersX[nextTower - 1];
				else disks[disk].x -= 10;
			}
			else if(disks[disk].y < (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght)) {
				// move down
				if(disks[disk].y + 10 > (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght))
					disks[disk].y = (_towersY - (towerSize[nextTower - 1] + 1) * _diskHieght);
				else disks[disk].y += 10;
			}
			else {
				towerSize[nextTower - 1]++;
				towerSize[curTower - 1]--;
				return false;	// done moving this disk for now
			}
		}
		return true;	// the animation for this disk is not done
	}
	
}// end TowersOfHanoi class
