/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * This is an applet which demonstrates the usage of stacks 
 * to sort a set of train cars into numerical order
 * @version 1.0
 */

import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;

class TrainCar{
// holds data needed to represent train througout the animation
	Image image1, image2;
	boolean tilted, placed;
	int element;
	int x, y;
	int nextY, nextX;
	
	// constructors
	TrainCar() {}
	
	TrainCar(TrainCar c) {
		this.image1 = c.image1;
		this.image2 = c.image2;
		this.tilted = c.tilted;
		this.placed = c.placed;
		this.element = c.element;
		this.x = c.x;
		this.y = c.y;
		this.nextX = nextX;
		this.nextY = nextY;
	}
	
	TrainCar(Image i1, Image i2, boolean tilted, boolean placed, int elem,
			 int x, int y, int nX, int nY) {
		image1 = i1;
		image2 = i2;
		this.tilted = tilted;
		this.placed = placed;
		element = elem;
		this.x = x;
		this.y = y;
		nextX = nX;
		nextY = nY;
	}
	
	// resets car, so the applet can be run again
	public void resetCar(boolean tilted, boolean placed, int elem, int x, int y, int nX, int nY) {
		this.tilted = tilted;
		this.placed = placed;
		this.element = element;
		this.x = x;
		this.y = y;
		this.nextX = nX;
		this.nextY = nY;
	}
	
	// draws the car onto the screen
	public void drawCar(Graphics g, Applet a) {
		if(!tilted)
			g.drawImage(image1, x, y, a);
		else
			g.drawImage(image2, x, y, a);
	}
}

class HoldingTrack {
// contains location of holding track on the screen 
// and the contents of that track
	Stack track;
	int x, y;
	
	// constructors
	HoldingTrack() {}
	
	HoldingTrack(int x, int y) {
		track = new Stack();
		this.x = x;
		this.y = y;
	}
}


// RAILROAD WITH STACKS APPLET///////////////////////////////////////
public class RailRoadStackBG extends Applet implements Runnable 
{
	// these values are global constraints which are used to hold critical values
	public final int _carSize		= 28,
					 _numOfCars		= 7,
					 _numOfHoldingTracks	= 4,
					 _sizeOfGoldingTracks	= 7,
					 _messageX		= 440,
					 _messageY		= 145,
					 _messageHeight	= 170,
					 _messageWidth	= 215,
					 _buttonsX		= 25,
					 _buttonsY		= 150,
					 _buttonHeight	= 20,
					 _wideButton	= 80,
					 _speedY		= 360,
					 _buttonSpacer	= _buttonHeight + 15,
					 _none			= 0,
					 _toHolding		= 1,
					 _fromHolding	= 2,
					 _fromInput		= 3,
					 _manual		= 4;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, programName, c1, c2, c3, c4, c5, c6,
		  c1t, c2t, c3t, c4t, c5t, c6t, background, trackSwitcher,
		  failedGif;
	
	// interface peices
	TextArea messageCenter;
	Choice carChoice;
	Button manualButton, randomButton, nextMoveButton, resetButton, 
		   pauseButton, continueButton;
	Scrollbar speedBar;
	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// all the structures which hold the cars
	Stack inputTrack;
	HoldingTrack [] holdingTrack;
	boolean [] outputTrack;
	
	// is the track switcher on at this location?
	boolean [] trackSwitcherOn = new boolean[4];
	
	// car images regular or tilted
	Image [] c;
	Image [] ct;

	// used during animation to call the active_button
	int active_button = _none;
	
	int nextCarToOutput = 1;
	int numOfHoldingTrack = 0;
	
	int numOfCarsPlaced = 0;
	
	int frameRate = 30;	// controls animation speed
	int animStep = 10;	// pixel movements per animation cycle
	boolean pause = false;	// is applet paused?
	boolean done = false;	// have the trains been sorted?
	boolean carsPlaced = false;		// have the cars been placed yet?
	boolean failed = false;	// cars can not be sorted
	
	TrainCar [] cars;	// hold data relevant to each train car
	
	// this car is passed to different functions. 
	//it represent one of the train cars in cars[] (above)
	TrainCar workingCar = new TrainCar();	

	// Initialize applet
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// holds car images
		c = new Image[_numOfCars];
		ct = new Image[_numOfCars];

		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, boboGames);
		programName	= this.getImage(this.getCodeBase(), "program_name.gif");
		waitForImage(this, programName);
		background	= this.getImage(this.getCodeBase(), "back.gif");
		waitForImage(this, background);
		trackSwitcher	= this.getImage(this.getCodeBase(), "new90tilt.gif");
		waitForImage(this, trackSwitcher);
		failedGif	= this.getImage(this.getCodeBase(), "failed.gif");
		waitForImage(this, failedGif);

		// load regular car images
		c[0]	= this.getImage(this.getCodeBase(), "c1.gif");
		waitForImage(this, c[0]);
		c[1]	= this.getImage(this.getCodeBase(), "c2.gif");
		waitForImage(this, c[1]);
		c[2]	= this.getImage(this.getCodeBase(), "c3.gif");
		waitForImage(this, c[2]);
		c[3]	= this.getImage(this.getCodeBase(), "c4.gif");
		waitForImage(this, c[3]);
		c[4]	= this.getImage(this.getCodeBase(), "c5.gif");
		waitForImage(this, c[4]);
		c[5]	= this.getImage(this.getCodeBase(), "c6.gif");
		waitForImage(this, c[5]);
		c[6]	= this.getImage(this.getCodeBase(), "c7.gif");
		waitForImage(this, c[6]);

		// load tilted car images
		ct[0]	= this.getImage(this.getCodeBase(), "c1tilt.gif");
		waitForImage(this, ct[0]);
		ct[1]	= this.getImage(this.getCodeBase(), "c2tilt.gif");
		waitForImage(this, ct[1]);
		ct[2]	= this.getImage(this.getCodeBase(), "c3tilt.gif");
		waitForImage(this, ct[2]);
		ct[3]	= this.getImage(this.getCodeBase(), "c4tilt.gif");
		waitForImage(this, ct[3]);
		ct[4]	= this.getImage(this.getCodeBase(), "c5tilt.gif");
		waitForImage(this, ct[4]);
		ct[5]	= this.getImage(this.getCodeBase(), "c6tilt.gif");
		waitForImage(this, ct[5]);
		ct[6]	= this.getImage(this.getCodeBase(), "c7tilt.gif");
		waitForImage(this, ct[6]);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		// initailize screen positions for each holding track
		holdingTrack = new HoldingTrack[_numOfHoldingTracks];
		int x = 0;
		for(int i = 0; i < 4; i++) {
			switch (i) {
				case 0: { x = 215; break; }
				case 1: { x = 276; break; }
				case 2: { x = 336; break; }
				case 3: { x = 400; break; }
				default: break;
			}// end switch
			holdingTrack[i] = new HoldingTrack(x, 330);
		}// end for
			

		// create initial car data
		// however actual car data will be set in Reset()
		cars = new TrainCar[_numOfCars];
		for(int i = 0; i < _numOfCars; i++)
			cars[i] = new TrainCar(c[i], ct[i], false, false, i + 1, 0, 0, 0, 0);
		
		outputTrack = new boolean[_numOfCars];
		
		// create an empty input track
		inputTrack = new Stack();
		
		// initailize/reset all train cars and all tracks
		Reset();
		
		// Create buttons
		manualButton = new Button("manual placement");
		manualButton.setBounds(_buttonsX, _buttonsY, _wideButton + 20, _buttonHeight);
		add(manualButton);
		manualButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if((active_button == _none || active_button == _manual) && numOfCarsPlaced < _numOfCars){
					active_button = _manual;
					ManuallyPlaceCars();						
				}
			}
		});
		
		carChoice = new Choice();
		carChoice.setBounds(_buttonsX + _wideButton + 30, _buttonsY, _wideButton/2, _buttonHeight);
		add(carChoice);
		for(int i = 1; i <= _numOfCars; i++)
			carChoice.add("" +i);	
		
		randomButton = new Button("random placement");
		randomButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer, _wideButton + 20, _buttonHeight);
		add(randomButton);
		randomButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _none) {
					Reset();
					RandomCarPlacement();
				}
			}
		});
		
		nextMoveButton = new Button("next move");
		nextMoveButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 2, _wideButton, _buttonHeight);
		add(nextMoveButton);
		nextMoveButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(!done && !pause) {
					if(active_button == _none) {
						System.out.println("got into next move");
						if (NeedToOutputFromHolding()) active_button = _fromHolding;
						else if (NeedToOutputFromInput()) active_button = _fromInput;
						else { NeedToPutIntoHolding(); active_button = _toHolding; }
					}
					else messageCenter.append("You must wiat until the current car is done moving.\n");
				}					
				else {
					toolkit.beep();
					if(done)
						messageCenter.append("Done sorting train cars, hit reset to try again.\n");
					else
						messageCenter.append("You must press continue before you can move the next car.\n");
				}// end else
			}
		});

		// reset button
		resetButton = new Button("reset");
		resetButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 3, _wideButton, _buttonHeight);
		add(resetButton);
		resetButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _none) { 
					carChoice.removeAll();
					for(int i = 1; i <= _numOfCars; i++) 
						carChoice.add("" +i);
					Reset(); 
				}
			}
		});
		
		// pause button
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 4,
							  _wideButton, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button != _none && !done) {
					remove(pauseButton);
					add(continueButton);
					pause = true;
				}
				else messageCenter.append("Cannot pause now.\n");
			}
		});

		// continue button
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 4,
							  _wideButton, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});

		// speedbar
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 30);
		speedBar.setBounds(_buttonsX, _speedY,
							  140, 13);
		add(speedBar);
		speedBar.setValue(frameRate);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);
		
	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		bufferGraphics.setColor(Color.white);
		// draw background image
		bufferGraphics.drawImage(background, 0, 0, this);
		
		// show frame curent frame rate
		bufferGraphics.drawString("Speed = " +frameRate+ " frames/sec", _buttonsX + 20, 
								  _speedY + 27);

		// if trackswitcher[] is on for a certain track draw it
		for(int i = 0; i < 4; i++) {
			if(trackSwitcherOn[i])
				switch (i) {
					case 0: { bufferGraphics.drawImage(trackSwitcher, 202, 90, this); break; }
					case 1: { bufferGraphics.drawImage(trackSwitcher, 262, 90, this); break; }
					case 2: { bufferGraphics.drawImage(trackSwitcher, 322, 90, this); break; }
					case 3: { bufferGraphics.drawImage(trackSwitcher, 386, 90, this); break; }
					default: break;
				}
		}
		
		// draw all of the cars in their current locations
		for(int i = 0; i < _numOfCars; i++) {
			if(cars[i].placed)
				cars[i].drawCar(bufferGraphics, this);
		}
		
		if(failed)
			bufferGraphics.drawImage(failedGif, 210, 250, this);

		// copy buffer image to screen
		g.drawImage(buffer, 0, 0, this);
	}
	
// U P D A T E///////////////////////////////////////////////////////
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(animation == thisThread) {
			if(!pause) {
				// user has not paused applet
				start = System.currentTimeMillis();
				// if any of these buttons are active call them to 
				// continue the animation sequence
				if(active_button == _fromInput) OutputFromInputTrack();
				if(active_button == _fromHolding) OutputFromHoldingTrack();
				if(active_button == _toHolding) PutInHoldingTrack();					
				// repaint the screen
				repaint();
				// sync repaints() from 1 - 30 fps
				sleep = frameRate - (int)(System.currentTimeMillis() - start);
				if(sleep <= 0) sleep = 1;	// never divide by zero
				sleep = 1000 / sleep;
				try { thisThread.sleep(sleep); }
				catch (InterruptedException e) {}
			}// end if(!pause)
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
		// doesnt start applet until the image has been loaded
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// PutInHoldingTrack()///////////////////////////////////////////////
	public void PutInHoldingTrack() {
		// moves car in the x direction, then in the y direction
		if(workingCar.x < workingCar.nextX) {
			workingCar.x += animStep;
			if(workingCar.x > workingCar.nextX) 
				workingCar.x = workingCar.nextX;
		}
		else if(workingCar.y < workingCar.nextY) {
			trackSwitcherOn[numOfHoldingTrack] = true;
			workingCar.tilted = true;
			workingCar.y += animStep;
			if(workingCar.y > workingCar.nextY)
				workingCar.y = workingCar.nextY;
		}
		else {
			active_button = _none;
			trackSwitcherOn[numOfHoldingTrack] = false;
		}
	}
	
// OutputFromHoldingTrack()//////////////////////////////////////////
	public void OutputFromHoldingTrack() {
		// moves car in the y direction, then in the x direction
		if(workingCar.y > workingCar.nextY) {
			trackSwitcherOn[numOfHoldingTrack] = true;
			workingCar.y -= animStep;
			if(workingCar.y < workingCar.nextY) 
				workingCar.y = workingCar.nextY;
		}
		else if(workingCar.x < workingCar.nextX) {
			trackSwitcherOn[numOfHoldingTrack] = false;
			workingCar.tilted = false;
			workingCar.x += animStep;
			if(workingCar.x > workingCar.nextX)
				workingCar.x = workingCar.nextX;
		}
		else {
			active_button = _none;
			if(done) {
				Done();
			}
		}
	}
	
// OutputFromInputTrack()////////////////////////////////////////////
	public void OutputFromInputTrack() {
		if(workingCar.x < workingCar.nextX) {
			workingCar.x += animStep;
			if(workingCar.x > workingCar.nextX)
				workingCar.x = workingCar.nextX;
		}
		else {
			active_button = _none;
			if(done) {
				Done();
			}
		}
	}
	
// Reset()///////////////////////////////////////////////////////////
	public void Reset() {
		// empties all tracks, and resets all train cars
		nextCarToOutput = 1;
		numOfCarsPlaced = 0;
		workingCar = null;
		for(int i = 0; i < _numOfHoldingTracks; i++) {
			trackSwitcherOn[i] = false;
			while(!holdingTrack[i].track.isEmpty()) 
				holdingTrack[i].track.pop();
		}
		for(int i = 0; i < _numOfCars; i++) {
			outputTrack[i] = false;
			cars[i].x = 0;
			cars[i].placed = false;
		}
		while(!inputTrack.isEmpty()) 
			inputTrack.pop();
		done = false;
		pause = false;
		carsPlaced = false;
		failed = false;
		active_button = _none;
	}
	
// RandomCarPlacement()//////////////////////////////////////////////
	public void RandomCarPlacement() {
		Random random = new Random(System.currentTimeMillis());
		int randNum = 0;
		int x = 0;
		boolean [] placed = new boolean[_numOfCars];
		// randomly places cars onto input track
		for(int i = 0; i < _numOfCars; i++) {
			while(!placed[i]) {
				randNum = (random.nextInt() % _numOfCars);
				if(randNum < 0) randNum = randNum * -1;
				
				if(cars[randNum].x == 0) {
					// setup data for cars[i]
					placed[i] = true;
					x = (_carSize * i) + 1;
					cars[randNum].resetCar(false, true, randNum + 1, x, 105, x, 105);
					inputTrack.push(cars[randNum]);
				}
			}// end while
		}// end for
		carsPlaced = true;
	}	
	
// ManuallyPlaceCars()///////////////////////////////////////////////
	public void ManuallyPlaceCars() {
		String str = new String();
		str = carChoice.getSelectedItem();
		char ch = str.charAt(0);
		switch(ch) {
			case '1': { cars[0].resetCar(false, true, 1, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105);
						carChoice.remove("1");
						inputTrack.push(cars[0]);
						if(++numOfCarsPlaced >= _numOfCars - 1) active_button = _none;
						break;
					  }
			case '2': { cars[1].resetCar(false, true, 2, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("2");
						inputTrack.push(cars[1]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			case '3': { cars[2].resetCar(false, true, 3, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("3");
						inputTrack.push(cars[2]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			case '4': { cars[3].resetCar(false, true, 4, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("4");
						inputTrack.push(cars[3]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			case '5': { cars[4].resetCar(false, true, 5, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("5");
						inputTrack.push(cars[4]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			case '6': { cars[5].resetCar(false, true, 6, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("6");
						inputTrack.push(cars[5]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			case '7': { cars[6].resetCar(false, true, 7, _carSize * numOfCarsPlaced + 1,
													   105, _carSize * numOfCarsPlaced + 1, 105); 
						carChoice.remove("7");
						inputTrack.push(cars[6]);
						if(!(++numOfCarsPlaced < _numOfCars)) active_button = _none;
						break;
					  }
			default: break;
		}// end switch
	}
	
// AllCarsPlaced()///////////////////////////////////////////////////
	public boolean AllCarsPlaced() {
		boolean allCarsPlaced = true;
		for(int i = 0; i < _numOfCars; i++) {
			if(!cars[i].placed)
				allCarsPlaced = false;
		}
		return allCarsPlaced;
	}		
	
// Done()////////////////////////////////////////////////////////////
	public void Done() {
		messageCenter.append("The train has been sucessfully sorted.\n");
	}

// PeekAtTopOfStack()///////////////////////////////////////////////////
	public int PeekAtTopOfStack(Stack s) {
		// if stack is empty this allows you to peek at it without throwing an exception
		// if the stack is empty a number relevant to thsi program will be returned
		if(s.isEmpty()) return _numOfCars + 2;
		else return ( ((TrainCar) s.peek()).element );
	}

// NeedToOutputFromHolding()/////////////////////////////////////////
	public boolean NeedToOutputFromHolding() {
	// check holding stacks for cars to output
		int smallestCar = _numOfCars + 2;
		int track = _numOfCars + 1;
		for(int i = 0; i < _numOfHoldingTracks; i++) {
			if( PeekAtTopOfStack(holdingTrack[i].track) < smallestCar) {
				track = i;
				smallestCar = ( PeekAtTopOfStack(holdingTrack[i].track) );
			}// end if
		}// end for
		
		if(track != _numOfCars + 1 && smallestCar == nextCarToOutput) {
			// move a car from holding track to ouput track
			workingCar = (TrainCar) holdingTrack[track].track.pop();
			workingCar.nextX = 669 - (workingCar.element * _carSize);
			workingCar.nextY = 105;
			numOfHoldingTrack = track;
			if(++nextCarToOutput > _numOfCars) done = true;
			return true;
		}// end if
		return false;
	}
	
// NeedToOutputFromInput()/////////////////////////////////////////
	public boolean NeedToOutputFromInput() {
		workingCar = (TrainCar) inputTrack.peek();
		if(workingCar.element == nextCarToOutput) {
			// move car stright to output track
			workingCar = (TrainCar) inputTrack.pop();
			workingCar.nextX = 669 - (workingCar.element * _carSize);
			if(++nextCarToOutput > _numOfCars) done = true;
			return true;
		}
		return false;
	}

// NeedToPutIntoHolding()////////////////////////////////////////////
	public void NeedToPutIntoHolding() {
		int numOfBadTracks = 0;
		workingCar = (TrainCar) inputTrack.pop();
		int bestTrack = -1,  // best track so far
		    bestTop = _numOfCars + 2;	// top car in bestTrack
			// scan tracks
			int topCar = _numOfCars + 1;

			System.out.println("\n\nworkingCar.element = " +workingCar.element);
			System.out.println("bestTop = " +bestTop+ "   topCar = " +topCar);
							   
			for (int i = 0; i < _numOfHoldingTracks; i++) {
				System.out.println("holdingtrack[" +i+ "].isempty() = " +holdingTrack[i].track.empty());
				if(! holdingTrack[i].track.empty()) {
					topCar = PeekAtTopOfStack(holdingTrack[i].track);
					if(workingCar.element < topCar && topCar < bestTop) {
							bestTrack = i;
							bestTop = topCar;
					}
					else numOfBadTracks++;
				}
			    else if (bestTrack == -1) bestTrack = i;
			}// end for
			if(numOfBadTracks >= _numOfHoldingTracks) {
				toolkit.beep();				
				messageCenter.append("This set of train cars cann not be sorted without \nmore holding tracks.\n");
				failed = true;
				done = true;
				active_button = _none;
			}
			else {
				// add workingCar to bestTrack
				holdingTrack[bestTrack].track.push(workingCar);
				workingCar.nextX = holdingTrack[bestTrack].x;
				workingCar.nextY = holdingTrack[bestTrack].y - 
								   ( (holdingTrack[bestTrack].track.size()) * _carSize);
				numOfHoldingTrack = bestTrack;
				active_button = _toHolding;
			}
		}// end else
	}// end method