/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * This is an applet which demonstrates a bubble sort 
 * @version 1.0
 */

import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;

public class BubbleSort extends Applet implements Runnable 
{
	// these values are global constraints which are used to hold critical values
	public final int _buttonsX		= 25,
					 _buttonsY		= 65,
					 _buttonHeight	= 20,
					 _wideButton	= 100,
					 _displayX		= (int)(_buttonsX + _wideButton * 2 + 50),
					 _displayY		= _buttonsY,
					 _displayWidth	= 400,
					 _displayHeight	= 105,
					 _messageX		= _displayX,
					 _messageY		= 180,
					 _messageHeight	= 80,
					 _messageWidth	= _displayWidth,
					 _speedY		= 265,
					 _numOfContainers	= 10,
					 _containerSize	= 35,
					 _containerX	= 290,
					 _containerY	= 95,
					 _buttonSpacer	= _buttonHeight + 15,
					 _lowValue		= 0,
					 _highValue		= 99,
					 _none			= 0,
					 _sort			= 1,
					 _dormant		= 5,
					 _compare		= 6,
					 _swap			= 7,
					 _hlY			= 8,
					 _hlR			= 9,
					 _incr			= 10;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, programName, container, yellowContainer, redContainer;
	
	// interface peices
	TextArea messageCenter;
	TextField manualValueField, manualIndexField;
	Button manualButton, randomButton, sortButton, resetButton, 
		   pauseButton, continueButton;
	Scrollbar speedBar;
	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// used during animation to call the active_button
	int active_button = _none;
	
	int arraySize = 0;
	
	int sortCnt = 0;
	int sortCursor = 0;
	int sortState = _dormant;
	boolean swapping = false;
	boolean sorted = false;
	
	int frameRate = 1;		// controls animation speed
	boolean pause = false;	// is applet paused?
	boolean done = false;	// have the containers been sorted?
	
	int [] containerValue = new int[_numOfContainers];
	int [] containerState = new int[_numOfContainers];

	// Initialize applet
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, boboGames);
		programName	= this.getImage(this.getCodeBase(), "program_name.gif");
		waitForImage(this, programName);
		container	= this.getImage(this.getCodeBase(), "container.gif");
		waitForImage(this, container);
		yellowContainer	= this.getImage(this.getCodeBase(), "y_container.gif");
		waitForImage(this, yellowContainer);
		redContainer	= this.getImage(this.getCodeBase(), "r_container.gif");
		waitForImage(this, redContainer);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		// Create buttons
		manualButton = new Button("manual placement");
		manualButton.setBounds(_buttonsX, _buttonsY, _wideButton, _buttonHeight);
		add(manualButton);
		manualButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				ManuallyFillContainers();
			}
		});

		manualValueField = new TextField();
		manualValueField.setBounds(_buttonsX + _wideButton + 10, _buttonsY, _wideButton/2, _buttonHeight);
		add(manualValueField);

		manualIndexField = new TextField();
		manualIndexField.setBounds( (int)(_buttonsX + _wideButton * 1.5 + 20), _buttonsY, _wideButton/2, _buttonHeight);
		add(manualIndexField);

		
		randomButton = new Button("random placement");
		randomButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer, _wideButton, _buttonHeight);
		add(randomButton);
		randomButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _none) {
					Reset();
					RandomlyFillContainers();
				}
			}
		});
		
		sortButton = new Button("sort");
		sortButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 2, _wideButton, _buttonHeight);
		add(sortButton);
		sortButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(!done && !pause) {
					if(active_button == _none) {
						//begin sorting
						if(sorted) sorted = false;
						sortState = _hlY;
						active_button = _sort;
					}
				}					
				else {
					toolkit.beep();
					if(done)
						messageCenter.append("Done sorting train cars, hit reset to try again.\n");
					else
						messageCenter.append("You must press continue before you can move the next car.\n");
				}// end else
			}
		});

		// reset button
		resetButton = new Button("reset");
		resetButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 3, _wideButton, _buttonHeight);
		add(resetButton);
		resetButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				Reset(); 
			}
		});
		
		// pause button
		pauseButton = new Button("pause");
		pauseButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 4,
							  _wideButton, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button != _none && !done) {
					remove(pauseButton);
					add(continueButton);
					pause = true;
				}
				else messageCenter.append("Cannot pause now.\n");
			}
		});

		// continue button
		continueButton = new Button("continue");
		continueButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 4,
								 _wideButton, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});

		// speedbar
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 100, 0, 1, 60);
		speedBar.setBounds(_buttonsX, _speedY,
						   _wideButton * 2 + 20, 13);
		add(speedBar);
		speedBar.setValue(frameRate);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);
		
		Reset();
		
	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		FillScreen(bufferSize, bufferGraphics, Color.black);

		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);

		bufferGraphics.setColor(Color.white);
		// draw program name and bobo games images
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(programName, (appletSize.width/2 - programName.getWidth(this)/2), 10, this);
		
		// show frame curent frame rate
		bufferGraphics.drawString("Speed = " +(float)frameRate/2+ " frames/sec", _buttonsX, 
								  _speedY + 27);
		Rectangle bounds = new Rectangle(manualValueField.getBounds());
		bufferGraphics.drawString("value", bounds.x + 15, bounds.y + bounds.height + 10);
		bounds = new Rectangle(manualIndexField.getBounds());
		bufferGraphics.drawString("index", bounds.x + 15, bounds.y + bounds.height + 10);
		
		// draw key
		bufferGraphics.drawImage(yellowContainer, 160, 150, this);
		bufferGraphics.drawString("Comparing", 160 + _containerSize + 10, 150 + _containerSize/2 + 7);
		bufferGraphics.drawImage(redContainer, 160, 195, this);
		bufferGraphics.drawString("Swapping", 160 + _containerSize + 10, 195 + _containerSize/2 + 7);

		// draw the array
		for(int i = 0; i < _numOfContainers; i++) {
			if(containerState[i] == _dormant)
				bufferGraphics.drawImage(container, _containerX + i * _containerSize, _containerY, this);
			else if(containerState[i] == _compare)
				bufferGraphics.drawImage(yellowContainer, _containerX + i * _containerSize, _containerY, this);
			else if(containerState[i] == _swap)
				bufferGraphics.drawImage(redContainer, _containerX + i * _containerSize, _containerY, this);
		}
		// draw the data in the array and the indexes
		for(int i = 0; i < _numOfContainers; i++) {
			if(containerValue[i] < 0) { /*no data in container*/ }
			else if(containerValue[i] < 10)
				bufferGraphics.drawString("" +containerValue[i], _containerX + 16 + i * _containerSize, _containerY + 22);
			else // 10 <= value <= 99
				bufferGraphics.drawString("" +containerValue[i], _containerX + 12 + i * _containerSize, _containerY + 22);
		}
		
		for(int i = 0; i < _numOfContainers; i++)
			bufferGraphics.drawString("" +i, _containerX + 15 + i * _containerSize, _containerY + _containerSize + 10);
		
		
		// copy buffer image to screen
		g.drawImage(buffer, 0, 0, this);
	}
	
// U P D A T E///////////////////////////////////////////////////////
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(animation == thisThread) {
			if(!pause) {
				// user has not paused applet
				start = System.currentTimeMillis();
				if(active_button == _sort) Sort();
				// repaint the screen
				repaint();
				// sync repaints() from 1 - 30 fps
				if(active_button == _sort) {// set the animation speed
					sleep = frameRate - (int)(System.currentTimeMillis() - start);
					if(sleep <= 0) sleep = 1;	// never divide by zero
					sleep = 2000 / sleep;
					try { thisThread.sleep(sleep); }
					catch (InterruptedException e) {}
				}
			}// end if(!pause)
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
		// doesnt start applet until the image has been loaded
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// RandomlyFillContainers()//////////////////////////////////////////////
	public void RandomlyFillContainers() {
		Random random = new Random(System.currentTimeMillis());
		int randNum = 0;
		// randomly places cars onto input track
		for(int i = 0; i < _numOfContainers; i++) {
			randNum = (random.nextInt() % 100);
			if(randNum < 0) randNum *= -1;
			containerValue[i] = randNum;
		}// end for
		arraySize = 10;
	}	
	
// ManuallyFillContainers()///////////////////////////////////////////////
	public void ManuallyFillContainers() {
		int value = ValidateText(manualValueField, _lowValue, _highValue, 0, false, "value");
		int index = ValidateText(manualIndexField, _lowValue, max(arraySize, 9), 0, false, "index");
		if(value >= 0 && index >= 0) {// value is valid
			if(index == arraySize) arraySize++;
			containerValue[index] = value;
		}
	}
	
	
// Done()////////////////////////////////////////////////////////////
	public void Done() {
		messageCenter.append("The array has been succesfully sorted.\n");
	}

// Sort()////////////////////////////////////////////////////////////
	public void Sort() {
		// states of sorting 
		// 1) highlight yellow	_hlY
		// 2) highlight red		_hlR
		// 3) compare			_compare
		// 4) swap				_swap
		// 5) increment			_incr
		// 6) dormant			_dormant

		if(sortCursor >= arraySize - 1) { sortCnt++; sortCursor = 0; }
		if(sortCnt >= arraySize - 1) { 
			toolkit.beep();
			messageCenter.append("The array has been sorted succesfully into non-decreasing order.\n"); 
			sortState = _dormant; 
			active_button = _none; 
		}
		else {
			switch (sortState) {
			case _hlY:	{	containerState[sortCursor] = _compare;
							containerState[sortCursor + 1] = _compare;
							sortState = _compare;
							break; 
						}
			case _compare:	
						{	if(containerValue[sortCursor] > containerValue[sortCursor + 1])
								sortState = _hlR;
							else sortState = _incr;
							break; 
						}
			case _hlR:	{	containerState[sortCursor] = _swap;
							containerState[sortCursor + 1] = _swap;
							sortState = _swap;
							break;
						}
			case _swap:	{	swap(sortCursor, sortCursor + 1);
							sortState = _incr;
							break;
						}
			case _incr:	{	containerState[sortCursor] = _dormant;
							containerState[sortCursor + 1] = _dormant;
							sortState = _hlY;
							sortCursor++;
							if(++sortCursor < 9) {
								containerState[sortCursor] = _compare;
								containerState[sortCursor + 1] = _compare;
							}
							break;
						}
			}// end switch
		}// end else
	}
	
// Reset()///////////////////////////////////////////////////////////
	public void Reset() {
		active_button = _none;
		for(int i = 0; i < _numOfContainers; i++) {
			containerValue[i] = -1;
			containerState[i] = _dormant;
		}								
		arraySize = 0;
		sortCnt = 0;
		sorted = false;
		sortState = _dormant;			
	}

// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// max///////////////////////////////////////////////////////////////////////	
	public int max(int x, int max) {
		if(x > max) return max;
		else return x;
	}		   
	
// swap//////////////////////////////////////////////////////////////////////
	public void swap(int x, int y) {
		int temp = containerValue[x];
		containerValue[x] = containerValue[y];
		containerValue[y] = temp;
	}
	
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if text is valid assign it the field value 
		// else assign it the value -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
}