/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to see and interact with
 * the workings of a Binary Search tree
 * @version 1.0
 */

import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;


class BinaryTreeNode {
	int element;
	BinaryTreeNode leftChild, rightChild;
	
	// constructors
	BinaryTreeNode() {}
	
	BinaryTreeNode(int element) {
		this.element = element;
		this.rightChild = null;
		this.leftChild = null;
	}
	BinaryTreeNode(int element, BinaryTreeNode rc, BinaryTreeNode lc) {
		this.element = element;
		this.rightChild = rc;
		this.leftChild = lc;
	}	
}

class BinaryTree {
	BinaryTreeNode root;
	int maxTreeSize;
	
	// constructors
	BinaryTree() {}
	
	BinaryTree(int maxTreeSize) {
		root = null;
		this.maxTreeSize = maxTreeSize;
	}
		
	
   /** @return element with specified key
     * @return null if no matching element */
   public int get(int theKey)
   {
      // pointer p starts at the root and moves through
      // the tree looking for an element with key theKey
      BinaryTreeNode p = root;
      while (p != null)
         // examine p.element.key
         if (theKey < p.element)
            p = p.leftChild;
         else
            if (theKey > p.element)
               p = p.rightChild;
            else // found matching element
               return p.element;

      // no matching element
      return -1;
   }
   
   /** insert an element with the specified key
     * overwrite old element if there is already an
     * element with the given key */
   public boolean put(int theKey)
   {
      BinaryTreeNode p = root,     // search pointer
                     pp = null;    // parent of p
	  int level = 0;
      // find place to insert theElement
      while (p != null)
      {// examine p.element.key
         pp = p;
		 System.out.println("first level = " +level);
		 if(++level > 3) return false;	// exceeding tree hieght limitation
         // move p to a child
		 System.out.println("second level = " +level);
		 if (theKey < p.element) {
            p = p.leftChild;
		 }
         else if (theKey > p.element)
                 p = p.rightChild;
              else
              {// overwrite element with same key
                 p.element = theKey;
                 return true;
              }
      }
   
      // get a node for theElement and attach to pp
      BinaryTreeNode r = new BinaryTreeNode(theKey);
      if (root != null)
         // the tree is not empty
         if (theKey < pp.element)
            pp.leftChild = r;
         else
            pp.rightChild = r;
      else // insertion into empty tree
         root = r;
	  return true;	// inserted element
   }
   
   /** @return matching element and remove it
     * @return null if no matching element */
   public int remove(int theKey)
   {
      // set p to point to node with key searchKey
      BinaryTreeNode p = root,    // search pointer
                     pp = null;   // parent of p
      while (p != null && theKey != p.element)
      {// move to a child of p
         pp = p;
         if (theKey < p.element)
            p = p.leftChild;
         else
            p = p.rightChild;
      }

      if (p == null) // no element with key searchKey
         return -1;
   
      // save element to be removed
      int theElement = p.element; 
   
      // restructure tree
      // handle case when p has two children
      if (p.leftChild != null && p.rightChild != null)
      {// two children
         // convert to zero or one child case
         // find element with largest key in left subtree of p
         BinaryTreeNode s = p.leftChild,
                        ps = p;  // parent of s
         while (s.rightChild != null)
         {// move to larger element
            ps = s;
            s = s.rightChild;
         }
   
         // move largest element from s to p
         p.element = s.element;
         p = s;
         pp = ps;
      }
   
      // p has at most one child, save this child in c
      BinaryTreeNode c;
      if (p.leftChild == null)
         c = p.rightChild;
      else
         c = p.leftChild;
   
      // remove node p
      if (p == root) root = c;
      else
      {// is p left or right child of pp?
         if (p == pp.leftChild)
            pp.leftChild = c;
         else
            pp.rightChild = c;
      }
	  
	  return theElement;
   }

   /** output elements in ascending order of key */
   public void ascend(Graphics g, Applet a, Image nodeGif, BinaryTreeNode t,
					  int nodeLoc, Point [] nodeLocs, boolean [] lines) {
      if (t != null) {
		  nodeLoc *= 2;		// move to left subtree
		  ascend(g, a, nodeGif, t.leftChild, nodeLoc, nodeLocs, lines);	// do left subtree
		  nodeLoc /= 2;		// move back up from left subtree
		  drawNode(g, a, t, nodeLoc, nodeGif, nodeLocs, lines);			// visit tree root
		  nodeLoc = nodeLoc*2 + 1;		// move to right subtree
		  ascend(g, a, nodeGif, t.rightChild, nodeLoc, nodeLocs, lines);// do right subtree
		  nodeLoc /= 2;		// move back up from right subtree
      }
   }

   // draw node into buffer
   public void drawNode(Graphics g, Applet a, BinaryTreeNode t, int nodeLoc, 
						Image nodeGif, Point [] nodeLocs, boolean [] lines) {
		if(t != null) {
	       Color old_color = g.getColor();
		   g.setColor(Color.white);
	       g.drawImage(nodeGif, nodeLocs[nodeLoc - 1].x, nodeLocs[nodeLoc - 1].y, a);
		   g.drawString("" +t.element, nodeLocs[nodeLoc - 1].x + 7, nodeLocs[nodeLoc - 1].y + 16);
		   lines[nodeLoc - 1] = true;
	       g.setColor(old_color);
		}
   }

   public void ascendPrint(BinaryTreeNode t, int nodeLoc, TextArea text) {
      if (t != null) {
		  nodeLoc *= 2;		// move to left subtree
		  ascendPrint(t.leftChild, nodeLoc, text);	// do left subtree
		  nodeLoc /= 2;		// move back up from left subtree
		  printNode(t, text);
		  nodeLoc = nodeLoc*2 + 1;		// move to right subtree
		  ascendPrint(t.rightChild, nodeLoc, text);// do right subtree
		  nodeLoc /= 2;		// move back up from right subtree
      }
   }
   
   public void printNode(BinaryTreeNode t, TextArea text) {
	   text.append(", " +t.element);
   }   
}

// Start of applet code//////////////////////////////////////////////

public class BinarySearchTree extends Applet implements Runnable 
{
	// critical vlaues for GUI and animation
	public final int _maxValue		= 99,
					 _minValue		= 0,
					 _treeX			= 400,
					 _treeY			= 40,
					 _maxTreeSize	= 15,
					 _displayX		= 210,
					 _displayY		= 20,
					 _displayHeight	= 250,
					 _displayWidth	= 400,
					 _messageX		= _displayX,
					 _messageY		= _displayY + _displayHeight + 10,
					 _messageHeight	= 150,
					 _messageWidth	= _displayWidth,
					 _buttonsX		= 20,
					 _buttonsY		= 50,
					 _buttonHeight	= 25,
					 _wideButton	= 80,
					 _buttonSpacer	= _buttonHeight + 10;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, programName, nodeGif;
	
	// interface peices
	TextField searchTF, insertTF, deleteTF;
	TextArea messageCenter;
	Button searchButton, insertButton, deleteButton, 
		   ascendButton;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	int frameRate = 33;	// animation spped
	boolean button_active = false;
	
	int element_searchTF, element_insertTF, element_deleteTF;
	
	BinaryTree tree = new BinaryTree(_maxTreeSize);

	Point [] nodeLocs = new Point[_maxTreeSize];
	
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();

		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, boboGames);
		programName	= this.getImage(this.getCodeBase(), "program_name.gif");
		waitForImage(this, programName);
		nodeGif	= this.getImage(this.getCodeBase(), "node.gif");
		waitForImage(this, nodeGif);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		
		// calculate locations of nodes on screen
		// all locations are based on the rootLoc
		// and will be used when we draw the nodes 
		// on the screen
		int lvl = 0, temp = 0; 
		for(int i = 1; i <= _maxTreeSize; i++) {
			lvl = 0;
			temp = i;
			while((temp /= 2) > 0) lvl++;
			if(lvl == 0) {
				nodeLocs[i - 1] = new Point(_treeX, _treeY);
			}
			else if(lvl == 1) {
				temp = i - 2;
				if(i % 2 == 0)	// right subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x - 80, _treeY + 60);
				else			// left subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x + 80, _treeY + 60);
			}				
			else if(lvl == 2) {
				temp = i - 4;
				if(i % 2 == 0)	// right subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x - 40, _treeY + 120);
				else			// left subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x + 40, _treeY + 120);
			}
			else if(lvl == 3) {
				temp = i - 8;
				if(i % 2 == 0)	// right subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x - 20, _treeY + 180);
				else			// left subtree
					nodeLocs[i - 1] = new Point(nodeLocs[((i / 2) - 1)].x + 20, _treeY + 180);
			}
		}// end for

		// search button
		searchButton = new Button("get");
		searchButton.setBounds(_buttonsX, _buttonsY, _wideButton, _buttonHeight);
		add(searchButton);
		searchButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active)
					element_searchTF = ValidateText(searchTF, _minValue, _maxValue,
													0, false, "key");
					button_active = true;
					Search(element_searchTF); 
			}
		});
		searchTF = new TextField("0");
		searchTF.setBounds(_buttonsX + _wideButton + 10, _buttonsY, _wideButton, _buttonHeight);
		add(searchTF);
		
		// insert button
		insertButton = new Button("insert");
		insertButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer, _wideButton, _buttonHeight);
		add(insertButton);
		insertButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					element_insertTF = ValidateText(insertTF, _minValue, _maxValue,
													_maxTreeSize, false, "element");
					button_active = true;
					Insert(element_insertTF); 
				}
			}
		});
		insertTF = new TextField("0");
		insertTF.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer, _wideButton, _buttonHeight);
		add(insertTF);

		// delete button
		deleteButton = new Button("delete");
		deleteButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 2, _wideButton, _buttonHeight);
		add(deleteButton);
		deleteButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active)
					element_deleteTF = ValidateText(deleteTF, _minValue, _maxValue,
													0, false, "key");
					button_active = true;
					Delete(element_deleteTF); 
			}
		});
		deleteTF = new TextField("0");
		deleteTF.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer * 2, _wideButton, _buttonHeight);
		add(deleteTF);
		
		// ascend button
		ascendButton = new Button("ascend");
		ascendButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 3, _wideButton, _buttonHeight);
		add(ascendButton);
		ascendButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active)
					button_active = true;
					Ascend(); 
			}
		});

		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		
		//create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// draw program name and bobo games logo into buffer
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(programName, 10, 10, this);
		
		boolean [] lines = new boolean[_maxTreeSize];
		
		// The reason we 
		//		1)ascend the tree and paint it
		//		2)draw lines between nodes in the tree
		//		3)ascend teh tree and paint it 
		// is because the first time we ascend the tree we also intialize 
		// the lines array needed to draw the lines in the appropriate positions
		// then we draw the lines.  And draw the nodes again because we just 
		// drew lines over all of the nodes and we need to draw now draw over these lines
		// with the nodes again
		
		// ascends and paints tree into buffer
		tree.ascend(bufferGraphics, this, nodeGif, tree.root, 1, nodeLocs, lines);
		
		bufferGraphics.setColor(Color.black);

		// draws lines between nodes of tree
		for(int i = 1; i < 8; i++) {
			if(lines[i - 1] && lines[i*2 - 1])
				bufferGraphics.drawLine(nodeLocs[i - 1].x + 12, nodeLocs[i - 1].y + 12, nodeLocs[i*2 - 1].x + 12, nodeLocs[i*2 - 1].y + 12);
			if(lines[i - 1] && lines[i * 2])
				bufferGraphics.drawLine(nodeLocs[i - 1].x + 12, nodeLocs[i - 1].y + 12, nodeLocs[i*2].x + 12, nodeLocs[i*2].y + 12);
		}
		
		// ascends and paints tree
		tree.ascend(bufferGraphics, this, nodeGif, tree.root, 1, nodeLocs, lines);

		// draw the buffer onto the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			repaint();	// repaints the screen
			// only 1 button can be pressed during each cycle
			button_active = false;
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for an image to load before starting the applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
	
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if the field value is valid assign the value to a varuable
		// else assign the variable a value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

// Insert()//////////////////////////////////////////////////////////
	public void Insert(int theElement) {
		if(!tree.put(theElement))
			messageCenter.append("For demonstration puposes the tree hieght is limited to 4 levels\n");
	}
	
// Delete()//////////////////////////////////////////////////////////
	public void Delete(int theKey) {
		int returnValue = tree.remove(theKey);
		if(returnValue < 0)
			messageCenter.append("The element " +theKey+ " is not in tree\n");
		else
			messageCenter.append("The node containing the element " +theKey+ " has been removed from the tree\n");
	}

// Search()//////////////////////////////////////////////////////////
	public void Search(int theKey) {
		int returnValue = tree.get(theKey);
		if(returnValue < 0)
			messageCenter.append("The element " +theKey+ " is not in tree\n");
		else
			messageCenter.append("The element " +theKey+ " is in the tree\n");
	}
	
// Ascend()//////////////////////////////////////////////////////////
	public void Ascend() {
		messageCenter.append("The elements in ascending order are");
		tree.ascendPrint(tree.root, 1, messageCenter);
		messageCenter.append(".\n");
	}
}