/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this applet demonstrates the workings of an array stack
 * @version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;

public class ArrayStack extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int		_buttonHeight	= 23,
					_buttonX		= 20,
					_buttonY		= 100,
					_wideButton		= 100,
					_narrowButton	= 70,
					_buttonSpacer	= _buttonHeight + 10,
					_displayX		= 270,
					_displayY		= 20,
					_displayWidth	= 260,
					_displayHeight	= 440,
					_messageWidth	= 240,
					_messageHeight	= 100,
					_messageX		= _buttonX,
					_messageY		= _displayY + _displayHeight - _messageHeight,
					_stackX			= 370,
					_stackY			= 410,
					_layerHeight	= 20,
					_layerWidth		= 60,
					_highValue		= 99;
									 
	
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// GUI componenets
	Button isEmptyButton, isFullButton, topButton, addButton, deleteButton;
	
	TextArea messageCenter;
	
	TextField addField;
	
	Image bgGif, fullLayerGif, emptyLayerGif, stackGif, topGif, bottomGif, top_bottomGif;
	
	boolean sizeDoubled = false;
	
	final int MaxStackSize = 20;
	int addFieldTF = 0;
	int frameRate = 33;

	boboStack stack = new boboStack();
	int [] stackValues = new int[MaxStackSize];
				
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		bgGif	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, bgGif);
		stackGif	= this.getImage(this.getCodeBase(), "stackGif.gif");
		waitForImage(this, stackGif);
		fullLayerGif	= this.getImage(this.getCodeBase(), "fulllayer.gif");
		waitForImage(this, fullLayerGif);
		emptyLayerGif	= this.getImage(this.getCodeBase(), "emptylayer.gif");
		waitForImage(this, emptyLayerGif);
		topGif	= this.getImage(this.getCodeBase(), "topGif.gif");
		waitForImage(this, topGif);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
	
		// initailize stack values
		for(int i = 0; i < MaxStackSize; i++) stackValues[i] = 0;
				
		// isEmptyButton
		isEmptyButton = new Button("empty");
		isEmptyButton.setBounds(_buttonX, _buttonY, _narrowButton, _buttonHeight);
		add(isEmptyButton);
		isEmptyButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { IsEmpty(); }
		});

		// topButton
		topButton = new Button("peek");
		topButton.setBounds(_buttonX, _buttonY + _buttonSpacer,
							_narrowButton, _buttonHeight);
		add(topButton);
		topButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { Top(); }
		});
		
		// addButton
		addButton = new Button("push");
		addButton.setBounds(_buttonX, _buttonY + _buttonSpacer * 2,
							_narrowButton, _buttonHeight);
		add(addButton);
		addButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				addFieldTF = ValidateText(addField, 0, _highValue, MaxStackSize, false, "element");
				if(addFieldTF != -1) Add(); 
			}
		});
		
		addField = new TextField("0");
		addField.setBounds(_buttonX + _narrowButton + 10, _buttonY + _buttonSpacer * 2,
							_narrowButton, _buttonHeight);
		add(addField);

		// deleteButton
		deleteButton = new Button("pop");
		deleteButton.setBounds(_buttonX, _buttonY + _buttonSpacer * 3,
							   _narrowButton, _buttonHeight);
		add(deleteButton);
		deleteButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { Delete(); }
		});
		
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);
	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill screenn with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);

		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// draw titles
		bufferGraphics.drawImage(bgGif, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(stackGif, 10, 10, this);
		
		bufferGraphics.setColor(Color.white);
		
		// draw legend
		bufferGraphics.drawImage(fullLayerGif, _buttonX, 260, this);
		bufferGraphics.drawString("full", _buttonX + _layerWidth + 10, 275);
		bufferGraphics.drawImage(emptyLayerGif, _buttonX, 290, this);
		bufferGraphics.drawString("empty", _buttonX + _layerWidth + 10, 305);
		
		// draw the stack
		int layers = 10;
		if(sizeDoubled) layers = 20;
		for(int i  = 0; i < layers; i++) {
			if(stack.size() > i) {
				bufferGraphics.drawImage(fullLayerGif, _stackX, _stackY - (_layerHeight * i), this);
				bufferGraphics.drawString(""+stackValues[i], _stackX + 20,
										  _stackY - (_layerHeight * i) + 14); 
			}
			else 
				bufferGraphics.drawImage(emptyLayerGif, _stackX, _stackY - (_layerHeight * i), this);
		}
		bufferGraphics.drawImage(topGif, _stackX + (_layerWidth + 10), 
								 _stackY - (_layerHeight * (stack.size() - 1)), this);
		
		// draw buffer onto screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			repaint();
			// sync repaints() to 33 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for image to load before starting applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int width, int height, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, width, height);
		g.setColor(old_color);
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if value from field is valid then assign that value to a variable
		// else assign a value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue && listSize != 0) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}// end ValidateText()

// IsFull////////////////////////////////////////////////////////////
	public void IsFull() {
		messageCenter.append("isFull = " +(stack.size() == MaxStackSize)+ "\n");
	}
	
// IsEmpty///////////////////////////////////////////////////////////
	public void IsEmpty() {
		messageCenter.append("isEmpty = " +(stack.size() == 0)+ "\n");
	}
	
// Top///////////////////////////////////////////////////////////////
	public void Top() {
		messageCenter.append("" +stack.peek()+ " is on the top of the stack\n");
	}
	
// Add///////////////////////////////////////////////////////////////
	public void Add() {
		if(stack.size() == MaxStackSize) {
			messageCenter.append("For demonstrations stack size is limited to " +MaxStackSize+ "\n");
		}
		else {// more room on stack
			if(!(addFieldTF < 0 || addFieldTF > _highValue)) {// valid textfield
				stackValues[stack.size()] = addFieldTF;
				stack.push(addFieldTF);			
				messageCenter.append("" +addFieldTF+ " has been added to the top of the stack\n");
				if(stack.size() == 11 && !sizeDoubled) {
					messageCenter.append("List size is being doubled\n");
					sizeDoubled = true;
				}
			}
			else {
				messageCenter.append("The element " +addFieldTF+ " must be a number between 0 and " +_highValue+ "\n");
			}
		}
	}
	
// Delete////////////////////////////////////////////////////////////
	public void Delete() {
		if(stack.isEmpty()) {
			messageCenter.append("The stack is empty\n");
		}
		else {
			int x = stack.pop();
			messageCenter.append("" +x+ " has been removed from the top of the stack\n");
		}					  
	}
	
}// end ArrayStack class
	
	
	
	
	
