/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to ineract 
 * with and see the workings of a chain
 * @version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;

// B O X   C L A S S/////////////////////////////////////////////////
class Box {
	int x,
		y,
		index,
		state,			// 0 == !showing, 1 = showing w/out value, 2 = showing w/ value
		indexX,
		indexY,
		infoX,
		infoY,
		value;

	// constructor
	Box(int x, int y, int index, int state, int indexX, int indexY,
		int infoX, int infoY) { 
		this.x = x;
		this.y = y;
		this.state = state;
		this.indexX = indexX;
		this.indexY = indexY;
		this.infoX = infoX;
		this.infoY = infoY;
		this.value = 0;		// default value
	}
	
	// draw the box to the buffer
	public void draw(Graphics graphics, Applet applet, int index, int listSize, Image oneLinkBox,
					 Image twoLinkBox) {
		Color old_color = graphics.getColor();
		if(index < listSize) {
			if(index == 10 || index == 20 || index == 30) 
				graphics.drawImage(twoLinkBox, this.x, this.y - 10, applet);
			else graphics.drawImage(oneLinkBox, this.x, this.y, applet);
			if(index < 10)
				graphics.drawString("" +index, this.indexX - 7, this.indexY);
			else graphics.drawString("" +index, this.indexX - 5, this.indexY);
			graphics.setColor(Color.white);
			if(this.value  <= 9)
				graphics.drawString("" +this.value, this.infoX + 1, this.infoY);
			else if(this.value <= 99)
				graphics.drawString("" +this.value, this.infoX - 1, this.infoY);
			else graphics.drawString("" +this.value, this.infoX, this.infoY);
		}
		graphics.setColor(old_color);
	}// end public void draw()
}

public class Chain extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int _optionX		= 20,
			 _optionY		= 50,
			 _buttonY		= _optionY + 55,
			 _buttonHeight	= 23,
			 _wideButton	= 100,
			 _narrowButton	= 70,
			 _5filler		= 5,
			 _10filler		= 10,
			 _displayX		= _optionX + 220 + _10filler,
			 _displayY		= _10filler * 2,
			 _displayWidth	= 365,
			 _displayHeight	= 237,
			 _displayBarX	= _displayX + _displayWidth,
			 _displayBarY	= _displayY,
			 _listX			= _displayX + 20,
			 _listY			= _displayY + 20,
			 _boxWidth		= 30,
			 _boxHeight		= 25,
			 _messageWidth	= _displayWidth,
			 _messageHeight = 150,
			 _messageY		= _displayY + _displayHeight + _10filler + _5filler,
			 _notShowing	= 0,
			 _valueNotShowing	= 1,
			 _valueShowing	= 2,
			 _noButton		= 0,
			 _indexOf		= 1,
			 _remove		= 2,
			 _removeRear	= 3,
			 _insert		= 4,
			 _insertRear	= 5,
			 _maxListSize	= 40;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, chain, oneLinkBox, twoLinkBox, nullBox, firstNode;
	
	// interface peices
	TextField indexField, insertField1, insertField2, removeField, elemAtField;
	TextArea messageCenter;
	Button sizeButton, emptyButton, indexButton, elemAtButton, 
		   insertButton, removeButton, pauseButton, continueButton;
	Scrollbar speedBar;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// box info
	Box [][] box;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	int frameRate = 10;
	int active_button = _noButton;
	
	int listSize = 0;	
	
	// used for text fields
	int element_indexOfTF = 0,
		index_removeTF = 0,
		index_insertTF = 0,
		element_insertTF = 0,
		index_elemAtTF = 0;
	
	// valid tange of values for textfield data
	int	lowNum = 0,
		highNum = 99;
	
	// used during creation of GUI
	int index1Y = 0,
		index2Y = 0,
		index3Y = 0,
		index1X = 0,
		index2X = 0,
		index3X = 0,
		index4X = 0;
	
	// used during animation sequences
	int methodCallCnt = 0;
			
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bg.gif");
		waitForImage(this, boboGames);
		chain	= this.getImage(this.getCodeBase(), "chain.gif");
		waitForImage(this, chain);
		oneLinkBox	= this.getImage(this.getCodeBase(), "1link_box.gif");
		waitForImage(this, oneLinkBox);
		twoLinkBox	= this.getImage(this.getCodeBase(), "2link_box.gif");
		waitForImage(this, twoLinkBox);
		nullBox	= this.getImage(this.getCodeBase(), "null.gif");
		waitForImage(this, nullBox);
		firstNode	= this.getImage(this.getCodeBase(), "first_node.gif");
		waitForImage(this, firstNode);

		for(int i = 0; i < 10; i++) box = new Box [i][];		

		box = new Box [10][4];
		// allocate/initailize box info storage
		int x, y, index, indexX, indexY, infoX, infoY, state;
		for(int i = 0; i < 4; i ++) {	
			for(int j = 0; j < 10; j++) {
				x = _displayX + 20 + j * _boxWidth;
				y = _displayY + 30 + (i * 55);
				if(i == 0) {
					indexX = x + 15;
					state = _valueNotShowing;	// no value showing
				}
				else {
					indexX = x + 10;
					state = _notShowing;
				}
				indexY = y + 35;
				infoX = x + 6;
				infoY = y + 17;				
				index = j + (10 * i);
				box[j][i] = new Box(x, y, index, state, indexX, indexY, infoX, infoY);
			}// end for
		}// end for

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
				
		// empty
		emptyButton = new Button("empty");
		emptyButton.setBounds(_optionX, _optionY, 
							 _wideButton, _buttonHeight);
		add(emptyButton);
		emptyButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _noButton)
					showIsEmpty(); 
			}
		});

		// elemAt
		elemAtButton = new Button("get");
		elemAtButton.setBounds(_optionX, _optionY + ((_buttonHeight + _10filler)), 
							  _wideButton, _buttonHeight);
		add(elemAtButton);
		elemAtButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				index_elemAtTF = ValidateText(elemAtField, lowNum, listSize - 1, listSize, true, "index");
				if(active_button == _noButton) 
					showElemAt(); 
			}
		});

		// elem at textfield
		elemAtField = new TextField("0");
		elemAtField.setBounds(_optionX + _wideButton + _10filler, _optionY + ((_buttonHeight + _10filler)), 
							  _wideButton, _buttonHeight);
		add(elemAtField);
		
		// index
		indexButton = new Button("indexOf");
		indexButton.setBounds(_optionX, (_optionY + 10 + ((_buttonHeight + _10filler) * 2)), 
							  _wideButton, _buttonHeight );
		add(indexButton);
		indexButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				element_indexOfTF = ValidateText(indexField, lowNum, highNum, 
												 listSize, true, "element");
				if(active_button == _noButton) {
					IndexOf();
				}
			}
		});
		
		// index textfield
		indexField = new TextField("0");
		index1Y = _optionY + ((_buttonHeight + _10filler) * 2) + 40;
		index1X = _optionX + (_wideButton + _10filler);
		indexField.setBounds(index1X, index1Y - 30, 
							 _wideButton, _buttonHeight );
		add(indexField);

		// insert
		insertButton = new Button("add");
		index2Y = _optionY + ((_buttonHeight + _10filler) * 3) + 50;
		insertButton.setBounds(_optionX, index2Y - 30,
							   _wideButton, _buttonHeight);
		add(insertButton);
		insertButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton) {
					if(listSize == _maxListSize)
							messageCenter.append("for demonstration purposes the list size is limited to 40\n");
					else {
						element_insertTF = ValidateText(insertField1, lowNum, highNum, 
														listSize, false, "element");
						index_insertTF = ValidateText(insertField2, lowNum, listSize, 
													  listSize, false, "index");
						if(index_insertTF == listSize) {
							active_button = _insertRear;
							InsertElementAtRear();
						}// end if
						else {
							active_button = _insert;
							InsertElementAt();
						}// end else
					}// end else
				}// end if
			}// end mousePressed()
		});

		// insert textfield 1
		insertField1 = new TextField("0");
		index3X = _optionX + _wideButton + _10filler + _wideButton / 2 + 5;
		insertField1.setBounds(index3X, index2Y - 30, _wideButton / 2 - 5, _buttonHeight);
		add(insertField1);

		// insert textfield 2
		insertField2 = new TextField("0");
		index2X = _optionX + _wideButton + _10filler;
		insertField2.setBounds(index2X, index2Y - 30, _wideButton / 2, _buttonHeight);
		add(insertField2);

		
		// remove
		removeButton = new Button("remove");
		index3Y = _optionY + ((_buttonHeight + _10filler) * 4) + 60;
		removeButton.setBounds(_optionX, index3Y - 30, _wideButton, _buttonHeight);
		add(removeButton);
		removeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton){
					index_removeTF = ValidateText(removeField, 0, listSize - 1, listSize, true, "index");
					if(index_removeTF != -1) {	
						if(!IsEmpty()) {
							if(index_removeTF == listSize - 1) {
								active_button = _removeRear;
								RemoveRear();
							}
							else {
								active_button = _remove;
								RemoveElementAt();
							}
						}
						else messageCenter.append("List is empty, there is nothing to remove\n");
					}
				}
			}
		});

		// remove textfield
		removeField = new TextField("0");
		index4X = _optionX + _wideButton + _10filler;
		removeField.setBounds(index4X, index3Y - 30, _wideButton, _buttonHeight);
		add(removeField);
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_displayX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		
		// create a display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// display program name and bobo games logo
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(chain, 10, 10, this);
		
		// draw these strings to the buffer
		bufferGraphics.setColor(Color.white);
		bufferGraphics.drawString("e  l  e  m  e  n  t", index1X + 15, index1Y + 5);
		bufferGraphics.drawString("index", index2X + 9, index2Y + 5);
		bufferGraphics.drawString("element", index3X + 7, index2Y + 5);
		bufferGraphics.drawString("i  n  d  e  x", index4X + 25, index3Y + 5);
		bufferGraphics.drawString("i  n  d  e  x", _optionX + _wideButton + 35, 
								  _optionY + 35 + ((_buttonHeight + _10filler)));
		
		bufferGraphics.setColor(Color.black);
		
		// draw all of the boxes to buffer
		for(int i = 0; i < 4; i++) {
			for(int j = 0; j < 10; j++) {
				box[j][i].draw(bufferGraphics, this, (j + (10 * i)), listSize, oneLinkBox, twoLinkBox);
			}// end for
		}// end for
		
		// draw these lines to connect the end of a row and the beggining of the next row
		if(listSize > 30) {
			bufferGraphics.drawLine(569, 167, 569, 205);
			bufferGraphics.drawLine(569, 205, 277, 205);
		}
		if(listSize > 20) {
			bufferGraphics.drawLine(569, 112, 569, 150);
			bufferGraphics.drawLine(569, 150, 277, 150);
		}
		if(listSize > 10) {
			bufferGraphics.drawLine(569, 57, 569, 95);
			bufferGraphics.drawLine(569, 95, 277, 95);
		}

		// draw the null box and first node pointer
		Point pos = new Point(0,0);
		if(listSize == 0) {
			getMatrixPos(0, pos);
			bufferGraphics.drawImage(nullBox, box[pos.x][pos.y].x, box[pos.x][pos.y].y, this);
		}
		else {
			getMatrixPos(listSize - 1, pos);
			bufferGraphics.drawImage(nullBox, box[pos.x][pos.y].x + 30, box[pos.x][pos.y].y, this);
		}
		// draw first node ptr
		getMatrixPos(0, pos);
		bufferGraphics.drawImage(firstNode, box[pos.x][pos.y].x - 15, box[pos.x][pos.y].y -22, this);
		
		// draw the buffer to the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			active_button = _noButton;
			repaint();	// repaint the screen
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for the image to be loaded before starting the applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
	
// showSize//////////////////////////////////////////////////////////
	public void showSize() {
		messageCenter.append("size = " +listSize+ "\n");
	}
	
// showIsEmpty///////////////////////////////////////////////////////
	public void showIsEmpty() {
		messageCenter.append("isEmpty = " +IsEmpty()+ "\n");
	}
	
// ShowElemAt////////////////////////////////////////////////////////
	public void showElemAt() {
		Point pos = new Point(0,0);
		getMatrixPos(index_elemAtTF, pos);
		messageCenter.append("The element at index " +index_elemAtTF+ " is " +box[pos.x][pos.y].value+ "\n");
	}
	
// IsEmpty///////////////////////////////////////////////////////////
	public boolean IsEmpty() {
		return listSize == 0;
	}
	
// IndexOf///////////////////////////////////////////////////////////
	public void IndexOf() {
		if(element_indexOfTF != -1) {// find index of element
			boolean found = false;
			Point currentBox = new Point(0,0);
			for(int i = 0; ( (i < listSize) && !found); i++) {
				getMatrixPos(i, currentBox);
				if(box[currentBox.x][currentBox.y].value == element_indexOfTF) {
					messageCenter.append("The element " +element_indexOfTF+ " is at index " + i + "\n");
					found = true;
				}// end if
			}// end for loop

			if(!found) // element was not in list
				messageCenter.append("The element " +element_indexOfTF+ " is not in the list\n");
		}// end if
	}// end IndexOf()

// RemoveElementAt///////////////////////////////////////////////////
	public void RemoveElementAt() {
		// remove the element at the given index
		if(index_removeTF != -1) {
			Point currentBox = new Point(0,0);
			Point nextBox = new Point(0,0);
			for(int i = index_removeTF; i < listSize; i++) {
				if(i == _maxListSize - 1) continue;
				getMatrixPos(i, currentBox);
				getMatrixPos(i + 1, nextBox);
				box[currentBox.x][currentBox.y].value = box[nextBox.x][nextBox.y].value;
			}
			box[currentBox.x][currentBox.y].state = _valueNotShowing;
			listSize--;
			active_button = _noButton;
		}// end if
	}// end RemoveElementAt()
	
// RemoveRear()//////////////////////////////////////////////////////
	public void RemoveRear() {
		// remove the element at the rear of the list
		if(index_removeTF != -1) {
			Point currentBox = new Point(0,0);
			getMatrixPos(index_removeTF, currentBox);
			box[currentBox.x][currentBox.y].state = _valueNotShowing;
			listSize--;
			active_button = _noButton;
		}
	}// end RemoveRear()
	
// InsertElementAt///////////////////////////////////////////////////
	public void InsertElementAt() {
		// insert an element at the given index
		if(index_insertTF != -1 && element_insertTF != -1){
			if(listSize >= _maxListSize) {
				messageCenter.append("For demonstration purposes list size is limited to 40\n");
			}
			else {
				Point currentBox = new Point(0,0);
				Point nextBox = new Point(0,0);
				for(int i = listSize; index_insertTF <= i; i--) {
					if(i == _maxListSize - 1) break;
					getMatrixPos(i, currentBox);
					getMatrixPos(i + 1, nextBox);
					box[nextBox.x][nextBox.y].value = box[currentBox.x][currentBox.y].value;
					box[nextBox.x][nextBox.y].state = _valueShowing;
				}
				// the spot we are inserting into should be open now
				getMatrixPos(index_insertTF, currentBox);
				box[currentBox.x][currentBox.y].value = element_insertTF;
				listSize++;
				active_button = _noButton;
			}// end else
		}// end if
	}// end InsertElementAt()
	
// InsertElementAtRear()/////////////////////////////////////////////
	public void InsertElementAtRear() {
		// insert an element at the rear of the list
		if(index_insertTF != -1 && element_insertTF != -1) {		
			Point currentBox = new Point(0,0);
			getMatrixPos(listSize, currentBox);
			box[currentBox.x][currentBox.y].value = element_insertTF;
			box[currentBox.x][currentBox.y].state = _valueShowing;
			listSize++;
			active_button = _noButton;
		}
	}
	
// getMatrixPos//////////////////////////////////////////////////////
	public void getMatrixPos(int cnt, Point pt){
		pt.y = cnt / 10;
		pt.x = cnt % 10;
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if the text is valid assign it the value
		// else assign it the value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

}// end LinearList class