/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to ineract 
 * with and see the workings of an array linear list
 * @version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;


// B O X   C L A S S/////////////////////////////////////////////////
class Box {
	int x,
		y,
		index,
		state,			// 0 == !showing, 1 = showing w/out value, 2 = showing w/ value
		indexX,
		indexY,
		infoX,
		infoY,
		value;
		boolean highlighted = false;

	// constructor
	Box(int x, int y, int index, int state, int indexX, int indexY,
		int infoX, int infoY, Image yEB, Image eB, Image yFB, Image fB) { 
		this.x = x;
		this.y = y;
		this.state = state;
		this.indexX = indexX;
		this.indexY = indexY;
		this.infoX = infoX;
		this.infoY = infoY;
		this.value = 0;		// default value
		highlighted = false;		
	}
	
	// draw the box to the given buffer
	public void draw(Graphics graphics, Applet applet, int index, Image yEB, Image eB, 
					 Image yFB, Image fB) {
		Color old_color = graphics.getColor();
		if(this.state == 1) {// showing w/out value
			if(this.highlighted) {
				graphics.drawImage(yEB, this.x, this.y, applet);
				this.highlighted = false;
			}
			else graphics.drawImage(eB, this.x, this.y, applet);
			if(this.index < 10)
				graphics.drawString("" +index, this.indexX - 2, this.indexY);
			else
				graphics.drawString("" +index, this.indexX, this.indexY);
		}
		if(this.state == 2) {// showing w/ value
			if(this.highlighted) {
				graphics.drawImage(yFB, this.x, this.y, applet);
				this.highlighted = false;
			}
			else graphics.drawImage(fB, this.x, this.y, applet);

			if(this.index < 10)
				graphics.drawString("" +index, this.indexX - 2, this.indexY);
			else
				graphics.drawString("" +index, this.indexX, this.indexY);

			graphics.setColor(Color.white);
			if(this.value  <= 9)
				graphics.drawString("" +this.value, this.infoX + 2, this.infoY);
			else if(this.value <= 99)
				graphics.drawString("" +this.value, this.infoX, this.infoY);
			else graphics.drawString("" +this.value, this.infoX, this.infoY);
			graphics.setColor(old_color);
		}
	}// end public void draw
}

public class ArrayLL extends Applet implements Runnable 
{
	// critical values for GUI and animation
	final int _optionX		= 20,
			 _optionY		= 50,
			 _buttonY		= _optionY + 55,
			 _buttonHeight	= 23,
			 _wideButton	= 100,
			 _narrowButton	= 70,
			 _5filler		= 5,
			 _10filler		= 10,
			 _displayX		= _optionX + 220 + _10filler,
			 _displayY		= _10filler * 2,
			 _displayWidth	= 340,
			 _displayHeight	= 217,
			 _displayBarX	= _displayX + _displayWidth,
			 _displayBarY	= _displayY,
			 _listX			= _displayX + 20,
			 _listY			= _displayY + 20,
			 _boxWidth		= 30,
			 _boxHeight		= 25,
			 _messageWidth	= _displayWidth,
			 _messageHeight = 150,
			 _messageY		= _displayY + _displayHeight + _10filler + _5filler,
			 _notShowing	= 0,
			 _valueNotShowing	= 1,
			 _valueShowing	= 2,
			 _noButton		= 0,
			 _indexOf		= 1,
			 _remove		= 2,
			 _removeRear	= 3,
			 _insert		= 4,
			 _insertRear	= 5;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, llist, y_llbox, full_llbox, empty_llbox, y_empty_llbox, y_full_llbox;
	
	// interface peices
	TextField indexField, insertField1, insertField2, removeField, elemAtField;
	TextArea messageCenter;
	Button sizeButton, emptyButton, indexButton, elemAtButton,
		   insertButton, removeButton, pauseButton, continueButton;
	Scrollbar speedBar;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// used during animation
	Point leftBox  = new Point(0,0);
	Point rightBox = new Point(0,0);
	
	// box info
	Box [][] box;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	int frameRate = 10;	// animation spped
	int active_button = _noButton;
	boolean animating = false;
	
	int listSize = 0,
		absListSize = 10;
	
	int animationCnt = 0;
	
	// hold values for text fields
	int element_indexOfTF = 0,
		index_removeTF = 0,
		index_insertTF = 0,
		element_insertTF = 0, 
		index_elemAtTF = 0;
	
	// range of valid values for textfield data
	int	lowNum = 0,
		highNum = 99;
	
	// used during creation of GUI
	int index1Y = 0,
		index2Y = 0,
		index3Y = 0,
		index1X = 0,
		index2X = 0,
		index3X = 0,
		index4X = 0;
	
	// used to keep track of animation
	int methodCallCnt = 0;
	// has user paused the applet?
	boolean pause = false;
			
	public void init() {
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();
		
		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bg.gif");
		waitForImage(this, boboGames);
		llist	= this.getImage(this.getCodeBase(), "llist.gif");
		waitForImage(this, llist);
		full_llbox	= this.getImage(this.getCodeBase(), "full_llbox.gif");
		waitForImage(this, full_llbox);
		empty_llbox	= this.getImage(this.getCodeBase(), "empty_llbox.gif");
		waitForImage(this, empty_llbox);
		y_empty_llbox	= this.getImage(this.getCodeBase(), "y_empty_llbox.gif");
		waitForImage(this, y_empty_llbox);
		y_full_llbox	= this.getImage(this.getCodeBase(), "y_full_llbox.gif");
		waitForImage(this, y_full_llbox);

		for(int i = 0; i < 10; i++) box = new Box [i][];		

		box = new Box [10][4];
		// allocate/initailize box info storage
		int x, y, index, indexX, indexY, infoX, infoY, state;
		for(int i = 0; i < 4; i ++) {	
			for(int j = 0; j < 10; j++) {
				x = _displayX + 20 + j * _boxWidth;
				y = _displayY + 20 + (i * 45);
				if(i == 0) {
					indexX = x + 15;
					state = _valueNotShowing;	// no value showing
				}
				else {
					indexX = x + 9;
					state = _notShowing;
				}
				indexY = y + 35;
				infoX = x + 10;
				infoY = y + 17;				
				index = j + (10 * i);
				box[j][i] = new Box(x, y, index, state, indexX, indexY, infoX, infoY, y_empty_llbox, empty_llbox, 
									y_full_llbox, full_llbox);
			}// end for
		}// end for

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		// empty
		emptyButton = new Button("isEmpty");
		emptyButton.setBounds(_optionX, _optionY, 
							  _wideButton, _buttonHeight);
		add(emptyButton);
		emptyButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _noButton)
					showIsEmpty(); 
			}
		});

		// size
		sizeButton = new Button("size");
		sizeButton.setBounds(_optionX, _optionY + ((_buttonHeight + _10filler)), 
							  _wideButton, _buttonHeight);
		add(sizeButton);
		sizeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button == _noButton) 
					messageCenter.append("size = " +listSize+ "\n");
			}
		});

		// elemAt
		elemAtButton = new Button("get");
		elemAtButton.setBounds(_optionX, _optionY + ((_buttonHeight + _10filler) * 2), 
							  _wideButton, _buttonHeight);
		add(elemAtButton);
		elemAtButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
					index_elemAtTF = ValidateText(elemAtField, lowNum, listSize - 1, listSize, true,  "index");
				if(active_button == _noButton) {
					if(index_elemAtTF != -1) 
						showElemAt(); 
				}// end if
			}
		});

		// elem at textfield
		elemAtField = new TextField("0");
		elemAtField.setBounds(_optionX + _wideButton + _10filler, 
							  _optionY + ((_buttonHeight + _10filler) * 2), 
							  _wideButton, _buttonHeight);
		add(elemAtField);
		
		// index
		indexButton = new Button("indexOf");
		indexButton.setBounds(_optionX, (_optionY + 10 + ((_buttonHeight + _10filler) * 3)), 
							  _wideButton, _buttonHeight );
		add(indexButton);
		indexButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton) {
					element_indexOfTF = ValidateText(indexField, lowNum, highNum, 
													 listSize, true, "element");
					active_button = _indexOf;
					animationCnt = 0;
				}
			}
		});
		
		// index textfield
		indexField = new TextField("0");
		index1Y = _optionY + ((_buttonHeight + _10filler) * 3) + 50;
		index1X = _optionX + (_wideButton + _10filler);
		indexField.setBounds(index1X, index1Y - 40, 
							 _wideButton, _buttonHeight );
		add(indexField);

		// insert
		insertButton = new Button("add");
		index2Y = _optionY + ((_buttonHeight + _10filler) * 4) + 60;
		insertButton.setBounds(_optionX, index2Y - 40,
							   _wideButton, _buttonHeight);
		add(insertButton);
		insertButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton) {
					element_insertTF = ValidateText(insertField1, lowNum, highNum, 
													absListSize, false, "element");
					index_insertTF = ValidateText(insertField2, lowNum, listSize,
												  absListSize, false, "index");
					animationCnt = 0;
					if(index_insertTF == listSize) {
						active_button = _insertRear;
						animationCnt = 2;
					}// end if
					else {
						active_button = _insert;
						animationCnt = (listSize - index_insertTF) * 2;
					}// end else

					if(listSize + 1 > absListSize) {
						if(absListSize == 40) {
							messageCenter.append("for demonstration purposes the list size is limited to 40\n");
							active_button = _noButton;
						}
						else {
							messageCenter.append("list size being doubled\n");
							if(absListSize == 10) {
								for(int i = 0 ; i < 10; i++) box[i][1].state = 1;
								absListSize = 20;
							}
							else if (absListSize == 20) {
								for(int i = 0; i < 10; i++) {
									box[i][2].state = 1;
									box[i][3].state = 1;
								}// end for
								absListSize = 40;
							}// end else if
						}// end else
					}// end if
				}// end if
			}// end mousePressed()
		});

		// inset textfield 1
		insertField1 = new TextField("0");
		index3X = _optionX + _wideButton + _10filler + _wideButton / 2 + 5;
		insertField1.setBounds(index3X, index2Y - 40, _wideButton / 2 - 5, _buttonHeight);
		add(insertField1);

		// inset textfield 2
		insertField2 = new TextField("0");
		index2X = _optionX + _wideButton + _10filler;
		insertField2.setBounds(index2X, index2Y - 40, _wideButton / 2, _buttonHeight);
		add(insertField2);
		
		// remove
		removeButton = new Button("remove");
		index3Y = _optionY + ((_buttonHeight + _10filler) * 5) + 70;
		removeButton.setBounds(_optionX, index3Y - 40, _wideButton, _buttonHeight);
		add(removeButton);
		removeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if(active_button == _noButton){
					index_removeTF = ValidateText(removeField, 0, listSize - 1, 
												  listSize, true, "index");
					if(index_removeTF != -1) {	
						if(!IsEmpty()) {
							animationCnt = 0;
							if(index_removeTF == listSize - 1) active_button = _removeRear;
							else active_button = _remove;
						}
						else messageCenter.append("List is empty, there is nothing to remove\n");
					}
				}
			}
		});

		// remove textfield
		removeField = new TextField("0");
		index4X = _optionX + _wideButton + _10filler;
		removeField.setBounds(index4X, index3Y - 40, _wideButton, _buttonHeight);
		add(removeField);
		
		// pause
		pauseButton = new Button("pause");
		pauseButton.setBounds(_optionX, _optionY + ((_buttonHeight + _10filler) * 7),
							  _wideButton, _buttonHeight);
		add(pauseButton);
		pauseButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(active_button != _noButton) { 
					remove(pauseButton);
					add(continueButton);
					pause = true;
					messageCenter.append("To continue, press continue...\n");
				}
				else {
					toolkit.beep(); 
					messageCenter.append("Cannot pause now...\n");
				}
			}
		});
		
		// continue
		continueButton = new Button("continue");
		continueButton.setBounds(_optionX, _optionY + ((_buttonHeight + _10filler) * 7),
							  _wideButton, _buttonHeight);
		continueButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				remove(continueButton);
				add(pauseButton);
				pause = false;
			}
		});

		// speed adjustment
		speedBar = new Scrollbar(Scrollbar.HORIZONTAL, 10, 0, 1, 30);
		speedBar.setBounds(_optionX, _messageY + _messageHeight - 15,
						   _wideButton * 2 + _10filler, _buttonHeight - 6);
		add(speedBar);
		speedBar.setValue(10);
		speedBar.addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent e) {
				frameRate = e.getValue();
			}
		});	
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_displayX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		// fill the screen with black
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		
		// create display area
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		// display program name and bobo games logo
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(llist, 25, 10, this);
		
		bufferGraphics.setColor(Color.white);
		//display animation speed
		bufferGraphics.drawString("Speed = " +frameRate+ " frames/sec", _optionX + 50,
								  _messageY + _messageHeight - _buttonHeight);
		
		// draw these strings to the screen
		bufferGraphics.drawString("i  n  d  e  x", 155, 152);
		bufferGraphics.drawString("e  l  e  m  e  n  t", index1X + 15, index1Y - 5);
		bufferGraphics.drawString("index", index2X + 9, index2Y - 5);
		bufferGraphics.drawString("element", index3X + 7, index2Y - 5);
		bufferGraphics.drawString("i  n  d  e  x", index4X + 25, index3Y - 5);
		
		// legend
		bufferGraphics.drawImage(full_llbox, 125, 320, this);
		bufferGraphics.drawString("Full Box", 160, 340);
		bufferGraphics.drawImage(empty_llbox, 20, 320, this);
		bufferGraphics.drawString("Empty Box", 55, 340);

		bufferGraphics.setColor(Color.black);
		
		// draw all of the boxes to the buffer
		for(int i = 0; i < 4; i++) {
			for(int j = 0; j < 10; j++) {
				box[j][i].draw(bufferGraphics, this, (j + (10 * i)), y_empty_llbox,
							   empty_llbox, y_full_llbox, full_llbox);
			}// end for
		}// end for
		
		// draw the buffer to the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(true) {
			start = System.currentTimeMillis();
			if(!pause) {
				// if any buttons are active call them to continue animation sequence
				if(active_button == _indexOf) { IndexOf(); }
				if(active_button == _remove) { RemoveElementAt(); }
				if(active_button == _insert) { InsertElementAt(); }
				if(active_button == _insertRear) { InsertElementAtRear(); }
				if(active_button == _removeRear) { RemoveRear(); }
			}
			repaint();	// repaint the screen
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
		animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for the image to be loaded before starting the applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
	
// showSize//////////////////////////////////////////////////////////
	public void showSize() {
		messageCenter.append("size = " +listSize+ "\n");
	}
	
// showIsEmpty///////////////////////////////////////////////////////
	public void showIsEmpty() {
		messageCenter.append("isEmpty = " +IsEmpty()+ "\n");
	}
	
// ShowElemAt////////////////////////////////////////////////////////
	public void showElemAt() {
		if(index_elemAtTF != -1) {
			Point pos = new Point(0,0);
			getMatrixPos(index_elemAtTF, pos);
			messageCenter.append("The element at index " +index_elemAtTF+ " is " +box[pos.x][pos.y].value+ "\n");
		}// end if
	}

	
// IsEmpty///////////////////////////////////////////////////////////
	public boolean IsEmpty() {
		return listSize == 0;
	}
	
// IndexOf///////////////////////////////////////////////////////////
	public void IndexOf() {
		if(element_indexOfTF == -1) 
			active_button = _noButton;
		else {// find index of element
			if( animationCnt > ((listSize - 1) * 2) | (listSize == 0)) {
				messageCenter.append("The element " +element_indexOfTF+ " is not in the list\n");
				active_button = _noButton;
			}// end if
			if(animationCnt % 2 == 0) {
				getMatrixPos((animationCnt / 2), leftBox);
				box[leftBox.x][leftBox.y].highlighted = true;
			}// end if
			else if(animationCnt % 2 == 1) {
				if(box[leftBox.x][leftBox.y].value == element_indexOfTF) {
					messageCenter.append("The index of element " +element_indexOfTF+ " is at index " +(animationCnt / 2)+ "\n");
					active_button = _noButton;
				}// end if
			}// end else if
			animationCnt++;
		}// end else
	}// end IndexOf()

// RemoveElementAt///////////////////////////////////////////////////
	public void RemoveElementAt() {
		// remove the element at the given index
		if(index_removeTF == -1) 
			active_button = _noButton;
		else {
			if( animationCnt < (( (listSize - 1) - index_removeTF) * 2) ) {
				if(animationCnt % 2 == 0) {
					getMatrixPos( (index_removeTF + (animationCnt / 2) ), leftBox);
					if(leftBox.x == 9 && leftBox.y == 3) {} // at end of list
					else getMatrixPos( (index_removeTF + (animationCnt / 2) + 1), rightBox);
					box[leftBox.x][leftBox.y].highlighted = true;
					box[leftBox.x][leftBox.y].state = _valueShowing;
					animationCnt++;
				}// end if
				if(animationCnt % 2 == 1) {
					box[leftBox.x][leftBox.y].value = box[rightBox.x][rightBox.y].value;
					box[rightBox.x][rightBox.y].state = _valueNotShowing;
					animationCnt++;
				}// end if
			}// end if
			else {
				box[leftBox.x][leftBox.y].state = _valueShowing;
				active_button = _noButton;
				listSize--;
			}// end else
		}// end else
	}// end RemoveElementAt()
	
// RemoveRear()//////////////////////////////////////////////////////
	public void RemoveRear() {
		// remove the element at the rear of the list
		if(index_removeTF == -1) 
			active_button = _noButton;
		else {
			getMatrixPos(index_removeTF, rightBox);
			if(animationCnt == 0) {
				box[rightBox.x][rightBox.y].highlighted = true;
			}
			if(animationCnt == 1) {
				box[rightBox.x][rightBox.y].state = _valueNotShowing;
				listSize--;
				active_button = _noButton;
			}
		}// end else
		animationCnt++;
	}// end RemoveRear()
	
// InsertElementAt///////////////////////////////////////////////////
	public void InsertElementAt() {
		// insert an element at the given location
		if(index_insertTF == -1 || element_insertTF == -1)
			active_button = _noButton;
		else {
			if(animationCnt < 1) {
				box[leftBox.x][leftBox.y].value = element_insertTF;
				box[leftBox.x][leftBox.y].state = _valueShowing;
				active_button = _noButton;
				listSize++;
			}// end if
			else {// need to move elements to right, make space for insertion		
			   if(animationCnt%2 == 0) {// highlight box to move right
					// get the position of the 2 boxes we will be working with during this sequence
					getMatrixPos( ( index_insertTF + ((animationCnt - 2)/2) ), leftBox);
					getMatrixPos( ( index_insertTF + ((animationCnt) / 2) ), rightBox);
					box[leftBox.x][leftBox.y].highlighted = true;
					animationCnt--;
				}// end if
				else {
					box[leftBox.x][leftBox.y].state = _valueNotShowing;
					if(rightBox.x <= listSize) 
						box[rightBox.x][rightBox.y].state = _valueShowing;
					else
						box[rightBox.x][rightBox.y].state = _valueNotShowing;
					box[rightBox.x][rightBox.y].value = box[leftBox.x][leftBox.y].value;
					animationCnt--;
				}// end else
			}// end else
		}// end else
	}// end InsertElementAt()
	
// InsertElementAtRear()/////////////////////////////////////////////
	public void InsertElementAtRear() {
		// insert an element in to the rear of the list
		if(index_insertTF == -1 || element_insertTF == -1) 
			active_button = _noButton;
		else {		
			if(animationCnt == 2) {
				getMatrixPos(listSize, rightBox);
				box[rightBox.x][rightBox.y].highlighted = true;
				animationCnt--;
			}
			else {
				box[rightBox.x][rightBox.y].state = _valueShowing;
				box[rightBox.x][rightBox.y].value = element_insertTF;
				listSize++;
				active_button = _noButton;
			}
		}// end else
	}
	
// getMatrixPos//////////////////////////////////////////////////////
	public void getMatrixPos(int cnt, Point pt){
		pt.y = cnt / 10;
		pt.x = cnt % 10;
	}
		
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// if text is valid assign it the correct value
		// else assign it the value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}

}// end LinearList class