/**@author Chris Bobo -=BOBO GAMES=-
 * copyright 1999 all rights reserved -=BOBO GAMES=-
 * this is an applet which allows users to see and interact with
 * the workings of an abstract graph
 * @version 1.0
 */
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.awt.Toolkit;
import java.util.*;


class AdjacencyGraph {
	int n;
	int e;
	boolean [][] a;
	
	// constructors
	public AdjacencyGraph() {}
	
	public AdjacencyGraph(int theVertices) {
		n = theVertices;
		a = new boolean[n + 1][n + 1];
	}
	
	// return number of vertices
	public int vertices() { return n; }
	
	// return number of edges
	public int edges() { return e; }
	
	// does this edge exist?
	public boolean existsEdge(int i, int j) { return a[i][j]; }
	
	// create an edge
	public void putEdge(int i, int j, TextArea t) {
		if(i == j)
			t.append("Error, a node may not be linked to itself.\n");
		else if(!a[i][j]) {
			a[i][j] = a[j][i] = true;
			e++;
		}
	}
	
	// remove an edge
	public void removeEdge(int i, int j) {
		if(a[i][j]) {
			a[i][j] = a[j][i] = false;
			e--;
		}
	}
	
	// what is the degree of vertex v?
	public int degree(int v) {
		int degree = 0;
		for(int i = 1; 1 <= n; i++) {
			if(a[i][v])
				degree++;
		}
		return degree;
	}
}

// B E G I N N I N G   O F    A P P L E T   C O D E//////////////////

public class AbstractGraph extends Applet implements Runnable 
{
	// critical values for applets GUI and animation
	public final int _maxValue		= 99,
					 _minValue		= 0,
					 _displayX		= 210,
					 _displayY		= 20,
					 _displayHeight	= 300,
					 _displayWidth	= 400,
					 _messageX		= _displayX,
					 _messageY		= _displayY + _displayHeight + 10,
					 _messageHeight	= 150,
					 _messageWidth	= _displayWidth,
					 _buttonsX		= 20,
					 _buttonsY		= 50,
					 _buttonHeight	= 25,
					 _wideButton	= 80,
					 _buttonSpacer	= _buttonHeight + 15,
					 _choiceDescriptX	= 128,
					 _choiceDescriptY	= 83;
	
	// doublebuffer
	Image buffer;
	Graphics bufferGraphics;
	Dimension bufferSize;
	
	// images
	Image boboGames, programName, node1, node2, node3, node4;
	
	// interface peices
	Choice createChoice, existChoiceI, existChoiceJ, addChoiceI, addChoiceJ, 
		   deleteChoiceI, deleteChoiceJ, degreeChoice, outDegreeChoice;
	TextArea messageCenter;
	Button createButton, existButton, edgesButton, verticesButton, addButton, 
		   deleteButton, degreeButton, outDegreeButton;

	
	// animation thread
	Thread animation;
	
	// let's us use system dependant properties
	Toolkit toolkit;
	
	// applet size on screen
	Dimension appletSize;
	
	// set font so applet has the same look on different systems
	Font f = new Font("TimesRoman", Font.PLAIN, 12);
	
	// size of selected graph
	int currGraphSize = 0;
	
	// animation speed
	int frameRate = 33;
	// which button has been pressed?
	boolean button_active = false;
	
	AdjacencyGraph [] graph;

	// holds data from textfields
	int element_searchTF, element_insertTF, element_deleteTF;
	
	// initialize the applet
	public void init() {
		// objects must be placed manually
		setLayout(null);
		
		// set up doublebuffer
		// make buffer size fo updatable screen portion
		bufferSize = this.getSize();
		buffer = this.createImage(bufferSize.width, bufferSize.height);
		bufferGraphics = buffer.getGraphics();

		// load images for applet
		boboGames	= this.getImage(this.getCodeBase(), "bgGif.gif");
		waitForImage(this, boboGames);
		programName	= this.getImage(this.getCodeBase(), "program_name.gif");
		waitForImage(this, programName);
		node1	= this.getImage(this.getCodeBase(), "node_1.gif");
		waitForImage(this, node1);
		node2	= this.getImage(this.getCodeBase(), "node_2.gif");
		waitForImage(this, node2);
		node3	= this.getImage(this.getCodeBase(), "node_3.gif");
		waitForImage(this, node3);
		node4	= this.getImage(this.getCodeBase(), "node_4.gif");
		waitForImage(this, node4);

		// get applet size on window
		appletSize = this.getSize();
		
		// get a system Toolkit
		toolkit = this.getToolkit();
		
		// set fonts
		this.setFont(f);
		bufferGraphics.setFont(f);
		
		// create an array of 4 different graphs each with a different number of nodes
		graph = new AdjacencyGraph[4];
		for(int i = 0; i < 4; i++)
			graph[i] = new AdjacencyGraph(i + 1);
		
		// Create button and choices
		createButton = new Button("create");
		createButton.setBounds(_buttonsX, _buttonsY, _wideButton, _buttonHeight);
		add(createButton);
		createButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					button_active = true;
					// first we clear all choices of current items
					ClearChoices(existChoiceI);
					ClearChoices(existChoiceJ);
					ClearChoices(addChoiceI);
					ClearChoices(addChoiceJ);
					ClearChoices(deleteChoiceI);
					ClearChoices(deleteChoiceJ);
					ClearChoices(degreeChoice);

					currGraphSize = createChoice.getSelectedIndex() + 1;
					// add selected number of choices to all choice menus
					AddChoices(existChoiceI, currGraphSize);
					AddChoices(existChoiceJ, currGraphSize);
					AddChoices(addChoiceI, currGraphSize);
					AddChoices(addChoiceJ, currGraphSize);
					AddChoices(deleteChoiceI, currGraphSize);
					AddChoices(deleteChoiceJ, currGraphSize);
					AddChoices(degreeChoice, currGraphSize);
				}
			}
		});
		
		// createChoice
		createChoice = new Choice();
		createChoice.setBounds(_buttonsX + _wideButton + 10, _buttonsY, _wideButton + 10, _buttonHeight);
		add(createChoice);
		AddChoices(createChoice, 4);

		// Exists button and choices
		existButton = new Button("exist edge");
		existButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer, _wideButton, _buttonHeight);
		add(existButton);
		existButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					button_active = true;
					int i = existChoiceI.getSelectedIndex() + 1;
					int j = existChoiceJ.getSelectedIndex() + 1;
					if(graph[currGraphSize - 1].existsEdge(i, j))
						messageCenter.append("There is an edge between the vertices (" +i+ "," +j+ ")\n");
					else
						messageCenter.append("There is not an edge between the vertices (" +i+ "," +j+ ")\n");
				}
			}
		});
		
		// exists choice i
		existChoiceI = new Choice();
		existChoiceI.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer, 
							   _wideButton / 2, _buttonHeight);
		add(existChoiceI);

		// exists choice j
		existChoiceJ = new Choice();
		existChoiceJ.setBounds( (int) (_buttonsX + (_wideButton * 1.5) + 20), _buttonsY + _buttonSpacer, 
							   _wideButton / 2, _buttonHeight);
		add(existChoiceJ);
		
		// Edges button 
		edgesButton = new Button("edges");
		edgesButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 2, _wideButton, _buttonHeight);
		add(edgesButton);
		edgesButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					if(currGraphSize > 0)
						messageCenter.append("There are " +graph[currGraphSize - 1].edges()+ " edges in this graph\n");
				}
			}
		});

		// Vertices button
		verticesButton = new Button("vertices");
		verticesButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 3, _wideButton, _buttonHeight);
		add(verticesButton);
		verticesButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					if(currGraphSize > 0)
						messageCenter.append("There are " +graph[currGraphSize - 1].vertices()+ " vertices in this graph\n");
				}
			}
		});
		
		// Add button and choices
		addButton = new Button("put edge");
		addButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 4, _wideButton, _buttonHeight);
		add(addButton);
		addButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					if(currGraphSize > 0) {
						int i = addChoiceI.getSelectedIndex() + 1;
						int j = addChoiceJ.getSelectedIndex() + 1;
						if(i == j) messageCenter.append("A node can not be linked to itself\n");
						else if(graph[currGraphSize - 1].existsEdge(i, j)) 
							messageCenter.append("The edge (" +i+ "," +j+ ") already exists.\n");
						else // add edge
							graph[currGraphSize - 1].putEdge(i, j, messageCenter);
					}
				}
			}
		});
		
		// add choice
		addChoiceI = new Choice();
		addChoiceI.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer * 4, 
							   _wideButton / 2, _buttonHeight);
		add(addChoiceI);

		addChoiceJ = new Choice();
		addChoiceJ.setBounds( (int) (_buttonsX + (_wideButton * 1.5) + 20), _buttonsY + _buttonSpacer * 4, 
							   _wideButton / 2, _buttonHeight);
		add(addChoiceJ);
		
		// Delete button and choices
		deleteButton = new Button("remove edge");
		deleteButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 5, _wideButton, _buttonHeight);
		add(deleteButton);
		deleteButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(!button_active) {
					if(currGraphSize > 0) {
						int i = deleteChoiceI.getSelectedIndex() + 1;
						int j = deleteChoiceJ.getSelectedIndex() + 1; 
						if(!graph[currGraphSize - 1].existsEdge(i, j))
							messageCenter.append("That edge does not exist\n");
						else // remove edge
							graph[currGraphSize - 1].removeEdge(i, j);
					}
				}
			}
		});
		
		// delete choice i
		deleteChoiceI = new Choice();
		deleteChoiceI.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer * 5, 
							   _wideButton / 2, _buttonHeight);
		add(deleteChoiceI);

		// delete choice j
		deleteChoiceJ = new Choice();
		deleteChoiceJ.setBounds( (int) (_buttonsX + (_wideButton * 1.5) + 20), _buttonsY + _buttonSpacer * 5, 
							   _wideButton / 2, _buttonHeight);
		add(deleteChoiceJ);
		
		// Indegree button and choice
		degreeButton = new Button("degree");
		degreeButton.setBounds(_buttonsX, _buttonsY + _buttonSpacer * 6, _wideButton, _buttonHeight);
		add(degreeButton);
		degreeButton.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) { 
				if(currGraphSize > 0) {
					int i = degreeChoice.getSelectedIndex() + 1;
					CountEdges(i, currGraphSize - 1);
				}
			}
		});
		
		// degree choice
		degreeChoice = new Choice();
		degreeChoice.setBounds(_buttonsX + _wideButton + 10, _buttonsY + _buttonSpacer * 6, 
							   _wideButton / 2, _buttonHeight);
		add(degreeChoice);
		
		// message center
		messageCenter = new TextArea();
		messageCenter.setBounds(_messageX, _messageY, _messageWidth, _messageHeight);
		messageCenter.setEditable(true);
		messageCenter.append("All messages will appear here...\n");
		add(messageCenter);

	}// end init	
	
// P A I N T/////////////////////////////////////////////////////////	
	public void paint(Graphics g) {
		FillScreen(this.getSize(), bufferGraphics, Color.black);
		FillArea(_displayX + 2, _displayY + 2, _displayWidth - 3, _displayHeight - 3, 
				 bufferGraphics, Color.white);
		bufferGraphics.setColor(Color.gray);
		bufferGraphics.draw3DRect(_displayX, _displayY, _displayWidth, _displayHeight, false);
		
		bufferGraphics.drawImage(boboGames, appletSize.width - 110, appletSize.height - 25, this);
		bufferGraphics.drawImage(programName, 10, 10, this);
		
		// draw choice info under each Choice
		bufferGraphics.setColor(Color.white);
		bufferGraphics.drawString("# of vertices", _choiceDescriptX - 5, _choiceDescriptY);
		bufferGraphics.drawString("i", _choiceDescriptX, _choiceDescriptY + _buttonSpacer);
		bufferGraphics.drawString("j", _choiceDescriptX + 10 + _wideButton / 2,
								  _choiceDescriptY + _buttonSpacer);
		bufferGraphics.drawString("i", _choiceDescriptX, _choiceDescriptY + _buttonSpacer * 4);
		bufferGraphics.drawString("j", _choiceDescriptX + 10 + _wideButton / 2,
								  _choiceDescriptY + _buttonSpacer * 4);
		bufferGraphics.drawString("i", _choiceDescriptX, _choiceDescriptY + _buttonSpacer * 5);
		bufferGraphics.drawString("j", _choiceDescriptX + 10 + _wideButton / 2,
								  _choiceDescriptY + _buttonSpacer * 5);
		bufferGraphics.drawString("vertex", _choiceDescriptX - 12, _choiceDescriptY + _buttonSpacer * 6);
		

		// set drawing color to black
		bufferGraphics.setColor(Color.black);
		
		// draw graph
		DrawGraphs(bufferGraphics, this);
		
		// draw the buffer onto the screen
		g.drawImage(buffer, 0, 0, this);
}	
	
// U P D A T E///////////////////////////////////////////////////////	
	public void update(Graphics g) { paint(g); }

// R U N/////////////////////////////////////////////////////////////	
	public void run() {
		Thread thisThread = Thread.currentThread();
		long start = 0, sleep = 0;
		while(animation == thisThread) {
			start = System.currentTimeMillis();
			repaint();	// repaint the screen
			// only 1 button can be pressed during each cycle
			button_active = false;
			// sync repaints() from 1 - 30 fps
			sleep = frameRate - (int)(System.currentTimeMillis() - start);
			if(sleep <= 0) sleep = 1;	// never divide by zero
			sleep = 1000 / sleep;
			try { thisThread.sleep(sleep); }
			catch (InterruptedException e) {}
		}
	}
	
// S T A R T/////////////////////////////////////////////////////////	
	public void start() {
		if(animation == null)
			animation = new Thread(this);		
			animation.start();
	}
	
// S T O P///////////////////////////////////////////////////////////	
	public void stop() {
			animation = null;
	}

// W A I T   F O R   I M A G E///////////////////////////////////////	
    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
			// wait for image to load before starting applet
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch(InterruptedException e) { e.printStackTrace(); }
    }
	
// F I L L   S R E E N///////////////////////////////////////////////
	/**fill the screen(g refers to) with the specified color*/
	public void FillScreen(Dimension size, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(0, 0, size.width, size.height);
		g.setColor(old_color);
	}
	
// F I L L   A R E A/////////////////////////////////////////////////
	/**fill an area(g refers to) with the specified color*/
	public void FillArea(int x, int y, int _x, int _y, Graphics g, Color color) {
		Color old_color = g.getColor();
		g.setColor(color);
		g.fillRect(x, y, _x, _y);
		g.setColor(old_color);
	}
	
// ValidateText//////////////////////////////////////////////////////
	public int ValidateText(TextField field, int lowValue, int highValue, int listSize, 
							boolean invalidIfEmpty, String str) {
		// takes text from a textfield and checks its validity.
		// then if valid the data is assigned to a given variable
		// if not valid the variable is assigned a value of -1
		int fieldValue = -1;
		try {
			fieldValue = Integer.parseInt(field.getText());
		}
		catch (NumberFormatException e) {
			field.selectAll();
			fieldValue = -1;		// not valid
			toolkit.beep();
		}
		if(invalidIfEmpty) {
			if(listSize == 0) {
				fieldValue = -1;
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid because the list is currently empty\n");
			}
			else if(fieldValue < lowValue || fieldValue > highValue) {
				fieldValue = -1;		// not valid
				toolkit.beep();
				messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
				messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");			
			}
		}
		else if(fieldValue < lowValue || fieldValue > highValue) {
			fieldValue = -1;		// not valid
			toolkit.beep();
			messageCenter.append("The " +str+ " " +field.getText()+ " is not valid\n");
			messageCenter.append("The " +str+ " must be an integer between " +lowValue + " and " +highValue+ "\n");
		}
		return fieldValue;
	}
	
// AddChoices()/////////////////////////////////////////////////////
	public void AddChoices(Choice c, int z) {
		// add choices to a choices component
		for(int i = 1; i <= z; i++)
			c.add("" +i);
		c.select(0);
	}
	
// ClearChoices()////////////////////////////////////////////////////
	public void ClearChoices(Choice c) {
			c.removeAll();
	}
	
// CountEdges()//////////////////////////////////////////////////////
	public void CountEdges(int v, int g) {
		// counts the edges coming into or leavign a vertex
		// I couldnt get the datatype version of degree to work properly
		int edges = 0;
		for(int i = 1; i < (g + 2); i++) {
			if(graph[g].existsEdge(v, i))
			   edges++;			
		}
		messageCenter.append("Vertex " +v+ " has a degree of " +edges+ "\n");
	}
	
// DrawGraphs()//////////////////////////////////////////////////////
	public void DrawGraphs(Graphics g, Applet a) {
		// draw graph nodes and lines
		// the lines must be drawn before the nodes
		if(currGraphSize == 1)
			g.drawImage(node1, _displayX + 180, _displayY + 130, a);
		if(currGraphSize == 2) {
			if(graph[currGraphSize - 1].existsEdge(1, 2))
				g.drawLine(_displayX + 195, _displayY + 30, _displayX + 195, _displayY + 250);
			g.drawImage(node1, _displayX + 180, _displayY + 30, a);
			g.drawImage(node2, _displayX + 180, _displayY + 230, a);
		}
		if(currGraphSize == 3) {
			if(graph[currGraphSize - 1].existsEdge(1, 2))
				g.drawLine(_displayX + 187, _displayY + 55, _displayX + 97, _displayY + 240);
			if(graph[currGraphSize - 1].existsEdge(1, 3))
				g.drawLine(_displayX + 203, _displayY + 55, _displayX + 293, _displayY + 240);
			if(graph[currGraphSize - 1].existsEdge(2, 3))
				g.drawLine(_displayX + 110, _displayY + 245, _displayX + 285, _displayY + 245);
			g.drawImage(node1, _displayX + 180, _displayY + 30, a);
			g.drawImage(node2, _displayX + 80, _displayY + 230, a);
			g.drawImage(node3, _displayX + 280, _displayY + 230, a);
		}
		if(currGraphSize == 4) {
			if(graph[currGraphSize - 1].existsEdge(1, 2))
				g.drawLine(_displayX + 80, _displayY + 70, _displayX + 310, _displayY + 70);
			if(graph[currGraphSize - 1].existsEdge(1, 3))
				g.drawLine(_displayX + 70, _displayY + 80, _displayX + 70, _displayY + 210);
			if(graph[currGraphSize - 1].existsEdge(1, 4))
				g.drawLine(_displayX + 75, _displayY + 75, _displayX + 315, _displayY + 215);
			if(graph[currGraphSize - 1].existsEdge(2, 3))
				g.drawLine(_displayX + 310, _displayY + 77, _displayX + 75, _displayY + 215);
			if(graph[currGraphSize - 1].existsEdge(2, 4))
				g.drawLine(_displayX + 320, _displayY + 80, _displayX + 320, _displayY + 215);
			if(graph[currGraphSize - 1].existsEdge(3, 4))
				g.drawLine(_displayX + 80, _displayY + 220, _displayX + 315, _displayY + 220);
			g.drawImage(node1, _displayX + 55, _displayY + 55, a);
			g.drawImage(node2, _displayX + 305, _displayY + 55, a);
			g.drawImage(node3, _displayX + 55, _displayY + 205, a);
			g.drawImage(node4, _displayX + 305, _displayY + 205, a);
		}
	}

}// end BinarySearchTree class