/*************************************************************
                 TREE MODULE HEADER   -   Tree.h
**************************************************************/

/*

General purpose tree facility.  Tree is stored as a Stack,
in pre-order.

*/
#include <stdio.h>
#define NullTree 0

typedef int TreeNode;

extern Stack Tree,TreeOrchard;
extern FILE *Tree_File;
extern char *TreeFileName; 

extern InitializeTreeModule();
extern int NodeName();
extern ChangeNodeName();
extern int SourceLocation();
extern int Rank();
extern ReduceRank();
extern int Child();
extern ReduceChildren();
extern int BuildNode();
extern int ReadTrees();
extern int Read_Trees();
extern WriteTrees();
extern int RootOfTree();
extern PrintTree();
extern PrintForest();
extern Decorate();
extern int Decoration();
extern AddTree();
extern ReportTreeErrorAt();
