#if !defined(DLISTS_HEADER)
#define DLISTS_HEADER

/*************************************************************************
 * Generic linked list header file.  
 *
 *
 */

typedef struct DNode {
    struct DNode *next;
    struct DNode *prev;
} DNODE;


typedef struct DList {
    DNODE *head;
    DNODE *tail;
    int count;
} DLIST;

void InitDList(DLIST *list);
void DAddHead(DLIST *list, void *node);
void DAddTail(DLIST *list, void *node);
void DAddNth(DLIST *list, void *node, int nth);
void DInsert(DLIST *list, void *node, void *location);
void DEnqueue(DLIST *list, void *node, int (*compare)(void *, void *));

void DRemove(DLIST *list, void *node);
void *DRemHead(DLIST *list);
void *DRemTail(DLIST *list);

void FreeDList(DLIST *list, void (*release)(void *));

void *DNth(DLIST *list, int nth);
#define DHead(x)   ((void *)((x)->head))
#define DTail(x)   ((void *)((x)->tail))
#define DCount(x)  ((x)->count) 
#define DNext(x)   (((void *)((DNODE *)(x))->next))
#define DPrev(x)   (((void *)((DNODE *)(x))->prev))
#define DEmpty(x)  ((x)->count == 0)

#endif
