/************************************************************
               TEXT MODULE HEADER   -   Text.h
*************************************************************

--- Consecutive, efficient storage of strings, AS INTEGERS.

--- The internal representation of the string is the row
    number.

--- Built "on top of" the Table module, using hash-coded
    techniques.

--- Arbitrary number of strings, of arbitrary length.

--- A segment of the table can be "reserved".

         +----------------------------
      1  + <identifier>               
         +----------------------------
      2  + <string>                  
         +----------------------------
      3  + <integer>                         
         +----------------------------
      4  + begin                      
         +----------------------------
      5  + end                        
         +----------------------------
      6  +  . . .                     
         +----------------------------
************************************************************/

#define UndefinedString 0

typedef int String;

extern int LowerBoundary, UpperBoundary;

extern InitializeTextModule();
extern int TextSize();
extern ResetBufferInTextTable();
extern AdvanceOnCharacter();
extern String ConvertStringInBuffer();
extern FreezeLowerBound();
extern FreezeUpperBound();
extern char Character();
extern int StringLength();
extern Write_String();
extern WriteString();
extern int IsStringReserved();
extern PrintAllStrings();
