/***************************************************************************
           Copyright (C) 1986 by Manuel E. Bermudez
           Translated to C - 1991
****************************************************************************/

/***************************************************************************
              CODE MODULE HEADER   -   Code.h
****************************************************************************/
/* This module builds the _CODE file. 
  Variables -
      FrameSize = size of current frame
      CurrentProcLevel = current procedure or function level
      LabelCount = current number of labels
      TraceFile = file containing code generation trace
      TraceFileName = name of TraceFile
      TraceSpecified = flag to indicate trace request
      Frames = data structure that stores frame sizes
      LabelStack, OpStack, Op1Stack, Op2Stack = data structures
          that store code

  Procedures
    InitializeCode() 
       - initializes structures that store code
    CodeGen0 (S,L) String S; Clabel L;
       - stores instruction S with label L and no operands
    CodeGen1 (S1,S2,L) String S1, S2; Clabel L;
       - stores instruction S1 with label L and operand S2
    CodeGen2 (S1,S2,S3,L) String S1, S2, S3; Clabel L;
       - stores instruction S1 with label L and operands S2 and S3
    IncrementFrameSize()
       - increments size of current frame
    DecrementFrameSize()
       - decrements size of current frame
    OpenFrame()
       - opens a new frame
    CloseFrame()
       - closes the current frame
    DumpCode(OutFile) FILE *OutFIle;
       - dumps code to file _CODE

  Functions
    int MakeAddress()
       - creates a new address, from current frame size. The address is 
         an overlaid pair (ProcLevel, FrameDisplacement)
    int FrameDisplacement (Addr) int Addr;
       - returns frame displacement portion of Addr
    int ProcLevel (Addr) int Addr;
       - returns procedure level portion of Addr                     
***************************************************************************/

#define true 1
#define false 0
#define NoLabel 0
#define UndefinedString 0
typedef int boolean;
typedef int Clabel;

int FrameSize, CurrentProcLevel, LabelCount;
FILE *TraceFile;
char *TraceFileName;
boolean TraceSpecified;
Stack Frames, LabelStack, OpStack, Op1Stack, Op2Stack;

extern InitializeCode();
extern String MakeLabel();
extern CodeGen0();
extern CodeGen1();
extern CodeGen2();
extern IncrementFrameSize();
extern DecrementFrameSize();
extern OpenFrame();
extern CloseFrame();
extern int MakeAddress();
extern int FrameDisplacement();
extern int ProcLevel();
extern DumpCode();

