// shaped-pointset.h
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//
// Define some commonly useful point set shapes.

#ifndef IA_shaped_pointset_h_
#define IA_shaped_pointset_h_

#include "IntPointSet.h"


////////////////////////////////////////////////////////////////////////
// Here we define some functions to create various sizes of shaped
//      pointsets.
// While it would be possible to define a class IA_ShapedPS, derived
//      from IA_Set, it is not clear what benefit that might have for
//      now, so we will just defined functions that will return the
//      correct IA_Set<P>


// A point set centered at start_point, with North-South & East-West
//   arms of equal length
//
// cross_hair( apoint, 0 ) returns a point set that only contains apoint.
IA_Set<IA_Point<int> >
cross_hair( const IA_Point<int> & start_point,
	    unsigned int radius );


// Return an extensive pointset of the appropriate diameter, centered
//   at center.  The pointset contains all points that are of distance
//   less than or equal (<=) to center.
//
IA_Set<IA_Point<int> >
digital_disc( const IA_Point<int> & center, double radius );

#endif
