// otsu-image.h         Section: 3.7
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Threshold Selection by Maximizing Between Class Variance
// This example utilizes the alternate formulation by defining
//      an image whose domain represents all possible partitions
//      of the input image, and whose value represents the
//      objective function to be maximized.
// This definition is not utilized directly by the user of the Otsu
//      function, but is utilized internally.

#ifndef otsu_image_h_
#define otsu_image_h_


#include "FloatDI.h"
#include "ClosureI.h"


////////////////////////////////////////////////////////////////////////
// class OtsuImage
//   This class represents an image with the following properties:
//   1) It data is derived from some original image: a
//   2) Its domain is a function of  a.range() and the number of
//      partitions the histogram(a) is to be broken into.
//   3) Its range values are determined by the objective function
//      described in the IAH for the Otsu algorithm.
//
class  OtsuImage: public IA_ClosureI<IA_Point<int>,float> {

private:
    unsigned int d;                // Number of Tau points == our dimension
    double       total_mu_squared; // Square of total mean value of nh
    IA_Image<IA_Point<int>,float>
        nh,      // normalized histogram of a
	cnh,     // cumulative normalized histogram of a
	mu_cnh;  // cumultaive normalized area histogram of a
    IA_Point<int> minNHpt, maxNHpt;
public:
    OtsuImage(unsigned int tauCount,
		 IA_Image<IA_Point<int>,float> normalizedHistogram );

    float operator() (const IA_Point<int> &loop_ip) const;

    IA_ClosureI<IA_Point<int>,float> * clone_self() const;

    ostream & print_this(ostream & os) const;
};

#endif
