// hueckel.h            Section: 6.15
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Hueckel Edge Operator
// Note: Two versions are provided.  One which returns the edge image
//      before it thresholding is applied, and a second version,
//      based on the first, that applies the thresholding factor.
//

#ifndef _hueckel_h_
#define _hueckel_h_

#include "UcharDI.h"
#include "FloatDI.h"


// This version does not apply thresholding.
//
IA_Image<IA_Point<int>,float>
hueckel2D( const IA_Image<IA_Point<int>,float> a,
	   double radius,
	   double theta[],        // Array of angles, in radians
	   unsigned theta_m );    // count of number of angles


// This version applies the thresholding for the user.
//
IA_Image<IA_Point<int>,u_char>
hueckel2D( const IA_Image<IA_Point<int>,float> a,
	   double radius,
	   double theta[],        // Array of angles, in radians
	   unsigned theta_m,      // count of number of angles
	   float threshold );     // 0.0 <= threshold <= 1.0

#endif
