/*  $RCS$
    $Log: generic-tests.c,v $
 * Revision 1.4  1992/12/14  16:40:21  jm
 *  Renamed class ValueSet to IA_ValueSet
 *
 * Revision 1.3  92/09/29  15:32:53  jm
 * *** empty log message ***
 * 
 * Revision 1.2  92/09/16  17:03:36  jm
 * *** empty log message ***
 * 
*/

#include "ValueSet.h"
#include "generic-tests.h"

template <class ValueType>
void test_union(IA_ValueSet<ValueType> a, IA_ValueSet<ValueType> b, 
		IA_ValueSet<ValueType> ab) {
    ValueType	p;
    
    IA_ValueSetIter<ValueType>	iter = a;
    
    while (iter(p)) {
	if (!ab.contains(p)) {
	    cout << p;
	    cout << "##missing##\n";
	}
    }
    
    iter = b;
    
    while (iter(p)) {
	if (!ab.contains(p)) {
	    cout << p;
	    cout << "##missing##\n";
	}
    }
    
    iter = ab;
    
    while (iter(p)) {
	if (! (a.contains(p) || b.contains(p))) {
	    cout << p;
	    cout << "##extra##\n";
	}
    }

    if (a>ab)
	cout << "## a > a|b ##\n";
    if (b>ab)
	cout << "## b > a|b ##\n";

    cout << "union test complete\n";
}

template <class ValueType>
void test_inter(IA_ValueSet<ValueType> a, IA_ValueSet<ValueType> b, 
		IA_ValueSet<ValueType> ab) {

    ValueType	p;
    
    IA_ValueSetIter<ValueType>	iter = a;
    
    while (iter(p)) {
	if (b.contains(p) != ab.contains(p)) {
	    cout << p << ":" << b.contains(p) << "->";
	    cout << p << ":" << ab.contains(p) << "->";
	    cout << "##a error##\n";
	}
    }
    
    iter = b;
    
    while (iter(p)) {
	if (a.contains(p) != ab.contains(p)) {
	    cout << p << ":" << a.contains(p) << "->";
	    cout << p << ":" << ab.contains(p) << "->";
	    cout << "##b error##\n";
	}
    }
    
    iter = ab;
    
    while (iter(p)) {
	if (! (a.contains(p) && b.contains(p))) {
	    cout << p;
	    cout << "##ab extra##\n";
	}
    }

    if (a<ab)
	cout << "## a < a&b ##\n";
    if (b<ab)
	cout << "## b < a&b ##\n";
    cout << "intersection test complete\n";
}

template <class ValueType>
void test_sdiff(IA_ValueSet<ValueType> a, IA_ValueSet<ValueType> b, 
		IA_ValueSet<ValueType> ab) {
    ValueType	p;
    
    IA_ValueSetIter<ValueType>	iter = a;
    
    while (iter(p)) {
	if (b.contains(p) && ab.contains(p)) {
	    cout << p;
	    cout << "##a extra error##\n";
	} else if (!b.contains(p) && !ab.contains(p)) {
	    cout << p;
	    cout << "##a missing error##\n";
	}
    }
    
    iter = b;
    
    while (iter(p)) {
	if (a.contains(p) && ab.contains(p)) {
	    cout << p;
	    cout << "##b extra error##\n";
	} else if (!a.contains(p) && !ab.contains(p)) {
	    cout << p;
	    cout << "##b missing error##\n";
	}
    }
    
    iter = ab;
    
    while (iter(p)) {
	if (a.contains(p) == b.contains(p)) {
	    cout << p;
	    cout << "##ab extra##\n";
	}
    }
    
    if ( ((a/b) | (b/a)) != ab ) {
	cout << "(a/b) | (b/a) != a^b\n";
    }
    
    cout << "symmetric difference test complete\n";
}

template <class ValueType>
void test_minus(IA_ValueSet<ValueType> a, IA_ValueSet<ValueType> b, 
		IA_ValueSet<ValueType> ab) {
    ValueType	p;
    
    IA_ValueSetIter<ValueType>	iter = a;
    
    while (iter(p)) {
	if (b.contains(p) && ab.contains(p)) {
	    cout << p << "##extra [a] error##\n";
	} else if ( ! b.contains(p) && ! ab.contains(p) ) {
	    cout << p << "##missing [a] error##\n";
	}
    }
    
    iter = b;
    
    while (iter(p)) {
	if (ab.contains(p)) {
	    cout << p;
	    cout << "##b error##\n";
	}
    }
    
    iter = ab;
    
    while (iter(p)) {
	if (!a.contains(p) || b.contains(p)) {
	    cout << p;
	    cout << "##ab extra##\n";
	}
    }

    if (a<ab)
	cout << "## a < a/b ##\n";

    cout << "difference test complete\n";
}

template <class ValueType>
void list_value_set(ostream &o, IA_ValueSet<ValueType> vs) {
    IA_ValueSetIter<ValueType>	iter(vs);
    ValueType	ip;
    while (iter(ip)) {
	o << ip << ' ';
    }
    o << "\n";
}
