// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char rcsid[] = "$Id: VS_Specials.c,v 1.3 1993/11/17 17:55:48 thoth Exp $";

//
// $Log: VS_Specials.c,v $
// Revision 1.3  1993/11/17  17:55:48  thoth
// Pointcmp is now pointcmp.
// Added value comparator for ValueSet<complex>
//
// Revision 1.2  1993/05/26  16:31:58  thoth
// Copyright Notices
//
// Revision 1.1  93/05/26  13:49:40  thoth
// Initial revision
// 

#include <complex.h>
#include "ValueSet.h"
#include "FloatPoint.h"

IA_ValueSet<int> value_range(int v0, int v1) {
    IA_ValueSet<int> vs;
    int sz = v1 - v0;
    
    if (sz < 0)
	return IA_ValueSet<int>();
    if (sz == 0)
	return IA_ValueSet<int>(v0);
    int *ret_array = new int[++sz];
    for (int i = 0; i < sz; i++)
	ret_array[i] = v0+i;
    return IA_ValueSet<int>(ret_array, sz);
}

int IA_ValueSetComparator<IA_FloatPoint>::value_type_compare(
    const void *t1, const void *t2) {

  return pointcmp(*(IA_FloatPoint *)t1, *(IA_FloatPoint *)t2);
}

int IA_ValueSetComparator<complex>::value_type_compare(
    const void *t1, const void *t2) {
    complex	*a = (complex*)t1;
    complex	*b = (complex*)t2;

    float	ap = real(*a);
    float	bp = real(*b);

    if (ap>bp)
	return 1;
    else if (ap<bp)
	return -1;

    ap = imag(*a);
    bp = imag(*b);

    if (ap>bp)
	return 1;
    else if (ap<bp)
	return -1;
    else
	return 0;
}
