// Emacs: -*- C++ -*-

#include "FloatPoint.h"
#include <ACG.h>

#define TBL_SIZE 40

int main(int argc, char**argv)
{
    void	print_rounding_table(FloatPoint[], int);
    FloatPoint	make_random_point(int, int, int, ACG&); 
    ACG		generator(69, 96);
    FloatPoint  points[TBL_SIZE];
    
    for (int i = 0; i < TBL_SIZE; i++) 
	points[i] = make_random_point(1, -2, +2, generator);

    
    print_rounding_table(points, TBL_SIZE);
}


void
print_rounding_table(FloatPoint point_array[], int number_points)
{
//  Run all rounding ops on an array of points, printing a table
    
    cout << "aint()\t"
	 << "anint()\t"
	 << "ceil()\t"
	 << "floor()\t"
	 << "rint()\t"
	 << "irint()\t"
	 << "nint()\t"
	 << "trunc()\t"
	 << "for Point\n";
    
    for (int i = 0; i < number_points; i++ ) {

	cout << aint(point_array[i]); 	cout << "\t";
	cout << anint(point_array[i]); 	cout << "\t";
	cout << ceil(point_array[i]); 	cout << "\t";
	cout << floor(point_array[i]); 	cout << "\t";
	cout << rint(point_array[i]); 	cout << "\t";
	cout << irint(point_array[i]); 	cout << "\t";
	cout << nint(point_array[i]); 	cout << "\t";
	cout << trunc(point_array[i]); 	cout << "\t";
	cout << point_array[i] << "\n";


    }
}


FloatPoint
make_random_point(int dimensions, int bottom, int top, ACG& gen)
{
    int   range;

    if (top < bottom) {
	int temp = top;
	top = bottom;
	bottom = temp;
    }
    range = top - bottom + 1;    

    switch (dimensions) {
    case 0:
	return FloatPoint();
    case 1:
	return FloatPoint(bottom +  gen.asFloat() * range);
    case 2:
	return FloatPoint(bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range);
    case 3:
	return FloatPoint(bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range);
    case 4:
	return FloatPoint(bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range);
    case 5:
	return FloatPoint(bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range,
			  bottom +  gen.asFloat() * range);
    default:
	return FloatPoint(0.0, 0.0, 0.0, 0.0, 0.0);    
    }
}

