// test-point.c

// $Log: test-point.c,v $
// Revision 1.1  1992/10/06  20:33:18  rjj
// Initial revision
//

#include <iostream.h>
#include "Point.h"

#include "test-pts.externs"
#include "test-pts.macros"

main() {

create_int_vars(Point,<int>);
//create_double_vars(Point,<double>);

const int ten = 10;
const unsigned eight = 8;


// Initialization
IA::exit_on_throw = 0;

for (int i=0; i<7; i++) {
    intVec[i] = 6+i;
    doubleVec[i] = i + .6;
    };

pi6 = Point<int>(intVec, 7);
//pd6 = Point<double>(doubleVec, 7);
//pi6 = Point<int>(intVec, 7, 0);
//pd6 = Point<double>(doubleVec, 7, 0);


cout << "\n***************** Integer Point Tests **************\n";
#define INFO_I
#ifdef INFO_I
cout << "\n\nPoint<int> variable info dump\n";

info("pi",pi); info("pi0",pi0); info("pi1",pi1); info("pi2",pi2);
info("pi3",pi3); info("pi4",pi4); info("pi5",pi5); info("pi6",pi6);
#endif

#define CONSTRUCTOR_I
#ifdef CONSTRUCTOR_I
cout << "\n\nConstructor Tests\n";

info("pi()",Point<int>());
info("pi(1)", Point<int>(1));
info("pi(1,2)",Point<int>(1,2));
info("pi(1,2,3)",Point<int>(1,2,3));
info("pi(1,2,3,4)",Point<int>(1,2,3,4));
info("pi(1,2,3,4,5)",Point<int>(1,2,3,4,5));

const Point<int> cpi(-2,14,27,18,3);
info("cpi",cpi);
info("p(cpi)",Point<int>(cpi));

// use intVec defined already
cout << "\n\nVector Constructor tests\n\n";
coutVec(intVec,7);
cout << "\n";
Point<int> pv_7_0(intVec, 7, 0);
Point<int> pv_6(intVec,6);
Point<int> pv_5_1(intVec, 5, 1);

info("Dcl  pv_7_0", pv_7_0);
info("Dcl  pv_5_1", pv_5_1);  // Should share intVec
info("Dcl  pv_6",   pv_6  );

cout << "\nModify intVec[0..4] = old value squared\n";
for (i=0; i<5; i++) {
    intVec[i] = (intVec[i] * intVec[i] );
}
coutVec(intVec,7);
info("Dsp  pv_7_0", pv_7_0);
info("Dsp  pv_5_1", pv_5_1);  // Should have changed value
info("Dsp  pv_6",   pv_6  );

	       
Point<int> pcopy = cpi;
info("p = cpi", pcopy);
#endif


#define INDEX_REF_I
#ifdef INDEX_REF_I
cout << "\n\nIndex Reference test\n";

Point<int> pref(intVec,7,0);
info("pref",pref);
int &pri = pref[2];
pri = -4311;
info("pref[2]=-4311",pref);
#endif


#define EXTEND_I
#ifdef EXTEND_I
cout << "\n\nExtend to point tests\n";

pi = extend_to_point(ten, eight);
info("pi=e_to_p(10,8)",pi);
#endif

#define CAT_I
#ifdef CAT_I
cout << "\n\nConcatenation tests\n";

cat_f(pi1,pi1);
cat_f(pi2,pi2);
cat_f(pi3,pi3);
cat_f(pi4,pi4);
cat_f(pi5,pi5);
cat_f(pi6,pi6);

cat_f(pi0,pi1);
cat_f(pi1,pi2);
cat_f(pi2,pi3);
cat_f(pi3,pi4);
cat_f(pi4,pi5);
cat_f(pi5,pi6);

cat_f(pi0,ten);
cat_f(pi1,ten);
cat_f(pi2,ten);

cat_f(ten,pi0);
cat_f(ten,pi1);
cat_f(ten,pi2);
#endif


#define CDR_I
#ifdef CDR_I
cout << "\n\nCDR tests\n";

cdr1(pi0);
cdr1(pi1);
cdr1(pi2);
cdr1(pi3);
cdr1(pi4);
cdr1(pi5);
cdr1(pi6);

cdr2(pi0);
cdr2(pi1);
cdr2(pi2);
cdr2(pi3);
cdr2(pi4);
cdr2(pi5);
cdr2(pi6);
#endif


#define INDEX_I
#ifdef INDEX_I
cout << "\n\nIndex Derangement tests\n";

idr1(pi6,0);
idr1(pi6,1);
idr1(pi6,2);

idr2(pi6,1,2);
idr2(pi6,3,4);
idr2(pi6,2,5);

unsigned idrVec[20];
idrVec[0] = 3; idrVec[1] = 5; idrVec[2] = 1;
idrVec[3] = 0; idrVec[4] = 2; idrVec[5] = 4;
idrVec[6] = 3; idrVec[7] = 5; idrVec[8] = 1;
idrVec[9] = 0; idrVec[10] = 2; idrVec[11] = 4;
idrVec[12] = 3; idrVec[13] = 5; idrVec[14] = 1;
idrVec[15] = 0; idrVec[16] = 2; idrVec[17] = 4;
idrVec[18] = 3; idrVec[19] = 5;

idrv(pi6,idrVec,1);
idrv(pi6,idrVec,2);
idrv(pi6,idrVec,3);
idrv(pi6,idrVec,4);
idrv(pi6,idrVec,5);
idrv(pi6,idrVec,6);
idrv(pi6,idrVec,10);
idrv(pi6,idrVec,16);
idrv(pi6,idrVec,19);
#endif


cout << "\n***************** Float Point Tests **************\n";

// Float tests
const float twenty= 20.0;

//#define EXTEND_D
#ifdef EXTEND_D
extend(twenty,3);
#endif

//#define CDR_D
#ifdef CDR_D
cdr1(pd1);
cdr1(pd2);
cdr1(pd3);

cdr2(pd1);
cdr2(pd2);
cdr2(pd3);
#endif

//#define CAT_D 
#ifdef CAT_D
cat(pd1,pd2);
cat(pd2,pd3);
cat(pd3,pd4);
cat(pd4,pd5);
cat(pd5,pd6);
#endif

//#define INDEX_D
#ifdef INDEX_D
#endif

cout << "\n";
}
