// Emacs: -*- C++ -*-
// test-lattice.c

#include <iostream.h>
#include "LatticePoint.h"

#include "test-pts.externs"
#include "test-pts.macros"

main() {

create_int_vars(LatticePoint,<int>);
create_double_vars(LatticePoint,<double>);


// Initialization
IA::exit_on_throw = 0;

for (int i=0; i<10; i++) {
    intVec[i] = i;
    doubleVec[i] = sqrt(i);
};


pi6 = LatticePoint<int>(intVec, 10, 0);
pd6 = LatticePoint<double>(doubleVec,10,0);

//
// Output checks
//
//#define OUT_I
#ifdef OUT_I
cout << "\n\nLatticePoint<int> print test\n";

out(pi); out(pi0);out(pi1); out(pi2);
out(pi3); out(pi4); out(pi5); out(pi6);
#endif


//#define OUT_D
#ifdef OUT_D
cout << "\n\nLatticePoint<double> print test\n";

out(pd); out(pd0); out(pd1); out(pd2);
out(pd3); out(pd4); out(pd5); out(pd6);
#endif


//#define INFO_I
#ifdef INFO_I
cout << "\n\nLatticePoint<int> print test\n";

info("pi",pi); info("pi0",pi0); info("pi1",pi1); info("pi2",pi2);
info("pi3",pi3); info("pi4",pi4); info("pi5",pi5); info("pi6",pi6);
#endif


//#define INFO_D
#ifdef INFO_D
cout << "\n\nLatticePoint<double> print test\n";

info("pd",pd); info("pd0",pd0); info("pd1",pd1); info("pd2",pd2);
info("pd3",pd3); info("pd4",pd4); info("pd5",pd5); info("pd6",pd6);
#endif


// Integer tests
const ten = 10;

//#define DEBUG
#ifdef  DEBUG
cout << "\n\nLatticePoint debugging\n";

cout << "\nLatticePoint tests, expected results: 1 1 0 0 0 1\n";
lat_result( (LatticePoint<int>(1) <  LatticePoint<int>(2)) );
lat_result( (LatticePoint<int>(1) <= LatticePoint<int>(2)) );
lat_result( (LatticePoint<int>(1) >  LatticePoint<int>(2)) );
lat_result( (LatticePoint<int>(1) >= LatticePoint<int>(2)) );
lat_result( (LatticePoint<int>(1) == LatticePoint<int>(2)) );
lat_result( (LatticePoint<int>(1) != LatticePoint<int>(2)) );
#endif


#define P_OP_Q_I
#ifdef P_OP_Q_I
cout << "\n\nLatticePoint<int> op LatticePoint<int> tests\n";

lat_test_pq_i(1);
lat_test_pq_i(2);
#endif

#define MEMBER_OP_CONST_I
#ifdef MEMBER_OP_CONST_I
cout << "\n\nLatticePoint<int> op const tests\n";

const one =1;

lat_test_mc(pi1,one);
lat_test_mc(pi2,one);
#endif

#define CONST_OP_MEMBER_I
#ifdef  CONST_OP_MEMBER_I
cout << "\n\nLatticePoint<int> op const tests\n";

lat_test_cm(ten,pi1);
lat_test_cm(ten,pi2);
#endif

#define POINTCMP_I
#ifdef POINTCMP_I
cout << "\n\nLatticePoint  Pointcmp tests\n";

ptcmp(pi1,pi2);
ptcmp(pi1,pi1);
ptcmp(pi2,pi2);
ptcmp(pi2,pi1);
#endif

#define MINMAX_I
#ifdef  MINMAX_I
cout << "\n\nLatticePoint  Min & Max tests\n";

ptmin(pi3);
ptmax(pi3);
#endif

#define INFSUP_I
#ifdef  INFSUP_I
cout << "\n\nLatticePoint  Inf & Sup tests\n";

ptinf(pi3,qi3);
ptsup(pi3,qi3);
ptinf(LatticePoint<int>(1,-2,3,-4,5),LatticePoint<int>(-1,2,-3,4,-5));
ptsup(LatticePoint<int>(1,-2,3,-4,5),LatticePoint<int>(-1,2,-3,4,-5));
#endif

cout << "\n\n";
}
