// Emacs: -*- C++ -*-
// test-bitwise.c

// $Log: test-bitwise.c,v $
// Revision 1.1  1992/10/06  20:58:46  rjj
// Initial revision
//

#include <iostream.h>
#include "BitwisePoint.h"

#include "test-pts.externs"
#include "test-pts.macros"


main() {

create_int_vars(BitwisePoint,<int>);
create_double_vars(BitwisePoint,<double>);


// Initialization
IA::exit_on_throw = 0;

for (int i=0; i<10; i++) {
    intVec[i] = i;
    doubleVec[i] = sqrt(i);
};


pi6 = BitwisePoint<int>(intVec, 10, 0);
pd6 = BitwisePoint<double>(doubleVec,10,0);

//
// Output checks
//
//#define OUT_I
#ifdef OUT_I
cout << "\n\nBitwisePoint<int> print test\n";

out(pi); out(pi0);out(pi1); out(pi2);
out(pi3); out(pi4); out(pi5); out(pi6);
#endif


//#define OUT_D
#ifdef OUT_D
cout << "\n\nBitwisePoint<double> print test\n";

out(pd); out(pd0); out(pd1); out(pd2);
out(pd3); out(pd4); out(pd5); out(pd6);
#endif


//#define INFO_I
#ifdef INFO_I
cout << "\n\nBitwisePoint<int> print test\n";

info("pi",pi); info("pi0",pi0); info("pi1",pi1); info("pi2",pi2);
info("pi3",pi3); info("pi4",pi4); info("pi5",pi5); info("pi6",pi6);
#endif


//#define INFO_D
#ifdef INFO_D
cout << "\n\nBitwisePoint<double> print test\n";

info("pd",pd); info("pd0",pd0); info("pd1",pd1); info("pd2",pd2);
info("pd3",pd3); info("pd4",pd4); info("pd5",pd5); info("pd6",pd6);
#endif


// Integer tests
const ten = 10;

#define MEMBER_OP_MEMBER_I
#ifdef  MEMBER_OP_MEMBER_I
cout << "\n\nBitwisePoint<int> op BitwisePoint<int> tests\n";

p_op_q(mod,i);
p_op_q(bleft,i);
p_op_q(bright,i);
p_op_q(band,i);
p_op_q(bxor,i);
p_op_q(bor,i);
#endif


#define P_OP_CONST_I
#ifdef    P_OP_CONST_I
cout << "\n\nBitwisePoint<int> op const tests\n";

p_op_c(mod,i,ten);
p_op_c(bleft,i,ten);
p_op_c(bright,i,ten);
p_op_c(band,i,ten);
p_op_c(bxor,i,ten);
p_op_c(bor,i,ten);
#endif

#define PREFIX_I
#ifdef PREFIX_I
cout << "\n\nBitwisePoint<int> prefix tests\n";

ones_complement(pi1);
ones_complement(pi2);
ones_complement(pi3);
ones_complement(pi4);
ones_complement(pi5);
ones_complement(pi6);
#endif

//#define MEMBER_OPASSIGN_MEMBER_I
#ifdef  MEMBER_OPASSIGN_MEMBER_I
cout << "\n\nBitwisePoint<int> op BitwisePoint<int> tests\n";

p_op_q(modassign,i);
p_op_q(bleftassign,i);
p_op_q(brightassign,i);
p_op_q(bandassign,i);
p_op_q(bxorassign,i);
p_op_q(borassign,i);
#endif

cout << "\n";
}
