// Emacs: -*- C++ -*-
// test-arith.c

// $Log: test-arith.c,v $
// Revision 1.1  1992/10/06  20:40:08  rjj
// Initial revision
//

#include <iostream.h>
#include "ArithPoint.h"



#include "test-pts.macros"
#include "test-pts.externs"


main() {

create_int_vars(ArithPoint,<int>);
create_double_vars(ArithPoint,<double>);


// Initialization
IA::exit_on_throw = 0;

for (int i=0; i<10; i++) {
    intVec[i] = i;
    doubleVec[i] = sqrt(i);
};


pi6 = ArithPoint<int>(intVec, 10, 0);
pd6 = ArithPoint<double>(doubleVec,10,0);

//
// Output checks
//
#define OUT_I
#ifdef OUT_I
cout << "\n\nArithPoint<int> print test\n";

out(pi); out(pi0);out(pi1); out(pi2);
out(pi3); out(pi4); out(pi5); out(pi6);
#endif


//#define OUT_D
#ifdef OUT_D
cout << "\n\nArithPoint<double> print test\n";

out(pd); out(pd0); out(pd1); out(pd2);
out(pd3); out(pd4); out(pd5); out(pd6);
#endif

//#define INFO_I
#ifdef INFO_I
cout << "\n\nArithPoint<int> print test\n";

info("pi",pi); info("pi0",pi0); info("pi1",pi1); info("pi2",pi2);
info("pi3",pi3); info("pi4",pi4); info("pi5",pi5); info("pi6",pi6);
#endif


//#define INFO_D
#ifdef INFO_D
cout << "\n\nArithPoint<double> print test\n";

info("pd",pd); info("pd0",pd0); info("pd1",pd1); info("pd2",pd2);
info("pd3",pd3); info("pd4",pd4); info("pd5",pd5); info("pd6",pd6);
#endif


// Integer tests
const ten = 10;

#define OP_CONST_I
#ifdef OP_CONST_I
cout << "\n\nArithPoint<int> op const tests\n";

add(pi,ten);
add(pi0,ten);
add(pi1,ten);
add(pi2,ten);
add(pi3,ten);
add(pi4,ten);
add(pi5,ten);
#endif


#define ASSIGN_I
#ifdef ASSIGN_I
cout << "\n\nArithPoint<> op= arg tests\n";

addassign_i(1);
addassign_i(2);
addassign_i(3);
addassign_i(4);
addassign_i(5);

subassign_i(1);
subassign_i(2);
subassign_i(3);
subassign_i(4);
subassign_i(5);

mulassign_i(1);
mulassign_i(2);
mulassign_i(3);
mulassign_i(4);
mulassign_i(5);

divassign_i(1);
divassign_i(2);
divassign_i(3);
divassign_i(4);
divassign_i(5);
#endif

#define P_OP_Q_I
#ifdef P_OP_Q_I
cout << "\n\nArithPoint<int> op ArithPoint<int> tests\n";

p_op_q(add,i);
p_op_q(sub,i);
p_op_q(mul,i);
p_op_q(div,i);
#endif

#define P_OP_C_I
#ifdef P_OP_C_I
cout << "\n\nArithPoint<int> op const tests\n";

p_op_c(add,i,ten);
p_op_c(sub,i,ten);
p_op_c(mul,i,ten);
p_op_c(div,i,ten);

addconst_i(ten);
subconst_i(ten);
mulconst_i(ten);
divconst_i(ten);
#endif

#define PREFIX_I
#ifdef PREFIX_I
cout << "\n\nArithPoint<int> prefix tests\n";

pre_pp(i);
pre_mm(i);
pre_um(i);
#endif


#define POSTFIX_I
#ifdef POSTFIX_I
cout << "\n\n ArithPoint<int> postfix tests\n";

post_mm(i);
post_pp(i);
#endif


#define ENORM_I
#ifdef ENORM_I
cout << "\n\nArithPoint<int> enorm tests\n";

enorm(p,i);
enorm(q,i);
#endif



// Float tests
cout << "\n\nArithPoint<double> tests\n";

const float twenty= 20.0;

add(pd,twenty);
add(pd0, twenty);
add(pd1, twenty);
add(pd2, twenty);
add(pd3, twenty);
add(pd4, twenty);
add(pd5, twenty);

sub(pd1, twenty);
mul(pd1, twenty);
div(pd1, twenty);

/*
cout << "\n\n";
addassign(pd1, qd1);
subassign(pd1, qd1);
mulassign(pd1, qd1);
divassign(pd1, qd1);

addassign_d(1);
addassign_d(2);
addassign_d(3);
addassign_d(4);
addassign_d(5);

subassign_d(1);
subassign_d(2);
subassign_d(3);
subassign_d(4);
subassign_d(5);

mulassign_d(1);
mulassign_d(2);
mulassign_d(3);
mulassign_d(4);
mulassign_d(5);

divassign_d(1);
divassign_d(2);
divassign_d(3);
divassign_d(4);
divassign_d(5);

addconst_d(twenty);
subconst_d(twenty);
mulconst_d(twenty);
divconst_d(twenty);
*/

cout << "\n";
}
