// Emacs: -*- C++ -*-
static char rcsid[] = "$Id: pointset-utils.c,v 1.2 93/01/20 11:39:33 thoth Exp $";

//
// $Log:	pointset-utils.c,v $
// Revision 1.2  93/01/20  11:39:33  thoth
// Random pointset is a test of the IA_PSPred template.
// 
// Revision 1.1  92/09/30  10:53:03  thoth
// Initial revision
// 
//

#include "pointset-utils.h"
#include "point-utils.h"
#include <rand48.h>

IntPointSet
make_random_pointset(unsigned dimen, unsigned card, int bottom, int top)
{
    IntPoint	*arr=new IntPoint[card];

    for (unsigned i=0; i<card; i++)
	arr[i] = make_random_point(dimen, bottom, top);
    return IntPointSet(dimen, arr,card);
}

IA_PSPred<IntPoint> *Random_PS::clone_self() const
{
    return new Random_PS(dimen,density);
}

int Random_PS::contains(const IntPoint &) const
{
    return drand48()<density;
}
