// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: YoderIPSIter.h,v $
// Revision 1.7  1993/11/17  18:07:29  thoth
// IPSIter is now PSIter<IntPoint>
//
// Revision 1.6  1993/07/15  11:40:23  thoth
// new BasePSIter implementation.
//
// Revision 1.5  93/05/26  16:51:49  thoth
// Copyright Notices
// 
// Revision 1.4  92/12/16  14:48:30  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.3  92/08/23  13:30:23  thoth
// CFrontified version
// 
// 

#ifndef YoderIPSIter_h_
#define YoderIPSIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseIPSIter.h"
#include "PSIter.h"
#include "YoderIPS.h"

class IA_YoderIPSIter: public IA_BaseIPSIter {
protected:
    IA_YoderIPS* yoder() const {
	return (IA_YoderIPS*) domain;
    }

    // the first coordinate of the point we are currently on
    int		curr;
    // the index of the shadow cylinder that curr is from
    unsigned	sliceidx;
    // the iterator over the current shadow
    IA_PSIter<IA_IntPoint>	*subiter;
public:
    IA_YoderIPSIter(IA_YoderIPS *);
    IA_YoderIPSIter(const IA_YoderIPSIter &);
    ~IA_YoderIPSIter() { if (this->subiter) delete this->subiter; }

    IA_BaseIPSIter *clone_self() { return new IA_YoderIPSIter(*this); }
    int next(IA_IntPoint&);
    void reset() {
	this->curr = yoder()->lastbefore+1;
	this->sliceidx = 0;
	if (this->subiter) {
	    delete this->subiter;
	    this->subiter=0;
	}
    }
};

#endif
