// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: PSIter.h,v $
// Revision 1.11  1993/11/17  18:06:44  thoth
// make_iter is inline due to cfront bug.
//
// Revision 1.10  1993/08/08  13:17:18  thoth
// Parametrization of the iterator class.
//
// Revision 1.9  93/05/26  16:51:28  thoth
// Copyright Notices
// 
// Revision 1.8  93/04/17  14:52:56  thoth
// Use IA_IntPoint instead of IntPoint
// 
// Revision 1.7  93/02/12  16:25:23  thoth
// more IA_ prefixes.
// more comments.
// 
// Revision 1.6  92/12/16  14:48:07  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.5  92/12/07  12:07:56  thoth
// the domain method is now const (like it should be)
// 
// Revision 1.4  92/08/23  13:30:11  thoth
// CFrontified version
// 
// 

#ifndef IPSIter_h_
#define IPSIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseIPSIter.h"

#include "IntPointSet.h"
#include "FloatPointSet.h"

template <class P>
class IA_PSIter {
  protected:
    IA_BasePSIter<P>	*iter;
    
    static IA_BasePSIter<P> * make_iter(const IA_Set<P>&ps) {
	return ps.ps->iterator();
    }
  public:
    IA_PSIter();
    IA_PSIter(const IA_Set<P> &ips) { this->iter = make_iter(ips); }
    IA_PSIter(const IA_PSIter<P> &x) { this->iter = x.iter->clone_self(); }
    ~IA_PSIter() { delete iter; }
    
    IA_PSIter<P>& operator=(const IA_Set<P> &);
    IA_PSIter<P>& operator=(const IA_PSIter<P> &);
    
    IA_Set<P> domain() const;
    
    int operator() (P& ip) { return iter->next(ip); }
    void reset() { iter->reset(); }
};

/* sample usage:

   PointSet	blah;

   ...

   IA_PSIter<P>	scan(blah);
   IA_IntPoint	i;

   while (scan(i)) {
     frob(i);
   }

 */

#endif
