// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char rcsid[] = "$Id: MondoPS.c,v 1.8 1993/09/15 12:34:02 thoth Exp $";

// 
// $Log: MondoPS.c,v $
// Revision 1.8  1993/09/15  12:34:02  thoth
// Pointset behavior controls have moved to IA::
//
// Revision 1.7  93/08/08  13:21:18  thoth
// deInlining of a few methods.
// 
// Revision 1.6  93/07/15  11:46:00  thoth
// Iterators for Mondo PSs are now hidden inside the Mondo Module.
// 
// Revision 1.5  93/05/26  16:51:35  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  12:52:52  thoth
// Mondo PointSets are now templatized.
// 
// Revision 1.3  93/02/12  16:27:49  thoth
// more IA_ prefixes.
// 
// Revision 1.2  92/12/16  14:49:59  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.1  92/09/30  10:52:18  thoth
// Initial revision
// 
//

#include "MondoPS.h"
#include "BaseIPSIter.h"

#include "Point.h"

template <class P> char IA_WhiteHole_<P>::type_;

template <class P> char IA_BlackHole_<P>::type_;

#define WhiteIter IA_WhiteIter
#define BlackIter IA_BlackIter

template <class P>
class WhiteIter: public IA_BasePSIter<P> {
private:
    int	done;
public:
    WhiteIter(IA_WhiteHole_<P> *ps): IA_BasePSIter<P>(ps) { done=0; }
    IA_BasePSIter<P> *clone_self() {
	return new WhiteIter((IA_WhiteHole_<P>*)domain);
    }
    int next(P& ip) {
	if (done)
	    return 0;
	else {
	    ip = P();
	    done = 1;
	    return 1;
	}
    }
    void reset() { done=0; }
};

template <class P>
class BlackIter: public IA_BasePSIter<P> {
public:
    BlackIter(IA_BlackHole_<P> *ps): IA_BasePSIter<P>(ps) {}
    IA_BasePSIter<P> *clone_self() {
	return new BlackIter((IA_BlackHole_<P>*)domain);
    }
    int next(P&) {
	return 0;
    }
    void reset() {}
};

//
//
template <class P>
P IA_BlackHole_<P>::index(unsigned) const {
    if (IA::throw_on_index_uncontained)
	ia_throw(IA::PSET_INDEX_UNCONTAINED, __FILE__,__LINE__);
    return P();
}

template <class P>
IA_BasePSIter<P> * IA_BlackHole_<P>::iterator() const
{
    return new BlackIter<P>((IA_BlackHole_<P>*)this);
}

template <class P>
P IA_WhiteHole_<P>::index(unsigned idx) const {
    if (this->dimen!=0) {
	ia_throw(IA::PSET_REQUIRE_EXTENSIVE,__FILE__,__LINE__);
    }
    if (idx!=0) {
	if (IA::throw_on_index_uncontained)
	    ia_throw(IA::PSET_INDEX_UNCONTAINED, __FILE__,__LINE__);
    }
    return P();
}

template <class P>
IA_BasePSIter<P> * IA_WhiteHole_<P>::iterator() const
{
    return new WhiteIter<P>((IA_WhiteHole_<P>*)this);
}
