// Emacs: -*- C++ -*-

static char rcsid[] = "$Id: Point.C.m4,v 1.7 92/12/11 01:10:35 rjj Exp $";

/*

// $Log:	Point.C.m4,v $
//Revision 1.7  92/12/11  01:10:35  rjj
//Modified to support the IA_ prefix naming convention.
//Also put #ifdef IA_PRII around the #pragma stmt
//
//Revision 1.6  92/09/02  14:51:27  rjj
//Corrected code in FloatPoint( IntPoint ) to allocated array of type TYPE
//Changed enorm() cast from (float) to (double)
//
//Revision 1.5  92/09/01  21:08:17  rjj
//Changed max(POINT_TYPE,POINT_TYPE) to be supremum(POINT_TYPE,POINT_TYPE)
//Changed min(POINT_TYPE,POINT_TYPE) to be infimum(POINT_TYPE,POINT_TYPE)
//
//Revision 1.4  92/09/01  20:46:24  rjj
//Added support to ensure float op IntPoint and IntPoint op float yield FloatPoint.
//
//Revision 1.3  92/08/27  12:11:55  jnw
//Added C style comments around Log Messages to fixx gcc-cpp bug
//
//Revision 1.2  92/08/23  13:33:19  thoth
//Cfrontified
//didn't hint to inline for loop stuff any more (braindead compiler).
//hack-around for switch statements that CFront's flow analysis
//can't fully understand.
//throw changed to ia_throw.
//removed duplicate default values for formal parameters (ARM spec).
//
// Revision 1.1  92/08/20  22:24:54  rjj
// Initial revision
// 
// 
// 

*/

#include <math.h>
ifdef(`INTPOINT', `#include "IntPoint.h"')
ifdef(`FLOATPOINT', `#include "FloatPoint.h"')

#ifdef IA_PRII
#pragma implementation
#endif

ifdef(`FLOATPOINT',`    
//  FloatPoint includes IntPoint.h so we can have a constructor
//  from IntPoint to FloatPoint: this gives us all FloatPoint/IntPoint
//  operations for free.

    FloatPoint::FloatPoint(const IntPoint &ipt) {

//  new TYPE[0] will allocate a pointer to one TYPE; we ignore it
//  to keep from having to insert an "if (size == 0) ..." everywhere.

    this->coordinates = new TYPE[this->size = ipt.dimensions()];

#ifdef NO_LOOP_UNROLLING
   for (unsigned i = 0; i < this->size; i++)
	this->coordinates[i] = ipt[i];
#else
    switch (this->size) {
    case 5: this->coordinates[4] = ipt[4];
    case 4: this->coordinates[3] = ipt[3];
    case 3: this->coordinates[2] = ipt[2];
    case 2: this->coordinates[1] = ipt[1];
    case 1: this->coordinates[0] = ipt[0];
    case 0: break;     
    default:
	    {
		for (unsigned i = 0; i < this->size; i++)
		    this->coordinates[i] = ipt[i];
	    }
    }
#endif
}
')

POINT_TYPE extend_to_point (TYPE initial_value, unsigned length) {
    POINT_TYPE pt;

    pt.coordinates = new TYPE[pt.size = length];

#ifdef NO_LOOP_UNROLLING
    for (unsigned i = 0; i < length; i++)
	pt.coordinates[i] = initial_value;
#else
    switch (pt.size) {
    case 5: pt.coordinates[4] = initial_value;
    case 4: pt.coordinates[3] = initial_value;
    case 3: pt.coordinates[2] = initial_value;
    case 2: pt.coordinates[1] = initial_value;
    case 1: pt.coordinates[0] = initial_value;
    case 0: break;
    default:
	    {
		for (unsigned i = 0; i < length; i++)
		    pt.coordinates[i] = initial_value;
	    }
    }
#endif    
    return pt;
}


POINT_TYPE::POINT_TYPE (const POINT_TYPE &ip)
{

// new TYPE[0] creates a pointer to one TYPE; we never use it.
// This is to keep from having to do "if (size == 0) ..." everywhere.
// The destructor will delete it, though.
    
    this->coordinates = new TYPE[this->size = ip.size];

#ifdef NO_LOOP_UNROLLING    
    for (unsigned i=0; i<this->size; i++)
	this->coordinates[i] = ip.coordinates[i];
#else
    switch (this->size) {
    case 5: this->coordinates[4] = ip.coordinates[4];
    case 4: this->coordinates[3] = ip.coordinates[3];
    case 3: this->coordinates[2] = ip.coordinates[2];
    case 2: this->coordinates[1] = ip.coordinates[1];
    case 1: this->coordinates[0] = ip.coordinates[0];
    case 0: break;
    default:
	    {
		for (unsigned i=0; i<this->size; i++)
		    this->coordinates[i] = ip.coordinates[i];
	    }
    }
#endif
}

POINT_TYPE::POINT_TYPE (TYPE *vec, unsigned length, int giveaway)
{
    this->size=length;
    if (giveaway) {
	this->coordinates = vec;
	return;
    }
    
    this->coordinates = new TYPE[this->size];
    
#ifdef NO_LOOP_UNROLLING    
    for (unsigned length=0; length<this->size; length++)
	this->coordinates[length] = vec[length];
#else	
    switch (this->size) {
    case 5: this->coordinates[4] = vec[4];
    case 4: this->coordinates[3] = vec[3];
    case 3: this->coordinates[2] = vec[2];
    case 2: this->coordinates[1] = vec[1];
    case 1: this->coordinates[0] = vec[0];
    case 0: break;
    default:
	    {
		for (unsigned length=0; length<this->size; length++)
		    this->coordinates[length] = vec[length];
	    }
    }
#endif
}


POINT_TYPE &POINT_TYPE::operator = (const POINT_TYPE &point)
{
    // return directly when self-assignment (not sure the if is worth it in general)

    if (this == &point)
	return *this;

    // We need to deallocate/reallocate if differing sizes.
    
    if (point.size != this->size) {
        delete[] this->coordinates;
        this->coordinates = new TYPE[this->size = point.size];
    }

#ifdef NO_LOOP_UNROLLING
    for (unsigned i = 0; i < this->size; i++)
	this->coordinates[i] = point.coordinates[i];
#else
    switch (this->size) {
    case 5: this->coordinates[4] = point.coordinates[4];
    case 4: this->coordinates[3] = point.coordinates[3];
    case 3: this->coordinates[2] = point.coordinates[2];
    case 2: this->coordinates[1] = point.coordinates[1];
    case 1: this->coordinates[0] = point.coordinates[0];
    case 0: break;
    default:
	    {
		for (unsigned i = 0; i < this->size; i++)
		    this->coordinates[i] = point.coordinates[i];
	    }
    }
#endif
    return *this;
}

ostream &operator << (ostream &stream, const POINT_TYPE& point)
{
    int last_index = point.size - 1;
    stream << "<";
    for  ( int i = 0; i < last_index; ++i ) {
	stream << point.coordinates[i] << " ";
    }
    if ( point.size > 0 ) {
	stream << point.coordinates[last_index];
    };
    stream << ">";
    return stream;
}

COMPOUND_ARITH_ASSIGN_POINT(+)
COMPOUND_ARITH_ASSIGN_POINT(-)
COMPOUND_ARITH_ASSIGN_POINT(*)
COMPOUND_ARITH_ASSIGN_POINT(/)


COMPOUND_ARITH_ASSIGN_NUMBER(+)
COMPOUND_ARITH_ASSIGN_NUMBER(-)
COMPOUND_ARITH_ASSIGN_NUMBER(*)
COMPOUND_ARITH_ASSIGN_NUMBER(/)
    

ARITH_POINT_POINT(+)
ARITH_POINT_POINT(-)
ARITH_POINT_POINT(*)
ARITH_POINT_POINT(/)
    
ARITH_NUMBER_POINT(+)
ARITH_NUMBER_POINT(-)
ARITH_NUMBER_POINT(*)
ARITH_NUMBER_POINT(/)
    
ARITH_POINT_NUMBER(+)
ARITH_POINT_NUMBER(-)
ARITH_POINT_NUMBER(*)
ARITH_POINT_NUMBER(/)
    
ifdef(`FLOATPOINT', `ARITH_NUMBER_INTPOINT(+)')
ifdef(`FLOATPOINT', `ARITH_NUMBER_INTPOINT(-)')
ifdef(`FLOATPOINT', `ARITH_NUMBER_INTPOINT(*)')
ifdef(`FLOATPOINT', `ARITH_NUMBER_INTPOINT(/)')

ifdef(`FLOATPOINT', `ARITH_INTPOINT_NUMBER(+)')
ifdef(`FLOATPOINT', `ARITH_INTPOINT_NUMBER(-)')
ifdef(`FLOATPOINT', `ARITH_INTPOINT_NUMBER(*)')
ifdef(`FLOATPOINT', `ARITH_INTPOINT_NUMBER(/)')

const POINT_TYPE& POINT_TYPE::operator ++ () {
    if (this->size == 0) {
	ia_throw(IA::POINT_UNINITIALIZED, __FILE__, __LINE__);
	return *this;
    }
    *this += 1;
    return  *this;
}

const POINT_TYPE& POINT_TYPE::operator -- () {
    if (this->size == 0) {
	ia_throw(IA::POINT_UNINITIALIZED, __FILE__, __LINE__);
	return *this;
    }
    *this -= 1;
    return  *this;
}


POINT_TYPE POINT_TYPE::operator - () const
{
    POINT_TYPE result_point;

    if (this->size == 0) {
	ia_throw(IA::POINT_UNINITIALIZED, __FILE__, __LINE__);
	return result_point;
    }

    result_point.coordinates = new TYPE[result_point.size = this->size];

#ifdef NO_LOOP_UNROLLING
    for (unsigned i = 0; i < result_point.size; i++)
	result_point.coordinates[i] =  -this->coordinates[i];
#else
    switch (result_point.size) {
    case 5: result_point.coordinates[4] = -this->coordinates[4];
    case 4: result_point.coordinates[3] = -this->coordinates[3];
    case 3: result_point.coordinates[2] = -this->coordinates[2];
    case 2: result_point.coordinates[1] = -this->coordinates[1];
    case 1: result_point.coordinates[0] = -this->coordinates[0];
    case 0: break;
    default:
	    {
		for (unsigned i = 0; i < result_point.size; i++)
		    result_point.coordinates[i] =  - this->coordinates[i];
	    }
    }
#endif
    return result_point;
}

ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(%)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(<<)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(>>)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(&)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(^)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_POINT(|)')

ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(%)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(<<)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(>>)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(&)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(^)')
ifdef(`INTPOINT', `COMPOUND_BITWISE_ASSIGN_NUMBER(|)')

ifdef(`INTPOINT', `BITWISE_POINT_POINT(%)')
ifdef(`INTPOINT', `BITWISE_POINT_POINT(<<)')
ifdef(`INTPOINT', `BITWISE_POINT_POINT(>>)')
ifdef(`INTPOINT', `BITWISE_POINT_POINT(&)')
ifdef(`INTPOINT', `BITWISE_POINT_POINT(^)')
ifdef(`INTPOINT', `BITWISE_POINT_POINT(|)')

ifdef(`INTPOINT', `
IntPoint IntPoint::operator ~ () const
{
    IntPoint result_point;
    
    if (this->size == 0) {
	ia_throw(IA::POINT_UNINITIALIZED, __FILE__, __LINE__);
	return *this;
    }

    result_point.coordinates = new int[result_point.size = this->size];

#ifdef NO_LOOP_UNROLLING
    for (unsigned i = 0; i < result_point.size; i++)
	result_point.coordinates[i] =  ~(this->coordinates[i]);
#else
    switch (result_point.size) {
    case 5: result_point.coordinates[4] = ~(this->coordinates[4]);
    case 4: result_point.coordinates[3] = ~(this->coordinates[3]);
    case 3: result_point.coordinates[2] = ~(this->coordinates[2]);
    case 2: result_point.coordinates[1] = ~(this->coordinates[1]);
    case 1: result_point.coordinates[0] = ~(this->coordinates[0]);
    case 0: break;
    default:
	    {
		for (unsigned i = 0; i < result_point.size; i++)
		    result_point.coordinates[i] =  - this->coordinates[i];
	    }
    }
#endif    
    return result_point;
}')


ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(%)')
ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(<<)')
ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(>>)')
ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(&)')
ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(^)')
ifdef(`INTPOINT', `BITWISE_NUMBER_POINT(|)')

ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(%)')
ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(<<)')
ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(>>)')
ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(&)')
ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(^)')
ifdef(`INTPOINT', `BITWISE_POINT_NUMBER(|)')

// Relational operators

// POINT_TYPE < POINT_TYPE    

POINT_POINT_RELATION(<)
POINT_POINT_RELATION(<=)
POINT_POINT_RELATION(>)
POINT_POINT_RELATION(>=)
POINT_POINT_RELATION(==)
POINT_POINT_RELATION(!=)

// POINT_TYPE < int

POINT_INT_RELATION(<)
POINT_INT_RELATION(<=)
POINT_INT_RELATION(>)
POINT_INT_RELATION(>=)
POINT_INT_RELATION(==)
POINT_INT_RELATION(!=)

// int < POINT_TYPE 

INT_POINT_RELATION(<)
INT_POINT_RELATION(<=)
INT_POINT_RELATION(>)
INT_POINT_RELATION(>=)
INT_POINT_RELATION(==)
INT_POINT_RELATION(!=)

// POINT_TYPE < float
    
POINT_FLOAT_RELATION(<)
POINT_FLOAT_RELATION(<=)
POINT_FLOAT_RELATION(>)
POINT_FLOAT_RELATION(>=)
POINT_FLOAT_RELATION(==)
POINT_FLOAT_RELATION(!=)

// float < POINT_TYPE

FLOAT_POINT_RELATION(<)
FLOAT_POINT_RELATION(<=)
FLOAT_POINT_RELATION(>)
FLOAT_POINT_RELATION(>=)
FLOAT_POINT_RELATION(==)
FLOAT_POINT_RELATION(!=)


// Index derangement: "POINT_TYPE (point_index, point_index..)"
//
// Function call overloading on Point gives us a new Point with
// by-point_index selection.  For instance, let  a=Point(10, 20, 30).
// Then b=a(2,0) is equivalent to b=Point(30,10).


POINT_TYPE POINT_TYPE::operator () (unsigned i0) const
{
    POINT_TYPE p(0);
    
    if (i0 >= this->size) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    }
    p.coordinates[0] = this->coordinates[i0];
    return p;
}

POINT_TYPE POINT_TYPE::operator () (unsigned i0, unsigned i1) const
{
    POINT_TYPE p((int)0,(int)0);

    if (i0 >= this->size || i1 >= this->size) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    }
    p.coordinates[0] = this->coordinates[i0];
    p.coordinates[1] = this->coordinates[i1];
    return p;
}

POINT_TYPE POINT_TYPE::operator () (unsigned i0, unsigned i1, unsigned i2) const
{
    POINT_TYPE p((int)0,0,0);

    if (i0 >= this->size || i1 >= this->size || i2 >= this->size) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    }
    
    p.coordinates[0] = this->coordinates[i0];
    p.coordinates[1] = this->coordinates[i1];
    p.coordinates[2] = this->coordinates[i2];
    return p;
}

POINT_TYPE POINT_TYPE::operator () (unsigned i0, unsigned i1, unsigned i2, unsigned i3) const
{
    POINT_TYPE p(0,0,0,0);

    if (i0 >= this->size || i1 >= this->size || i2 >= this->size || i3 >= this->size) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    }

    p.coordinates[0] = this->coordinates[i0];
    p.coordinates[1] = this->coordinates[i1];
    p.coordinates[2] = this->coordinates[i2];
    p.coordinates[3] = this->coordinates[i3];
    return p;
}

POINT_TYPE POINT_TYPE::operator () (unsigned i0, unsigned i1, unsigned i2, unsigned i3, unsigned i4) const
{
    POINT_TYPE p(0,0,0,0,0);

    if (i0 >= this->size || i1 >= this->size || i2 >= this->size ||
	i3 >= this->size || i4 >= this->size) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    }

    p.coordinates[0] = this->coordinates[i0];
    p.coordinates[1] = this->coordinates[i1];
    p.coordinates[2] = this->coordinates[i2];
    p.coordinates[3] = this->coordinates[i3];
    p.coordinates[4] = this->coordinates[i4];
    return p;
}
    

// enorm: Euclidean distance from origin.

double POINT_TYPE::enorm () const
{
    double result_number = 0;
    
    for (unsigned i = 0; i < this->size; i++)
	result_number = result_number +
	    (double) (this->coordinates[i] * this->coordinates[i]);

    return sqrt(result_number);
}


// POINT_TYPE = concat (POINT_TYPE, POINT_TYPE)
//
// Given a combination of Points and numbers, create a new Point that is
// the concatenation of the arguments.  Lets the user construct larger
// points than the usual 5 arg constructor.

// TO DO -- These could be modified to not check for zero-length
// points (since we now know that "new foo[0]" returns a deletable
// pointer to one foo that we will never access), and also we could
// do some loop unrolling here as well.

POINT_TYPE concat(const POINT_TYPE& lhs, const POINT_TYPE& rhs)
{
    POINT_TYPE result_point;
    
    if (lhs.size == 0) {
	if (rhs.size == 0)
	    return result_point;
	else 
	    return rhs;
    } else if (rhs.size == 0)
	return lhs;

    unsigned int total_size = lhs.size + rhs.size;

    result_point.coordinates = new TYPE[result_point.size = total_size];
    
    for (unsigned int i = 0; i < lhs.size; i++) 
	result_point.coordinates[i] = lhs.coordinates[i];

    for (unsigned int j = 0; j < rhs.size; j++) 
	result_point.coordinates[i+j] = rhs.coordinates[j];

    return result_point;
}

// POINT_TYPE = concat(POINT_TYPE, TYPE)

POINT_TYPE concat(const POINT_TYPE& lhs, TYPE rhs)
{
    POINT_TYPE result_point;

    if (lhs.size == 0) 
	return POINT_TYPE (rhs);
    
    unsigned int total_size = lhs.size + 1;

    result_point.coordinates = new TYPE[total_size];
    result_point.size = total_size;
    
    for (unsigned int i = 0; i < lhs.size; i++) 
	result_point.coordinates[i] = lhs.coordinates[i];
    
    result_point.coordinates[i] = rhs;
    
    return result_point;
}

// POINT_TYPE = concat(TYPE, POINT_TYPE)

POINT_TYPE concat(TYPE lhs, const POINT_TYPE& rhs)
{
    POINT_TYPE result_point;
    
    if (rhs.size == 0)
	return POINT_TYPE (lhs);

    unsigned int total_size = rhs.size + 1;

    result_point.coordinates = new TYPE[total_size];
    result_point.size = total_size;

    result_point.coordinates[0] = lhs;

    for (unsigned int i = 0; i < rhs.size; i++) 
	result_point.coordinates[i+1] = rhs.coordinates[i];

    return result_point;
}

//  cdr(POINT_TYPE, skip=1):
//
//  Given a point of dimension n, return a point made of the n-skip last
//  coordinates (or if skip is negative, the n+skip first coordinates),
//  where skip defaults to 1.


POINT_TYPE cdr(const POINT_TYPE& pt, int skip) {

    unsigned  abs_skip;

    abs_skip = (skip < 0) ? -skip : skip;
    
    if (pt.size < abs_skip) {
	ia_throw(IA::POINT_INDEX_MISMATCH, __FILE__, __LINE__);
	return POINT_TYPE ();
    } else if (pt.size == skip)
	return POINT_TYPE ();

    if (skip < 0)
	return POINT_TYPE (pt.coordinates, pt.size+skip);
    else
	return POINT_TYPE (pt.coordinates+skip, pt.size-skip);
}

FRIEND_SELECT_BINARY(infimum, <)
FRIEND_SELECT_UNARY(min, <)

FRIEND_SELECT_BINARY(supremum, >)
FRIEND_SELECT_UNARY(max, >)

ifdef(`FLOATPOINT', `
// Math rounding functions as friends.
//  
// All of the following routines perform some rounding function.  Except
// for irint, nint and trunc, the routines always return float points.
// irint, nint, and trunc alway pass back int points.  See rint (3)
// for details.')

ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_FLOAT(aint)')
ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_FLOAT(anint)')
ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_FLOAT(ceil)')
ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_FLOAT(floor)')
ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_FLOAT(rint)')

ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_INT(irint)')
ifdef(`FLOATPOINT', `ROUNDING_FLOAT_TO_INT(nint)')

ifdef(`FLOATPOINT', `
IntPoint trunc(const FloatPoint& p) 
{ 
    int	*iptr;
    iptr = new int[p.size];	    

#ifdef NO_LOOP_UNROLLING
    for (unsigned i = 0; i < p.size; i++) 
	iptr[i] = int(p.coordinates[i]);    
#else
    switch (p.size) {
    case 5: iptr[4] = int(p.coordinates[4]);
    case 4: iptr[3] = int(p.coordinates[3]);
    case 3: iptr[2] = int(p.coordinates[2]);
    case 2: iptr[1] = int(p.coordinates[1]);
    case 1: iptr[0] = int(p.coordinates[0]);
    case 0: break;
    default:
	    {
		for (unsigned i = 0; i < p.size; i++) 
		    iptr[i] = int(p.coordinates[i]);
	    }
    }
#endif    
    return IntPoint(iptr, p.size, 1);
}')


//  Point comparison: Pointcmp(POINT_TYPE, POINT_TYPE)
//
// A sort of lexicographic comparison of Points, except that
// points are zero extended for comparison, e.g., <1 0> is equal
// to <1>;  <> is equal <0 0 0>, etc. Returns 0 for equality, -1
// if the first is less than the second, 1 if the first is greater
// than the second,

int Pointcmp(const POINT_TYPE &lhs, const POINT_TYPE &rhs)
{
    if (lhs.dimensions() > rhs.dimensions()) {
	for (unsigned i=0; i < rhs.dimensions(); i++) {
	    if (lhs[i] < rhs[i])
		return -1;
	    else if (lhs[i] > rhs[i])
		return 1;
	}
	for ( ; i<lhs.dimensions(); i++) {
	    if (lhs[i] < 0)
		return -1;
	    else if (lhs[i] > 0)
		return 1;
	}
    } else {
	for (unsigned i=0; i < lhs.dimensions(); i++) {
	    if (lhs[i] < rhs[i])
		return -1;
	    else if (lhs[i] > rhs[i])
		return 1;
	}
	for ( ; i < rhs.dimensions(); i++) {
	    if (0 < rhs[i])
		return  -1;
	    else if (0 > rhs[i])
		return  1;
	}
    }
    return 0;

    // If this were to be used for a lexicographic sorter, then we would
    // need the following additional code:
    //
    // At this point the zero-extended Coordinates do not differ in value,
    // so check for number of dimensions; shorter Points are considered
    // less than longer Points.
    // 
    //     if (lhs.dimensions() == rhs.dimensions())
    // 		return 0;
    //     else if (lhs.dimensions() > rhs.dimensions())
    // 		return 1;
    //     else
    // 		return -1;

}
