
 

// Emacs: -*- C++ -*-

/*
        Copyright 1993, Center for Computer Vision and Visualization,
        University of Florida.  All rights reserved.

// $Log:	Point.h.m4,v $
// Revision 2.13  93/05/26  16:59:41  rjj
// Added copyright notice
// 
// Revision 2.12  93/04/29  21:51:17  rjj
// Added missing  const  for  POINT op NUMBER.  See change in defines.m4 also.
// 
// Revision 2.11  93/04/06  22:25:39  rjj
// Removed const from "const int" and "const double"
// Changed bitwise unsigned parameters to int
// removed backwards compability with IntPoint and FloatPoint
// 
// Revision 2.10  93/04/05  23:00:56  rjj
// Many changes:
//   member size renamed to dimen
//   member dimensions() renamed as dim()
//   postfix members ++ and -- added
//   operator() changed into member derange() and extended with array version
//   member infimum() rename to inf()
//   member supremum() renamed to sup()
//   all references to IntPoint changed to IA_IntPoint
//   all references to FloatPoint changed to IA_FloatPoint
//   change to map IA_IntPoint to IntPoint now does the reverse
//   change to map IA_FloatPoint to FloatPoint now does the reverse
//   file reorganized to group related members as I saw fit
//   in general the interface as been mutated into the interface
//     reflected by newpoint, which spans Point.h, ArithPoint.h
//     LatticePoint.h, BitwisePoint.h and of course
//     IntPoint.h and FloatPoint.h
// 
// Revision 2.9  92/12/11  01:11:57  rjj
// Modified to support the IA_ prefix naming convention.
// Also put #ifdef IA_PRII around the #pragma stamt
// 
// Revision 2.8  92/09/02  14:50:44  rjj
// Corrected renameing of min to infimum and max to supremum
// 
// Revision 2.7  92/09/01  20:45:29  rjj
// Added support to ensure float op IntPoint and IntPoint op float
//  yield FloatPoint.
// 
// Revision 2.6  92/08/28  11:55:11  jnw
// Changed relation functions with IA_FloatPoint& and float args
// to have IA_FloatPoint& and double args to match current .C code
// 
// Revision 2.5  92/08/27  12:11:27  jnw
// Added C style comments around Log Messages to fixx gcc-cpp bug
// 
// Revision 2.4  92/08/23  13:35:47  thoth
// CFrontified
// throw changed to ia_throw.
// didn't hint to inline for loop stuff any more (braindead compiler).
// fixed const pass-by-value problem.
// 
// 

*/

#ifndef IA_FloatPoint_h_
#define IA_FloatPoint_h_

#include "ia.h"

#ifdef IA_PRII
#pragma interface
#endif

#include "IntPoint.h"

class IA_FloatPoint {
    
  protected:  
    unsigned dimen;
    double *coordinates;
    
  public:
    ////////////////////////////////////////////////////////////
    // C O N S T R U C T O R S
    ////////////////////////////////////////////////////////////
    
    IA_FloatPoint (const IA_FloatPoint&);

    IA_FloatPoint () {coordinates = 0; dimen = 0; }
    
    IA_FloatPoint (double c0) {
	coordinates = new double[dimen = 1];
	coordinates[0] =  c0;
    }
    
    IA_FloatPoint (double c0, double c1) {
	coordinates = new double[dimen = 2];
	coordinates[0] = c0;
	coordinates[1] = c1;
    }
    
    IA_FloatPoint (double c0, double c1, double c2) {
	coordinates = new double[dimen = 3];
	coordinates[0] = c0;
	coordinates[1] = c1;
	coordinates[2] = c2;
    }
    
    IA_FloatPoint (double c0, double c1, double c2, double c3) {
	coordinates = new double[dimen = 4];
	coordinates[0] = c0;
	coordinates[1] = c1;
	coordinates[2] = c2;
	coordinates[3] = c3;
    }
    
    IA_FloatPoint (double c0, double c1, double c2, double c3, double c4) {
	coordinates = new double[dimen = 5];
	coordinates[0] = c0;
	coordinates[1] = c1;
	coordinates[2] = c2;
	coordinates[3] = c3;
	coordinates[4] = c4;
    }

//  FloatPoint includes IntPoint.h so we can have a constructor from
//  IA_IntPoint to IA_FloatPoint: this gives us all
//  IA_FloatPoint/IA_IntPoint  operations for free.

    IA_FloatPoint(const IA_IntPoint &ipt);

    IA_FloatPoint (double *, unsigned, int =0);

    // Index-derangement functions.
    IA_FloatPoint    derange (unsigned) const;
    IA_FloatPoint    derange (unsigned, unsigned) const;
    IA_FloatPoint    derange (unsigned, unsigned, unsigned) const;
    IA_FloatPoint    derange (unsigned, unsigned, unsigned, unsigned) const;
    IA_FloatPoint    derange (unsigned, unsigned, unsigned,
			   unsigned, unsigned) const;

    // Index-derangement, indices given by an array
    IA_FloatPoint    derange (unsigned *, const unsigned) const;

    friend IA_FloatPoint    extend_to_point (double, unsigned);
    
    friend IA_FloatPoint    concat   (const IA_FloatPoint&, const IA_FloatPoint&);
    friend IA_FloatPoint    concat   (const IA_FloatPoint&, double);
    friend IA_FloatPoint    concat   (double, const IA_FloatPoint&);

    friend IA_FloatPoint    cdr      (const IA_FloatPoint&, int =1);

    // The destructor for this class
    ~IA_FloatPoint () { delete[] coordinates; }  // OK even if coordinates NULL.

    ////////////////////////////////////////////////////////////
    // M I S C    O P E R A T I O N S
    ////////////////////////////////////////////////////////////

    IA_FloatPoint& operator = (const IA_FloatPoint&);

    unsigned            dim () const { return dimen; }

    friend IA_FloatPoint	inf    (const IA_FloatPoint&, const IA_FloatPoint&);
    friend double		min    (const IA_FloatPoint&);
    friend IA_FloatPoint	sup    (const IA_FloatPoint&, const IA_FloatPoint&);
    friend double		max    (const IA_FloatPoint&);

    friend ostream& operator << (ostream&, const IA_FloatPoint&);

    ////////////////////////////////////////////////////////////
    // I N D E X I N G    O P E R A T I O N S
    ////////////////////////////////////////////////////////////

    double&      operator[] (unsigned i)       { return coordinates[i]; }
    const double operator[] (unsigned i) const { return coordinates[i]; }

    ////////////////////////////////////////////////////////////
    // A R I T H M E T I C   O P E R A T I O N S
    ////////////////////////////////////////////////////////////

    IA_FloatPoint&   operator +=  (const IA_FloatPoint&);
    IA_FloatPoint&   operator -=  (const IA_FloatPoint&);
    IA_FloatPoint&   operator *=  (const IA_FloatPoint&);
    IA_FloatPoint&   operator /=  (const IA_FloatPoint&);

    IA_FloatPoint&   operator +=  (double);
    IA_FloatPoint&   operator -=  (double);
    IA_FloatPoint&   operator *=  (double);
    IA_FloatPoint&   operator /=  (double);
    
    IA_FloatPoint    operator +  (const IA_FloatPoint&) const;
    IA_FloatPoint    operator -  (const IA_FloatPoint&) const;
    IA_FloatPoint    operator *  (const IA_FloatPoint&) const;
    IA_FloatPoint    operator /  (const IA_FloatPoint&) const;
    
    IA_FloatPoint    operator +  (double) const;
    IA_FloatPoint    operator -  (double) const;
    IA_FloatPoint    operator *  (double) const;
    IA_FloatPoint    operator /  (double) const;
    
    friend IA_FloatPoint    operator +  (double, const IA_FloatPoint&);
    friend IA_FloatPoint    operator -  (double, const IA_FloatPoint&);
    friend IA_FloatPoint    operator *  (double, const IA_FloatPoint&);
    friend IA_FloatPoint    operator /  (double, const IA_FloatPoint&);

//  Ensure that float args yield IA_FloatPoint answers.
    friend IA_FloatPoint    operator +  (const IA_IntPoint&, double);
    friend IA_FloatPoint    operator -  (const IA_IntPoint&, double);
    friend IA_FloatPoint    operator *  (const IA_IntPoint&, double);
    friend IA_FloatPoint    operator /  (const IA_IntPoint&, double);

    friend IA_FloatPoint    operator +  (double, const IA_IntPoint&);
    friend IA_FloatPoint    operator -  (double, const IA_IntPoint&);
    friend IA_FloatPoint    operator *  (double, const IA_IntPoint&);
    friend IA_FloatPoint    operator /  (double, const IA_IntPoint&);

    IA_FloatPoint    operator -   () const;

    // Prefix operators
    IA_FloatPoint&   operator ++  ();
    IA_FloatPoint&   operator --  ();

    // Postfix operators
    IA_FloatPoint    operator ++ (int);
    IA_FloatPoint    operator -- (int);

    double   enorm() const;   // Cartesian distance

    friend IA_FloatPoint aint  (IA_FloatPoint);
    friend IA_FloatPoint anint (IA_FloatPoint);
    friend IA_FloatPoint ceil  (IA_FloatPoint);
    friend IA_FloatPoint floor (IA_FloatPoint);
    friend IA_FloatPoint rint  (IA_FloatPoint);

    friend IA_IntPoint   irint (const IA_FloatPoint&);
    friend IA_IntPoint   nint  (const IA_FloatPoint&);
    friend IA_IntPoint   trunc (const IA_FloatPoint&);

    ////////////////////////////////////////////////////////////
    // L A T T I C E   O P E R A T I O N S
    ////////////////////////////////////////////////////////////

    int    operator <   (const IA_FloatPoint&) const;
    int    operator <=  (const IA_FloatPoint&) const;
    int    operator >   (const IA_FloatPoint&) const;
    int    operator >=  (const IA_FloatPoint&) const;
    int    operator ==  (const IA_FloatPoint&) const;
    int    operator !=  (const IA_FloatPoint&) const;

    int    operator <   (double) const;
    int    operator <=  (double) const;
    int    operator >   (double) const;
    int    operator >=  (double) const;
    int    operator ==  (double) const;
    int    operator !=  (double) const;

    friend  int    operator <   (double, const IA_FloatPoint&);
    friend  int    operator <=  (double, const IA_FloatPoint&);
    friend  int    operator >   (double, const IA_FloatPoint&);
    friend  int    operator >=  (double, const IA_FloatPoint&);
    friend  int    operator ==  (double, const IA_FloatPoint&);
    friend  int    operator !=  (double, const IA_FloatPoint&);

    friend  int    Pointcmp (const IA_FloatPoint&, const IA_FloatPoint&);

};

#endif
