#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

#
# $Log:	gen-conv-h.perl,v $
# Revision 1.2  93/05/27  11:46:09  thoth
# Copyright Notices
# 
# Revision 1.1  93/03/18  11:22:28  thoth
# Initial revision
# 

sub file_subst {
	local ($fname,
		$init, $accum, $final,
		$rtype, $name, $itype, $ttype, $zero) = @_;
	open(FILE, "<$fname") ||
		die "couldn't open $fname";
	local($_);
	local($/) = -1;
	$_ = <FILE>;

	s/\bINITIALIZE\b/$init/g;
	s/\bACCUMULATE\b/$accum/g;
	s/\bRESULT\b/$final/g;

	s/\bRTYPE\b/$rtype/g;
	s/CONV/$name/g;
	s/\bITYPE\b/$itype/g;
	s/\bTTYPE\b/$ttype/g;
	s/\bZERO\b/$zero/g;

	s/\bIVAL\b/(base[offsets[i]])/g;
	s/\bTVAL\b/(templ_data[i])/g;
	s/\bIRESULT\b/(*valp)/g;

	print $_;

	$/ = '\n';

	close(FILE);
}

while (<>) {
    next if /^\s*$/;

    if (/^#/) {
	print "//", $';
	next;
    }

    print "// $_";

    @_ = split;

    local($rtype, $name, $itype, $ttype, @blah) = @_;
   #unless ($ttype =~ m-/-) {die "template type must be of form image/base\n";}
    $titype = "IA_DiscreteImage<$ttype> ";

    @_ = @blah;

    local($zero);

    while (@_) {
	$_ = shift(@_);

	if (/^zero=/) {
		$zero = $';
	} else {
		warn "Unknown option $_. ";
	}
    }

    $_ = <>; chop;
    /^init:\t/ || die "no initiazlier for convolution $name\n";

    $_ = <>; chop;
    /^accum:\t/ || die "no accumulator for convolution $name\n";

    $_ = <>; chop;
    if (/^accvar:\t/) {
	$_ = <>; chop;
    }
    /^final:\t/ || die "no final for convolution $name\n";

    print "friend ";
    print "IA_DiscreteImage<$rtype> $name(",
	"const IA_DiscreteImage<$itype> &img,\n",
	"\t\tconst IA_DDTemplate<$titype> &invtempl,\n",
	"\t\tIA_IntPointSet dest_ps);\n";
    print "\n";
}
