#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

#
# $Log:	gen-conv-c.perl,v $
# Revision 1.3  93/05/27  11:46:04  thoth
# Copyright Notices
# 
# Revision 1.2  93/04/29  11:21:43  thoth
# IBTYPE is now used in a #define symbol.
# 
# Revision 1.1  93/03/18  11:22:02  thoth
# Initial revision
# 

sub file_subst {
	local ($fname,
		$init, $accum, $accvar, $final,
		$rtype, $name, $itype, $tbtype, $titype, $zero) = @_;
	local ($ival, $tval, $rval) = ("#undef#","#undef#","#undef#");
	local($_);
	local($/) = -1;

	open(FILE, "<$fname") ||
		die "couldn't open $fname";

	$_ = <FILE>;

	if (m-^// _IVAL_=-) {
		print STDERR "IVAL: ", $';
	}

	s/\bINITIALIZE\b/$init/g;
	s/\bACCUMULATE\b/$accum/g;
	s/\bACCUMULATEVAR\b/$accvar/g;
	s/\bRESULT\b/$final/g;

	s/\bRTYPE\b/$rtype/g;
	s/CONV/$name/g;
	s/IBTYPE\b/$itype/g;
	s/\bTBTYPE\b/$tbtype/g;
	s/\bTITYPE\b/$titype/g;
	s/\bZERO\b/$zero/g;

	local(@_) = split("\n");
	foreach (@_) {
		if (m:^\s*//\s*_IVAL_=:)    { $ival = $'; next; }
		if (m:^\s*//\s*_TVAL_=:)    { $tval = $'; next; }
		if (m:^\s*//\s*_IRESULT_=:) { $rval = $'; next; }
		s/\bIVAL\b/$ival/g;
		s/\bTVAL\b/$tval/g;
		s/\bIRESULT\b/$rval/g;
	}

	print join("\n", @_);

	$/ = '\n';

	close(FILE);
}

while (<>) {
    next if /^\s*$/;

    if (/^#/) {
	print "//", $';
	next;
    }

    print "// $_";

    @_ = split;

    local($rtype, $name, $itype, $ttype, @blah) = @_;
   #unless ($ttype =~ m-/-) {die "template type must be of form image/base\n";}
    $titype = "IA_DiscreteImage<$ttype> ";

    @_ = @blah;

    local($zero);

    while (@_) {
	$_ = shift(@_);

	if (/^zero=/) {
		$zero = $';
	} else {
		warn "Unknown option $_. ";
	}
    }

    $_ = <>; chop;
    /^init:\t/ || die "no initiazlier for convolution $name\n";
    $init = $';

    $_ = <>; chop;
    /^accum:\t/ || die "no accumulator for convolution $name\n";
    $accum = $';

    $_ = <>; chop;
    if (/^accvar:\t/) {
	$accvar = $';
	$_ = <>; chop;
    } else {
	$accvar = $accum;
    }
    /^final:\t/ || die "no final for convolution $name\n";
    $final = $';

    if ($zero ne "") {
	&file_subst("absorber", $init, $accum, $accvar, $final,
			$rtype, $name, $itype, $ttype, $titype, $zero);
    } else {
	print "// non-absorbers not handled yet\n";
    }

    print "\n";
}
