// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	VectorDIVIter.h,v $
// Revision 1.5  93/05/27  11:22:49  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/17  18:45:18  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.3  93/02/20  12:43:39  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.2  93/01/19  14:56:47  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/12  17:05:36  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:46:15  jnw
// Initial revision
// 

#ifndef VectorDIVIter_h_
#define VectorDIVIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "VectorDI.h"

template <class T>
class IA_VectorDIVIter: public IA_BaseDIVIter<T> {
protected:
    // num_left stores the number of points in this image\'s PointSet
    // remaining to be iterated.
    int num_left;

    // index stores the index of the current point within the value vector
    int index;

    // vdip points at the base image over which we're iterating.
    IA_VectorDI<T> *vdip() const { return (IA_VectorDI<T> *)domain; }

public:

    IA_VectorDIVIter(const IA_VectorDI<T> *);
    IA_VectorDIVIter(const IA_VectorDIVIter&);

    ~IA_VectorDIVIter() {}

    IA_BaseDIVIter<T> * clone_self() { return new IA_VectorDIVIter(*this); }
    int next(T&);
    void reset() { this->num_left = this->domain->domain().card();
		   this->index =0; }

    IA_BaseDI<T> *domain_() const { return this->domain; }
};

#endif
