// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char VectorDIPIterrcsid[] = "$Id: VectorDIPIter.c,v 1.6 93/05/27 11:28:32 thoth Exp $";

// $Log:	VectorDIPIter.c,v $
// Revision 1.6  93/05/27  11:28:32  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:45:14  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:43:34  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.3  93/01/19  14:56:42  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/12  17:02:14  jnw
// Modified to go along with new value/pixel iter style
// 
// Revision 1.1  92/10/05  11:46:07  jnw
// Initial revision
// 

#include "VectorDIPIter.h"

template <class T>
IA_VectorDIPIter<T>::IA_VectorDIPIter(const IA_VectorDI<T> *img)
: IA_BaseDIPIter<T>(img), psiter(img->domain())
{
    index = 0;
}

template <class T>
IA_VectorDIPIter<T>::IA_VectorDIPIter(const IA_VectorDIPIter<T> &iter)
: IA_BaseDIPIter<T>(iter.domain), psiter(iter.psiter)
{
    this->index = iter.index;
}

template <class T>
int IA_VectorDIPIter<T>::next(IA_IntPoint& pixel_location, T& pixel_value)
{
    if (!psiter(pixel_location))
	return 0;
    pixel_value = vdip()->vec[index++];
    return 1;
}




