//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log:	uchar-convolutions.desc,v $
// Revision 1.2  93/05/27  11:41:16  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:26:37  thoth
// Initial revision
// 
// u_char gcon u_char u_char zero=0
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_u_char
#define zero_extend_scan_u_char

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const u_char **src,
				 u_char **dest,
				 u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<u_char> *srciter,
				  u_char **dest,
				  u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_UcharDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, u_char *dest_data,
			u_char zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<u_char>::s_type()) {
	u_char	*srcdata = ((IA_VectorDI<u_char>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<u_char>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_UcharDiscreteImage
gcon_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const u_char *src_data, // length is prod(src_width)
	      const IA_UcharDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    u_char	*const templ_data = new u_char[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	u_char	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<u_char>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    u_char *const	dest_data = new u_char[dest_ps.card()];
    u_char *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const u_char *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	u_char	a = 0; ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_UcharDiscreteImage
gcon_inv(const IA_UcharDiscreteImage &img,
	 const IA_UcharDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    u_char	*const src_data = new u_char[src_ps.card()];

    zero_extend(img, src_ps, src_data, 0);
    IA_UcharDiscreteImage	rval =
	gcon_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_UcharDiscreteImage gcon(const IA_UcharDiscreteImage &img,
			     const IA_UcharDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_UcharDiscreteImage >::s_type()) {
	return gcon_inv(img, ((IA_InvariantDT<IA_UcharDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	u_char *const	dest_data = new u_char[dest_ps.card()];
	u_char	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_UcharDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<u_char>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    u_char	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    u_char	a = 0; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		a += img(ip) * templ_val; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
// u_char addmax u_char u_char zero=0
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_u_char
#define zero_extend_scan_u_char

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const u_char **src,
				 u_char **dest,
				 u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<u_char> *srciter,
				  u_char **dest,
				  u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_UcharDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, u_char *dest_data,
			u_char zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<u_char>::s_type()) {
	u_char	*srcdata = ((IA_VectorDI<u_char>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<u_char>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_UcharDiscreteImage
addmax_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const u_char *src_data, // length is prod(src_width)
	      const IA_UcharDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    u_char	*const templ_data = new u_char[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	u_char	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<u_char>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    u_char *const	dest_data = new u_char[dest_ps.card()];
    u_char *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const u_char *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	u_char	a=0; ;

	for (i=0; i<templ_sz; i++) {
	    u_char temp = (base[templ_offsets[i]])+(templ_data[i]); if (temp > a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_UcharDiscreteImage
addmax_inv(const IA_UcharDiscreteImage &img,
	 const IA_UcharDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    u_char	*const src_data = new u_char[src_ps.card()];

    zero_extend(img, src_ps, src_data, 0);
    IA_UcharDiscreteImage	rval =
	addmax_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_UcharDiscreteImage addmax(const IA_UcharDiscreteImage &img,
			     const IA_UcharDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_UcharDiscreteImage >::s_type()) {
	return addmax_inv(img, ((IA_InvariantDT<IA_UcharDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	u_char *const	dest_data = new u_char[dest_ps.card()];
	u_char	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_UcharDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<u_char>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    u_char	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    u_char	a=0; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		u_char temp = img(ip)+templ_val; if (temp > a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
// u_char addmin u_char u_char  zero=255
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	absorber,v $
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_IntPoint membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

#ifndef zero_extend_scan_u_char
#define zero_extend_scan_u_char

static void zero_extend_vec_scan(const IA_SetStructure &ss,
				 const u_char **src,
				 u_char **dest,
				 u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    (*src) += temp.count;
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    for (unsigned j=0; j<temp.count; j++) {
		*((*dest)++) = *((*src)++);
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_vec_scan(temp.substructure, src, dest, zero);
	}
    }
}

static void zero_extend_iter_scan(const IA_SetStructure &ss,
				  IA_DIVIter<u_char> *srciter,
				  u_char **dest,
				  u_char zero)
{
    for (unsigned i=0; i<ss.nintervals(); i++) {
	IA_ss_interval	temp(ss.retrieve_interval(i));
	if (temp.substructure == IA_SetStructure::FIRST_ONLY) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) 
		(*srciter)(blah);
	} else if (temp.substructure == IA_SetStructure::BOTH) {
	    u_char	blah;
	    for (unsigned j=0; j<temp.count; j++) {
		(*srciter)(blah);
		*((*dest)++) = blah;
	    }
	} else if (temp.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (unsigned j=0; j<temp.count; j++)
		*((*dest)++) = zero;
	} else {
	    for (unsigned j=0; j<temp.count; j++)
		zero_extend_iter_scan(temp.substructure, srciter, dest, zero);
	}
    }
}

static void zero_extend(const IA_UcharDiscreteImage &srcimg,
			const IA_IntPointSet &dest_ps, u_char *dest_data,
			u_char zero)
{
    IA_SetStructure	ss;
    intersect_with_dualstruct(srcimg.domain(), dest_ps, &ss);

    if (srcimg.type() == IA_VectorDI<u_char>::s_type()) {
	u_char	*srcdata = ((IA_VectorDI<u_char>*)srcimg.bdip)->vec;
	zero_extend_vec_scan(ss, &srcdata, &dest_data, zero);
    } else {
	IA_DIVIter<u_char>	iter(srcimg);
	zero_extend_iter_scan(ss, &iter, &dest_data, zero);
    }
}

#endif

static IA_UcharDiscreteImage
addmin_inv_core(IA_IntPoint src_infimum,
	      IA_IntPoint src_width,
	      const u_char *src_data, // length is prod(src_width)
	      const IA_UcharDiscreteImage &templ,
	      IA_IntPointSet dest_ps)
{
    const int	dimen = src_width.dim();

    IA_IntPointSet	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    u_char	*const templ_data = new u_char[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	u_char	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_DIPIter<u_char>	iter(templ);
	IA_IntPoint	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_IPSIter	iter(dest_ps);
    IA_IntPoint	ip;
    u_char *const	dest_data = new u_char[dest_ps.card()];
    u_char *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const u_char *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	u_char	a=255; ;

	for (i=0; i<templ_sz; i++) {
	    register u_char ival = (base[templ_offsets[i]]); if (ival == 255) continue; u_char temp = ival+(templ_data[i]); if (temp < a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_UcharDiscreteImage
addmin_inv(const IA_UcharDiscreteImage &img,
	 const IA_UcharDiscreteImage &invtempl,
	 IA_IntPointSet dest_ps)
{
    IA_IntPoint	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_IntPoint	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_IntPointSet	src_ps = IA_IntPointSet(inf_,sup_);

    u_char	*const src_data = new u_char[src_ps.card()];

    zero_extend(img, src_ps, src_data, 255);
    IA_UcharDiscreteImage	rval =
	addmin_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_UcharDiscreteImage addmin(const IA_UcharDiscreteImage &img,
			     const IA_UcharDDTemplate &templ,
			     IA_IntPointSet dest_ps)
{
    if (templ.type() == IA_InvariantDT<IA_UcharDiscreteImage >::s_type()) {
	return addmin_inv(img, ((IA_InvariantDT<IA_UcharDiscreteImage >*)templ.bdtp)->value, dest_ps);
    } else {
	u_char *const	dest_data = new u_char[dest_ps.card()];
	u_char	*valp = dest_data;
	IA_IPSIter	dest_iter(dest_ps);
	IA_IntPoint	base_ip;
	while (dest_iter(base_ip)) {
	    IA_UcharDiscreteImage	tv = templ(base_ip);

	    IA_DIPIter<u_char>	templ_iter(tv);
	    IA_IntPoint	templ_ip;
	    u_char	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    u_char	a=255; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_IntPoint	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		u_char temp = img(ip)+templ_val; if (temp < a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_UcharDiscreteImage(dest_ps, dest_data, dest_ps.card(), 1);
    }
}
