// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	OtherDIIter.h,v $
// Revision 1.3  93/05/27  11:22:35  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/17  18:45:10  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.1  93/03/10  12:59:25  thoth
// Initial revision
// 

#ifndef OtherDIIter_h_
#define OtherDIIter_h_

#include "IPSIter.h"
#include "BaseDIIter.h"

template <class T>
class IA_OtherDIVIter: public IA_BaseDIVIter<T> {
  protected:
    // iterator over the domain
    IA_IPSIter	diter;

  public:
    IA_OtherDIVIter(const IA_BaseDI<T> *);
    IA_OtherDIVIter(const IA_OtherDIVIter &);

    IA_BaseDIVIter<T> * clone_self() { return new IA_OtherDIVIter<T>(*this);}
    int next(T&);

    void reset() { diter.reset(); }
};

//
//

template <class T>
class IA_OtherDIPIter: public IA_BaseDIPIter<T> {
  protected:
    // iterator over the domain
    IA_IPSIter	diter;

  public:
    IA_OtherDIPIter(const IA_BaseDI<T> *);
    IA_OtherDIPIter(const IA_OtherDIPIter &);

    IA_BaseDIPIter<T> * clone_self() { return new IA_OtherDIPIter<T>(*this);}
    int next(IA_IntPoint&, T&);

    void reset() { diter.reset(); }
};

#endif
