// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char OtherDIIter_rcsid[] = "$Id: OtherDIIter.c,v 1.3 93/05/27 11:28:29 thoth Exp $";

//
// $Log:	OtherDIIter.c,v $
// Revision 1.3  93/05/27  11:28:29  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/17  18:45:09  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.1  93/03/10  13:00:03  thoth
// Initial revision
// 

#include "OtherDIIter.h"
#include "BaseDI.h"

template <class T>
IA_OtherDIVIter<T>::IA_OtherDIVIter(const IA_BaseDI<T>* img)
     :IA_BaseDIVIter<T>(img), diter(img->domain()) { }


template <class T>
IA_OtherDIVIter<T>::IA_OtherDIVIter(const IA_OtherDIVIter<T>& iter)
     :IA_BaseDIVIter<T>(iter.domain), diter(iter.diter) { }

template <class T>
int IA_OtherDIVIter<T>::next(T &v)
{
  IA_IntPoint	ip;
  if (!diter(ip))
    return 0;
  v = (*domain)(ip);
  return 1;
}

//
//


template <class T>
IA_OtherDIPIter<T>::IA_OtherDIPIter(const IA_BaseDI<T>* img)
     :IA_BaseDIPIter<T>(img), diter(img->domain()) { }


template <class T>
IA_OtherDIPIter<T>::IA_OtherDIPIter(const IA_OtherDIPIter<T>& iter)
     :IA_BaseDIPIter<T>(iter.domain), diter(iter.diter) { }

template <class T>
int IA_OtherDIPIter<T>::next(IA_IntPoint &ip, T &v)
{
  if (!diter(ip))
    return 0;
  v = (*domain)(ip);
  return 1;
}
