// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	OtherDI.h,v $
// Revision 1.3  93/05/27  11:22:32  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:20:29  thoth
// *** empty log message ***
// 
// Revision 1.1  93/03/10  12:58:14  thoth
// Initial revision
// 

#ifndef OtherDI_h_
#define OtherDI_h_

#include "BaseDI.h"

// This class is designed for a user to derive from.

// The user must provide an operator() that maps a point
// from the image\'s domain onto the value at that point.
// The user must also provide a clone_self method which
// is needed by the container class.

template <class T>
class IA_OtherDI: public IA_BaseDI<T> {
 public:
    static char dummy;
 public:
    IA_OtherDI(IA_IntPointSet ps_) :IA_BaseDI<T>(ps_) {}

    // most user-defined images will be non-extensive
    int extensivep() const { return 0; }

    static IA_DiscreteImageType s_type() { return &dummy; }

    IA_DiscreteImageType type() const { return &dummy; }

    ostream &print_this(ostream&) const;

    // Return a pointer to a copy of yourself on the heap.
    // If you do this wrong, images implemented using the
    // derived class will NOT work.
    virtual IA_OtherDI<T>* clone_self() const = 0;

    ////////////////////////////////////////////////////////////////
    // derived class MUST provide:
    // T operator()(const IA_IntPoint&) const;
    // IA_OtherDI<T>* clone_self() const;

    // recommended:
    // ostream &print_this(ostream&) const;

    // perhaps (if you can do them faster...):
    // IA_ValueSet<T> range() const;
    // IA_BaseDI<T>* clone_self_extensively() const;

    // and if you want to be extensive:
    // T &operator[](const IA_IntPoint&);
    // int extensivep() const { return 1; }
};

#endif
