// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	LazyDI.h,v $
// Revision 1.3  93/05/27  11:22:27  thoth
// Copyright Notices
// 
// Revision 1.2  93/01/19  14:56:36  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/10/05  11:50:57  jnw
// Initial revision
// 

#ifndef LazyDI_h_
#define LazyDI_h_

#include "ia.h"
#include "BaseDI.h"

template <class T>
class IA_LazyBinaryDI: public IA_BaseDI<T>{
protected:
    IA_DiscreteImage<T> left_op, right_op;
public:

    IA_LazyBinaryDI( const IA_DiscreteImage<T> &l,
		     const IA_DiscreteImage<T> &r)
    :left_op(l), right_op(r), IA_BaseDI<T>(l.domain()) {
	if (l.domain() != r.domain()) {
	    ia_throw(IA::PSET_MISMATCH, __FILE__, __LINE__);
	}
    }

    int extensivep() const { return 0; }

    virtual ~IA_LazyBinaryDI() {}

    // T operator ()(const IA_IntPoint& p) is still virtual

    // IA_DiscreteImageType type() is still virtual

    // int equal(IA_BaseDI<T>*) is still virtual

    // IA_BaseDI* clone_self_extensively() is still virtual

    // ostream& print_this(ostream&) is still virtual
};

template <class T>
class IA_LazyUnaryDI: public IA_BaseDI<T>{
protected:
    IA_DiscreteImage<T> op;
public:

    IA_LazyUnaryDI( const IA_DiscreteImage<T> &arg)
    :op(arg), IA_BaseDI<T>(arg.domain()) {}

    int extensivep() const { return 0; }

    virtual ~IA_LazyUnaryDI() {}

    // T operator ()(IntPoint& p) is still virtual

    // DiscreteImageType type() is still virtual

    // int equal(BaseDI<T>*) is still virtual

    // BaseDI* clone_self_extensively() is still virtual

    // ostream& print_this(ostream&) is still virtual
};




#endif
