// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	IntDiscreteImage.h,v $
// Revision 1.7  93/06/10  17:24:22  thoth
// 
// 
// Revision 1.6  93/05/27  11:22:24  thoth
// Copyright Notices
// 
// Revision 1.5  93/05/26  17:02:27  thoth
// write_PGM convenience friends.
// 
// Revision 1.4  93/04/08  13:17:02  thoth
// write_PGM will now compute maxval if not supplied.
// read/write_PGM now accept character strings as well
// as ostream&s and treat them as filenames.
// 
// Revision 1.3  93/03/10  13:36:18  thoth
// Provide some simple inline definitions that we don't use perl for.
// 
// Revision 1.2  93/02/23  14:31:04  thoth
// FunctionRefDIs are supported again.
// OtherDIs are supported.
// We have a clue for operator<<.
// operations +-*/ are supported for image-image.
// 
// Revision 1.1  93/02/20  12:18:44  thoth
// Initial revision
// 
// 

#ifndef IntDI_h_
#define IntDI_h_

#include <sys/types.h>
#include "DiscreteImage.h"

class IA_IntDiscreteImage: public IA_DiscreteImage<int>
{
  public:
    IA_IntDiscreteImage():IA_DiscreteImage<int>() {}

    IA_IntDiscreteImage(const IA_IntDiscreteImage& im)
    :IA_DiscreteImage<int>(im) {}

    IA_IntDiscreteImage(IA_IntPointSet ps, int value)
    :IA_DiscreteImage<int>(ps,value) {}

    IA_IntDiscreteImage(IA_IntPointSet ps, int *vp, unsigned sz,
			int giveaway=0)
    :IA_DiscreteImage<int>(ps, vp, sz, giveaway) {}

    IA_IntDiscreteImage(const IA_OtherDI<int> &img)
    :IA_DiscreteImage<int>(img) {}

    IA_IntDiscreteImage(IA_IntPointSet ps, int (*f)(const IA_IntPoint&))
    :IA_DiscreteImage<int>(ps,f) {}

    IA_IntDiscreteImage( const IA_DiscreteImage<int> &d)
    :IA_DiscreteImage<int>(d) {}

    virtual ~IA_IntDiscreteImage(){ }

#include	"IntImageOps.h"

    static IA_IntDiscreteImage read_PGM(istream &);
    static IA_IntDiscreteImage read_PGM(const char *fname);

    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;
};

inline int operator!=(const IA_IntDiscreteImage &lhs,
	       const IA_IntDiscreteImage &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_IntDiscreteImage &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_IntDiscreteImage &rhs) {
    return ! (rhs == lhs);
}

//
//

inline ostream& write_PGM(const IA_IntDiscreteImage &im, ostream &o, unsigned max) {
    return im.write_PGM(o, max);
}

inline ostream& write_PGM(const IA_IntDiscreteImage &im, ostream &o) {
    return im.write_PGM(o);
}

inline void write_PGM(const IA_IntDiscreteImage &im, const char *fname) {
    im.write_PGM(fname);
}

inline void write_PGM(const IA_IntDiscreteImage &im,
		      const char *fname, unsigned max) {
    im.write_PGM(fname, max);
}

//
//

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_DiscreteImage<int>&);


#endif
