// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char IntDI_rcsid[] = "$Id: IntDiscreteImage.c,v 1.9 93/05/27 11:36:28 thoth Exp $";

//
// $Log:	IntDiscreteImage.c,v $
// Revision 1.9  93/05/27  11:36:28  thoth
// Copyright Notices
// 
// Revision 1.8  93/05/26  17:02:11  thoth
// instantiate IAAIO.
// 
// Revision 1.7  93/05/18  21:40:49  thoth
// *** empty log message ***
// 
// Revision 1.6  93/04/29  11:20:40  thoth
// non-boxy images now output correctly.
// 
// Revision 1.5  93/04/17  18:48:02  thoth
// use IA_IntPoint instead of IntPoint
// 
// Revision 1.4  93/04/08  13:15:13  thoth
// write_PGM will now compute maxval if not supplied.
// read/write_PGM now accept character strings as well
// as ostream&s and treat them as filenames.
// const_reduce special cases now available.
// 
// Revision 1.3  93/03/10  13:35:32  thoth
// intimage-intimage operations are now generated by a perl script.
// We must still provide some inline functions to help it out though.
// 
// Revision 1.2  93/02/23  14:25:12  thoth
// force an instantiation of OtherDI.
// FunctionRefDIs are supported again.
// 
// Revision 1.1  93/02/20  12:17:42  thoth
// Initial revision
// 
// 

#include	"IntDiscreteImage.h"
#include	"VectorDI.h"
#include	"ConstDI.h"
#include	"OtherDI.h"
#include	"ErrorDI.h"
#include	"DIVIter.h"
#include	"DIPIter.h"
#include	"IPSIter.h"

#include	<math.h>
#include	<fstream.h>

//
//
//

IA_IntDiscreteImage IA_IntDiscreteImage::read_PGM(istream &i)
{
    int	width, height,maxval;
    if (i.get()=='P' && i.get()=='5' && i>>ws>>width>>height>>maxval) {
	const unsigned	size=width*height;
	unsigned char	*tmp = new unsigned char[size];
	{
	    int	ch = i.get();
	    if (ch!='\n')
		i.putback(ch);
	}
	if (!i.read(tmp, size))
	    return IA_IntDiscreteImage();
	int	*data = new int[size];
	for (unsigned i=0; i<size; i++)
	    data[i] = tmp[i];
	delete[] tmp;
	return     IA_IntDiscreteImage (IA_IntPointSet(IA_IntPoint(0,0), IA_IntPoint(height-1,width-1)),
					data, size, 1);
    } else {
	return IA_IntDiscreteImage();
    }
}

IA_IntDiscreteImage IA_IntDiscreteImage::read_PGM(const char *fname)
{
    ifstream	in(fname);
    return read_PGM(in);
}

ostream &IA_IntDiscreteImage::write_PGM(ostream &o, unsigned maxval) const
{
    IA_IntPointSet boxydomain(domain().inf(),domain().sup());
    IA_IntPoint	width(domain().sup()-domain().inf()+1);
    o<<"P5\n"<<width[1] << " " << width[0] << " " << maxval << "\n";
    IA_IPSIter	iter(boxydomain);
    IA_IntPoint	ip;

    while (iter(ip)) {
	o.put((char) ( domain().contains(ip)?(*this)(ip):0));
    }
    return o;
}

ostream &IA_IntDiscreteImage::write_PGM(ostream &o) const
{
    return write_PGM(o,max(*this));
}

void IA_IntDiscreteImage::write_PGM(const char *fname, unsigned maxval) const
{
    ofstream	out(fname);
    write_PGM(out, maxval);
}

void IA_IntDiscreteImage::write_PGM(const char *fname) const
{
    ofstream	out(fname);
    write_PGM(out, max(*this));
}

//
// below are included the implementations of every image-image
// and image-scalar operation we could think of for integer images.
//

template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}

inline int isqrt(int v)
{
    return (int) (sqrt((double) v));
}

template <class T>
inline T sqr(T v)
{
    return v*v;
}

#define  const_reduce_int_int_reduce_plus
inline int const_reduce_reduce_plus(unsigned sz, int arg)
{
    return sz * arg;
}

#define const_reduce_int_int_max
inline int const_reduce_max(unsigned, int arg)
{
    return arg;
}

#define const_reduce_int_int_min
inline int const_reduce_min(unsigned, int arg)
{
    return arg;
}

#include "IntImageOps.c"

//
//
//

class blah : public IA_OtherDI<int> {
  public:
    blah() 
    :IA_OtherDI<int>(IA_IntPointSet()) {}
    ostream &print_this(ostream &o) const { return o;}
    int operator()(const IA_IntPoint &) const { return 0; }
    IA_OtherDI<int>* clone_self() const { return 0; }
};
static void dummy001()
{
    IA_IntPoint		ip;
    IA_IntPointSet	ps;
    IA_IntDiscreteImage	i1;
    IA_IntDiscreteImage
	i2(i1),
	i3(ps,0),
	i4(ps, (int*)0, 0, 1),
	i5(ps, (int*)0, 0),
	i6(blah()),
	i7(ps, (int(*)(const IA_IntPoint&))0),
	i10(IA_DiscreteImage<int>());
    int	sc;

    i1 = i1.restrict(i2.range());
    i1 = i1.xlated(ip);
    (IA_DiscreteImage<int>&)i1 = 2;
    (void)i1.type();
    i1[ip] = i1(ip);
    i1 = i1.restrict(i2.domain());
    (void)i1.extend(i2);
    (void)i1.reduce((int (*)(const int&,const int&)) 0, 0);
    (void)i1.reduce((int (*)( int, int)) 0, 0);
    cout << (IA_DiscreteImage<int>&)i1;

    IA_IntDiscreteImage::read_IAA("");
    IA_IntDiscreteImage::read_IAA("","");

    i1.write_IAA("");
    i1.write_IAA("","");

    IA_DIVIter<int>	iter1(i1), iter2;
    IA_DIPIter<int>	iter3(i2), iter4;
    iter1 = iter2;
    iter3 = iter4;
#if 1
    iter1.reset();
    iter1(sc);
    iter3.reset();
    iter3(ip, sc);
#endif
    compose(i1, (IA_IntPoint(*)(const IA_IntPoint&))0);
    compose(i1, *(IA_PPCompClosure<IA_IntPoint, IA_IntPoint>*)0);
    compose((int(*)(int))0, i1);
    compose((u_char(*)(int))0, i1, (u_char*)0);

    IA_ValueSet<int>	vs(i1.range());
    // I shouldn\'t have to do the following two lines
    // vs.value_type_compare(0,0);
}
