// Emacs: -*- C++ -*-

// $Log:	FunctionRefDIPIter.h,v $
// Revision 1.2  93/01/19  14:56:25  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/14  09:36:25  jnw
// Initial revision
// 

#ifndef FunctionRefDIPIter_h_
#define FunctionRefDIPIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "FunctionRefDI.h"

template <class T>
class IA_FunctionRefDIPIter: public IA_BaseDIIter<T> {
protected:
    // curr stores the current point position of the iterator.
    IA_IntPoint curr;

    // bdip points at the base image over which we're iterating.
    IA_FunctionRefDI<T> *bdip;

    // psiter is an iterator over bdip's PointSet.
    IA_IPSIter psiter;

    // more is true if there are any points remaining to be returned
    // by next().
    int more;

public:

    IA_FunctionRefDIPIter(const IA_DiscreteImage<T> &, IA_FunctionRefDI<T> *);
    IA_FunctionRefDIPIter(const IA_FunctionRefDIPIter&);

    ~IA_FunctionRefDIPIter() {}

    IA_BaseDIIter<T> * clone_self() {
	return new IA_FunctionRefDIPIter(*this);
    }

    int next(IntPoint&, T&);

    void reset() { psiter.reset(); this->more=psiter(curr);}

    IA_DiscreteImage<T> domain_() const { return this->domain; }
};

#endif
