// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	FunctionRefDI.h,v $
// Revision 1.7  93/05/27  11:22:20  thoth
// Copyright Notices
// 
// Revision 1.6  93/04/08  13:12:21  thoth
// new restriction method.
// 
// Revision 1.5  93/02/23  14:24:16  thoth
// we don't need other iterators.
// We can use the default clone_self_extensively.
// 
// Revision 1.4  93/02/08  13:02:47  thoth
// static dummy member belongs in the .c file.
// 
// Revision 1.3  93/01/19  14:56:22  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/14  09:37:18  jnw
// Modified to support new iterator classes
// 
// Revision 1.1  92/10/05  11:44:50  jnw
// Initial revision
// 

#ifndef FunctionRefDI_h_
#define FunctionRefDI_h_

#include "ia.h"
#include "BaseDI.h"

template <class T>
class IA_FunctionRefDI: public IA_BaseDI<T>{
private:
    T (*func)(const IA_IntPoint&);

    static char dummy;
public:
    IA_FunctionRefDI(const IA_IntPointSet& p, T (*fp)(const IA_IntPoint&))
    : IA_BaseDI<T>(p){
	this->func = fp;
    }

    int extensivep() const { return 0; }

    T operator ()(const IA_IntPoint&) const;

    static IA_DiscreteImageType s_type() { return &dummy; }
    IA_DiscreteImageType type() const { return &dummy; }

    //IA_BaseDI<T>* clone_self_extensively() const;

    IA_BaseDI<T>* restricted_to(const IA_IntPointSet &ips) const {
	return new IA_FunctionRefDI(this->domain() & ips, this->func);
    }


    ostream& print_this(ostream&) const;
};

#endif
