// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char FunctionRefDIrcsid[] = "$Id: FunctionRefDI.c,v 1.5 93/05/27 11:28:25 thoth Exp $";

// $Log:	FunctionRefDI.c,v $
// Revision 1.5  93/05/27  11:28:25  thoth
// Copyright Notices
// 
// Revision 1.4  93/02/23  14:18:58  thoth
// equal does not belong in here.
// 
// Revision 1.3  93/02/08  13:02:16  thoth
// static dummy member belongs in the .c file.
// equal method no longer loops infinitely.
// 
// Revision 1.2  93/01/19  14:56:20  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/10/05  11:44:46  jnw
// Initial revision
// 

#include "FunctionRefDI.h"
#include "VectorDI.h"
#include "IPSIter.h"

template <class T>
char IA_FunctionRefDI<T>::dummy = 0;

template <class T>
T IA_FunctionRefDI<T>::operator ()(const IA_IntPoint& p) const {
    //if (!this->ps.contains(p))
    //ia_throw( IA::IMAGE_DOMAIN_ERROR, __FILE__, __LINE__);
    return (*(this->func))(p);
}

#if 0
template <class T>
IA_BaseDI<T>* IA_FunctionRefDI<T>::clone_self_extensively() const
{
    if (this->ps.extensivep()) {
	T *vec;
	
	vec = new T[this->ps.card()];

	IA_IPSIter iter(this->ps);
	IA_IntPoint p;
	int i=0;
	while(iter(p)) {
	    vec[i++] = (*this->func)(p);
	}
	return new IA_VectorDI<T>(vec, this->ps, this->ps.card(),1);
	
    } else {
	ia_throw( IA::PSET_REQUIRE_EXTENSIVE
		  , __FILE__, __LINE__);
    }
    
}
#endif

template <class T>
ostream& IA_FunctionRefDI<T>::print_this(ostream& o) const
{
    o << "FunctionIntDI -";
    if (this->ps.extensivep()){
	IA_IPSIter iter(this->ps);
	IA_IntPoint p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (*this->func)(p) << ") ";
	}
    } else {
	o << ", Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}
