// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	FunctionDT.h,v $
// Revision 1.2  93/05/27  11:22:14  thoth
// Copyright Notices
// 
// Revision 1.1  93/04/17  19:00:38  thoth
// Initial revision
// 


#ifndef FunctionDT_h_
#define FunctionDT_h_

#include "ia.h"
#include "BaseDT.h"

template <class T>
class IA_FunctionDT: public IA_BaseDT<T>{
private:
    T (*func)(const IA_IntPoint&);

    static char dummy;
public:
    IA_FunctionDT(const IA_IntPointSet& p, T (*fp)(const IA_IntPoint&))
    : IA_BaseDT<T>(p){
	this->func = fp;
    }

    T operator ()(const IA_IntPoint&) const;

    static IA_DiscreteImageType s_type() { return &dummy; }
    IA_DiscreteImageType type() const { return &dummy; }

    ostream& print_this(ostream&) const;
};

#endif
