// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char FunctionDT_rcsid[] = "$Id: FunctionDT.c,v 1.2 93/05/27 11:28:23 thoth Exp $";

//
// $Log:	FunctionDT.c,v $
// Revision 1.2  93/05/27  11:28:23  thoth
// Copyright Notices
// 
// Revision 1.1  93/04/17  19:00:27  thoth
// Initial revision
// 

#include "FunctionDT.h"
#include "IPSIter.h"

template <class I>
char IA_FunctionDT<I>::dummy = 0;

template <class I>
I IA_FunctionDT<I>::operator ()(const IA_IntPoint& p) const {
    //if (!this->ps.contains(p))
    //ia_throw( IA::IMAGE_DOMAIN_ERROR, __FILE__, __LINE__);
    return (*(this->func))(p);
}

template <class I>
ostream& IA_FunctionDT<I>::print_this(ostream& o) const
{
    o << "FunctionDT -";
    if (this->ps.extensivep()){
	IA_IPSIter iter(this->ps);
	IA_IntPoint p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (*this->func)(p) << ") ";
	}
    } else {
	o << ", Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}
