// Emacs: -*- C++ -*-

// $Log:	FunctionDIVIter.h,v $
// Revision 1.2  93/01/19  14:56:17  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/14  09:36:34  jnw
// Initial revision
// 

#ifndef FunctionDIVIter_h_
#define FunctionDIVIter_h_

#include <stdlib.h>
#include "IPSIter.h"
#include "BaseDIIter.h"
#include "FunctionDI.h"

template <class T>
class IA_FunctionDIVIter: public IA_BaseDIIter<T> {
protected:
    // curr stores the current point position of the iterator.
    IA_IntPoint curr;

    // bdip points at the base image over which we're iterating.
    IA_FunctionDI<T> *bdip;

    // psiter is an iterator over bdip's PointSet.
    IA_IPSIter psiter;

    // more is true if there are any points remaining to be returned
    // by next().
    int more;

public:

    IA_FunctionDIVIter(const IA_DiscreteImage<T> &, IA_FunctionDI<T> *);
    IA_FunctionDIVIter(const IA_FunctionDIVIter&);

    ~IA_FunctionDIVIter() {}

    IA_BaseDIIter<T> * clone_self() { return new IA_FunctionDIVIter(*this); }

    int next(T&);

    void reset() { psiter.reset(); this->more=psiter(curr);}

    IA_DiscreteImage<T> domain_() const { return this->domain; }
};

#endif
