// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.

//  Integer operations for the Int Discrete Image
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// conversion I(float) I(u_char)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	conversion.templ,v $
// Revision 1.2  93/05/27  11:49:02  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:18:33  thoth
// Initial revision
// 

IA_FloatDiscreteImage::
	IA_FloatDiscreteImage(const IA_DiscreteImage<u_char> &arg)
{
    IA_IntPointSet	domain = arg.domain();
    // if the domain isn\'t extensive, we need a lazy conversion image...
    const unsigned	sz = domain.card();
    float * const	vec = new float[sz];
    {
	float	*scan = vec;
	IA_DIVIter<u_char>	iter(arg);
	u_char	temp;
	while (iter(temp)) {
	    *(scan++) = temp;
	}
    }
    set_and_reference_image(new IA_VectorDI<float>(domain, vec, sz, 1));
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// conversion I(float) I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	conversion.templ,v $
// Revision 1.2  93/05/27  11:49:02  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:18:33  thoth
// Initial revision
// 

IA_FloatDiscreteImage::
	IA_FloatDiscreteImage(const IA_DiscreteImage<int> &arg)
{
    IA_IntPointSet	domain = arg.domain();
    // if the domain isn\'t extensive, we need a lazy conversion image...
    const unsigned	sz = domain.card();
    float * const	vec = new float[sz];
    {
	float	*scan = vec;
	IA_DIVIter<int>	iter(arg);
	int	temp;
	while (iter(temp)) {
	    *(scan++) = temp;
	}
    }
    set_and_reference_image(new IA_VectorDI<float>(domain, vec, sz, 1));
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise to_int subop=int I(int) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_int_float_to_int
#define vec_scalar_int_float_to_int
static IA_DiscreteImage<int>
vec_uo_to_int(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = int(*(ls++));
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_to_int

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_to_int
#define iter_scalar_int_float_to_int
static IA_DiscreteImage<int>
iter_uo_to_int(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = int(ltmp);
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_to_int

IA_DiscreteImage<int>
to_int ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_to_int((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (arg.domain(), int(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_to_int(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise to_uchar subop=u_char I(u_char) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_u_char_float_to_uchar
#define vec_scalar_u_char_float_to_uchar
static IA_DiscreteImage<u_char>
vec_uo_to_uchar(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = u_char(*(ls++));
	}
    }
    return IA_DiscreteImage<u_char>(domain, vec, sz, 1);
}
#endif // vec_scalar_u_char_float_to_uchar

// scalar-scalar operation is trivial

#ifndef iter_scalar_u_char_float_to_uchar
#define iter_scalar_u_char_float_to_uchar
static IA_DiscreteImage<u_char>
iter_uo_to_uchar(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    u_char *const vec = new u_char[sz];

    {
	u_char *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = u_char(ltmp);
	}
    }
    return IA_DiscreteImage<u_char>(domain, vec, sz, 1);
}
#endif // iter_scalar_u_char_float_to_uchar

IA_DiscreteImage<u_char>
to_uchar ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_to_uchar((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<u_char> (arg.domain(), u_char(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_to_uchar(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPpl(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPpl
#define vec_scalar_float_float_float_operatorIAOPpl
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPpl

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPpl(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) + (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPpl
#define scalar_iter_float_float_float_operatorIAOPpl
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPpl(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) + (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPpl

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPpl(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) + (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator+ ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPpl((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) + (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_operatorIAOPpl((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_operatorIAOPpl(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPpl(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator+ I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPpl
#define vec_scalar_float_float_float_operatorIAOPpl
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPpl(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) + (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPpl

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPpl
#define scalar_iter_float_float_float_operatorIAOPpl
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPpl(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) + (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPpl

IA_FloatDiscreteImage
operator+ ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPpl((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) + (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPpl(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(float) I(float)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator+= I(float) float
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPmn(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPmn
#define vec_scalar_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPmn

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPmn(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) - (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_float_float_float_operatorIAOPmn
#define scalar_vec_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
scalar_vec_bo_operatorIAOPmn(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_float_float_float_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPmn
#define scalar_iter_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPmn(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPmn

static IA_FloatDiscreteImage
iter_vec_bo_operatorIAOPmn(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_float_float_float_operatorIAOPmn
#define iter_scalar_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_float_operatorIAOPmn

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPmn(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) - (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator- ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPmn((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmn((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPmn(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) - (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmn(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPmn(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPmn(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPmn
#define vec_scalar_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPmn(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) - (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_float_operatorIAOPmn
#define iter_scalar_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
iter_scalar_bo_operatorIAOPmn(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) - (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_float_operatorIAOPmn

IA_FloatDiscreteImage
operator- ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPmn((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) - (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator- float I(float) I(float)
//
#ifndef scalar_vec_float_float_float_operatorIAOPmn
#define scalar_vec_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
scalar_vec_bo_operatorIAOPmn(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) - (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_float_float_float_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPmn
#define scalar_iter_float_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPmn(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) - (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPmn

IA_FloatDiscreteImage
operator- (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPmn(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (rhs.domain(), (lhs) - (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPmn(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator- I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_float_float_operatorIAOPmn
#define vec_scalar_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
vec_uo_operatorIAOPmn(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = -(*(ls++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_operatorIAOPmn

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_operatorIAOPmn
#define iter_scalar_float_float_operatorIAOPmn
static IA_FloatDiscreteImage
iter_uo_operatorIAOPmn(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = -(ltmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_operatorIAOPmn

IA_FloatDiscreteImage
operator- ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_operatorIAOPmn((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (arg.domain(), -(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPmn(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(float) I(float)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator-= I(float) float
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPmu(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPmu
#define vec_scalar_float_float_float_operatorIAOPmu
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPmu

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPmu(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) * (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPmu
#define scalar_iter_float_float_float_operatorIAOPmu
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPmu(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) * (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPmu

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPmu(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) * (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator* ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPmu((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) * (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_operatorIAOPmu((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_operatorIAOPmu(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPmu(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator* I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPmu
#define vec_scalar_float_float_float_operatorIAOPmu
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPmu(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) * (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPmu

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPmu
#define scalar_iter_float_float_float_operatorIAOPmu
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPmu(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) * (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPmu

IA_FloatDiscreteImage
operator* ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPmu((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) * (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPmu(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(float) I(float)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator*= I(float) float
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPdv(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPdv
#define vec_scalar_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPdv

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPdv(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) / (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef scalar_vec_float_float_float_operatorIAOPdv
#define scalar_vec_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
scalar_vec_bo_operatorIAOPdv(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_float_float_float_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPdv
#define scalar_iter_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPdv(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPdv

static IA_FloatDiscreteImage
iter_vec_bo_operatorIAOPdv(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef iter_scalar_float_float_float_operatorIAOPdv
#define iter_scalar_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_float_operatorIAOPdv

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPdv(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) / (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator/ ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPdv((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPdv((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPdv(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) / (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPdv(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPdv(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPdv(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPdv
#define vec_scalar_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPdv(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) / (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_float_operatorIAOPdv
#define iter_scalar_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
iter_scalar_bo_operatorIAOPdv(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) / (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_float_operatorIAOPdv

IA_FloatDiscreteImage
operator/ ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPdv((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) / (rhs));
    } else {
	return iter_scalar_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative operator/ float I(float) I(float)
//
#ifndef scalar_vec_float_float_float_operatorIAOPdv
#define scalar_vec_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
scalar_vec_bo_operatorIAOPdv(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) / (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_vec_float_float_float_operatorIAOPdv

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPdv
#define scalar_iter_float_float_float_operatorIAOPdv
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPdv(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) / (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPdv

IA_FloatDiscreteImage
operator/ (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPdv(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (rhs.domain(), (lhs) / (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_operatorIAOPdv(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(float) I(float)
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// pointwise operator/= I(float) float
//
// There are none (it's inline)

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPla(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPla
#define vec_scalar_float_float_float_operatorIAOPla
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPla

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPla(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) && (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPla
#define scalar_iter_float_float_float_operatorIAOPla
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPla(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) && (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPla

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPla(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) && (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator&& ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPla((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPla((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) && (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_operatorIAOPla((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_operatorIAOPla(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPla(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator&& I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPla
#define vec_scalar_float_float_float_operatorIAOPla
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPla(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) && (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPla

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPla
#define scalar_iter_float_float_float_operatorIAOPla
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPla(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) && (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPla

IA_FloatDiscreteImage
operator&& ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPla((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) && (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPla(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_operatorIAOPlo(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (*(rs++)) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_operatorIAOPlo
#define vec_scalar_float_float_float_operatorIAOPlo
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPlo

static IA_FloatDiscreteImage
vec_iter_bo_operatorIAOPlo(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) || (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPlo
#define scalar_iter_float_float_float_operatorIAOPlo
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPlo(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) || (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPlo

static IA_FloatDiscreteImage
iter_iter_bo_operatorIAOPlo(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) || (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
operator|| ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPlo((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) || (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_operatorIAOPlo((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_operatorIAOPlo(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPlo(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative operator|| I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_operatorIAOPlo
#define vec_scalar_float_float_float_operatorIAOPlo
static IA_FloatDiscreteImage
vec_scalar_bo_operatorIAOPlo(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) || (rhs) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_operatorIAOPlo

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_operatorIAOPlo
#define scalar_iter_float_float_float_operatorIAOPlo
static IA_FloatDiscreteImage
scalar_iter_bo_operatorIAOPlo(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) || (rtmp) );
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_operatorIAOPlo

IA_FloatDiscreteImage
operator|| ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPlo((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) || (rhs));
    } else {
	return scalar_iter_bo_operatorIAOPlo(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise operator! I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_float_float_operatorIAOPno
#define vec_scalar_float_float_operatorIAOPno
static IA_FloatDiscreteImage
vec_uo_operatorIAOPno(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = !(*(ls++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_operatorIAOPno

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_operatorIAOPno
#define iter_scalar_float_float_operatorIAOPno
static IA_FloatDiscreteImage
iter_uo_operatorIAOPno(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = !(ltmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_operatorIAOPno

IA_FloatDiscreteImage
operator! ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_operatorIAOPno((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (arg.domain(), !(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_operatorIAOPno(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(float) I(float) int
//
int vec_vec_bo_operatorIAOPlt(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_operatorIAOPlt
#define vec_scalar_int_float_float_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPlt

int vec_iter_bo_operatorIAOPlt(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_float_float_operatorIAOPlt
#define scalar_vec_int_float_float_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPlt
#define scalar_iter_int_float_float_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPlt

int iter_vec_bo_operatorIAOPlt(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_float_float_operatorIAOPlt
#define iter_scalar_int_float_float_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPlt

int iter_iter_bo_operatorIAOPlt(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator< ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPlt((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPlt((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPlt(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) < (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPlt(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPlt(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPlt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< I(float) float int
//
#ifndef vec_scalar_int_float_float_operatorIAOPlt
#define vec_scalar_int_float_float_operatorIAOPlt
int vec_scalar_bo_operatorIAOPlt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_operatorIAOPlt
#define iter_scalar_int_float_float_operatorIAOPlt
int iter_scalar_bo_operatorIAOPlt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) < (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPlt

int operator< ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPlt((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) < (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator< float I(float) int
//
#ifndef scalar_vec_int_float_float_operatorIAOPlt
#define scalar_vec_int_float_float_operatorIAOPlt
int scalar_vec_bo_operatorIAOPlt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) < (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPlt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPlt
#define scalar_iter_int_float_float_operatorIAOPlt
int scalar_iter_bo_operatorIAOPlt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) < (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPlt

int operator< (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPlt(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return (lhs) < (((IA_ConstDI<float> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPlt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(float) I(float) int
//
int vec_vec_bo_operatorIAOPle(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_operatorIAOPle
#define vec_scalar_int_float_float_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPle

int vec_iter_bo_operatorIAOPle(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_float_float_operatorIAOPle
#define scalar_vec_int_float_float_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPle
#define scalar_iter_int_float_float_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPle

int iter_vec_bo_operatorIAOPle(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_float_float_operatorIAOPle
#define iter_scalar_int_float_float_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPle

int iter_iter_bo_operatorIAOPle(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator<= ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPle((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPle((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPle((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPle(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) <= (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPle(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPle(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPle(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= I(float) float int
//
#ifndef vec_scalar_int_float_float_operatorIAOPle
#define vec_scalar_int_float_float_operatorIAOPle
int vec_scalar_bo_operatorIAOPle(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_operatorIAOPle
#define iter_scalar_int_float_float_operatorIAOPle
int iter_scalar_bo_operatorIAOPle(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) <= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPle

int operator<= ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPle((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) <= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator<= float I(float) int
//
#ifndef scalar_vec_int_float_float_operatorIAOPle
#define scalar_vec_int_float_float_operatorIAOPle
int scalar_vec_bo_operatorIAOPle(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) <= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPle

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPle
#define scalar_iter_int_float_float_operatorIAOPle
int scalar_iter_bo_operatorIAOPle(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) <= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPle

int operator<= (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPle(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return (lhs) <= (((IA_ConstDI<float> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPle(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(float) I(float) int
//
int vec_vec_bo_operatorIAOPeq(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_operatorIAOPeq
#define vec_scalar_int_float_float_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPeq

int vec_iter_bo_operatorIAOPeq(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPeq
#define scalar_iter_int_float_float_operatorIAOPeq
int scalar_iter_bo_operatorIAOPeq(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPeq

int iter_iter_bo_operatorIAOPeq(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator== ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPeq((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) == (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_operatorIAOPeq((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_operatorIAOPeq(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_operatorIAOPeq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative operator== I(float) float int
//
#ifndef vec_scalar_int_float_float_operatorIAOPeq
#define vec_scalar_int_float_float_operatorIAOPeq
int vec_scalar_bo_operatorIAOPeq(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) == (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPeq

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPeq
#define scalar_iter_int_float_float_operatorIAOPeq
int scalar_iter_bo_operatorIAOPeq(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) == (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPeq

int operator== ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPeq((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) == (rhs);
    } else {
	return scalar_iter_bo_operatorIAOPeq(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(float) I(float) int
//
int vec_vec_bo_strict_ne(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_strict_ne
#define vec_scalar_int_float_float_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_strict_ne

int vec_iter_bo_strict_ne(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_strict_ne
#define scalar_iter_int_float_float_strict_ne
int scalar_iter_bo_strict_ne(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_strict_ne

int iter_iter_bo_strict_ne(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int strict_ne ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_strict_ne((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_strict_ne((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_strict_ne((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) != (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_strict_ne((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_strict_ne(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_strict_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= I(float) float int
//
#ifndef vec_scalar_int_float_float_strict_ne
#define vec_scalar_int_float_float_strict_ne
int vec_scalar_bo_strict_ne(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) != (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_strict_ne

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_strict_ne
#define scalar_iter_int_float_float_strict_ne
int scalar_iter_bo_strict_ne(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) != (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_strict_ne

int strict_ne ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_strict_ne((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) != (rhs);
    } else {
	return scalar_iter_bo_strict_ne(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(float) I(float) int
//
int vec_vec_bo_operatorIAOPge(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_operatorIAOPge
#define vec_scalar_int_float_float_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPge

int vec_iter_bo_operatorIAOPge(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_float_float_operatorIAOPge
#define scalar_vec_int_float_float_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPge
#define scalar_iter_int_float_float_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPge

int iter_vec_bo_operatorIAOPge(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_float_float_operatorIAOPge
#define iter_scalar_int_float_float_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPge

int iter_iter_bo_operatorIAOPge(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator>= ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPge((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPge((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPge((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPge(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) >= (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPge(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPge(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= I(float) float int
//
#ifndef vec_scalar_int_float_float_operatorIAOPge
#define vec_scalar_int_float_float_operatorIAOPge
int vec_scalar_bo_operatorIAOPge(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_operatorIAOPge
#define iter_scalar_int_float_float_operatorIAOPge
int iter_scalar_bo_operatorIAOPge(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) >= (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPge

int operator>= ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPge((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) >= (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator>= float I(float) int
//
#ifndef scalar_vec_int_float_float_operatorIAOPge
#define scalar_vec_int_float_float_operatorIAOPge
int scalar_vec_bo_operatorIAOPge(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) >= (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPge
#define scalar_iter_int_float_float_operatorIAOPge
int scalar_iter_bo_operatorIAOPge(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) >= (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPge

int operator>= (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPge(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return (lhs) >= (((IA_ConstDI<float> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(float) I(float) int
//
int vec_vec_bo_operatorIAOPgt(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_float_float_operatorIAOPgt
#define vec_scalar_int_float_float_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPgt

int vec_iter_bo_operatorIAOPgt(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (*(ls++)) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

#ifndef scalar_vec_int_float_float_operatorIAOPgt
#define scalar_vec_int_float_float_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPgt
#define scalar_iter_int_float_float_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPgt

int iter_vec_bo_operatorIAOPgt(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}

#ifndef iter_scalar_int_float_float_operatorIAOPgt
#define iter_scalar_int_float_float_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPgt

int iter_iter_bo_operatorIAOPgt(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    if (!( (ltmp) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}

int operator> ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static int	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_operatorIAOPgt((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_operatorIAOPgt((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_operatorIAOPgt(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return (((IA_ConstDI<float> *)lhs.bdip)->value) > (((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return scalar_iter_bo_operatorIAOPgt(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_operatorIAOPgt(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_operatorIAOPgt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> I(float) float int
//
#ifndef vec_scalar_int_float_float_operatorIAOPgt
#define vec_scalar_int_float_float_operatorIAOPgt
int vec_scalar_bo_operatorIAOPgt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*(ls++)) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // vec_scalar_int_float_float_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_operatorIAOPgt
#define iter_scalar_int_float_float_operatorIAOPgt
int iter_scalar_bo_operatorIAOPgt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    if (!( (ltmp) > (rhs) ))
		return 0;
	}
    }
    return 1;
}
#endif // iter_scalar_int_float_float_operatorIAOPgt

int operator> ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_operatorIAOPgt((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return (((IA_ConstDI<float> *)lhs.bdip)->value) > (rhs);
    } else {
	return iter_scalar_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel non-commutative operator> float I(float) int
//
#ifndef scalar_vec_int_float_float_operatorIAOPgt
#define scalar_vec_int_float_float_operatorIAOPgt
int scalar_vec_bo_operatorIAOPgt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (lhs) > (*(rs++)) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_vec_int_float_float_operatorIAOPgt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_operatorIAOPgt
#define scalar_iter_int_float_float_operatorIAOPgt
int scalar_iter_bo_operatorIAOPgt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    if (!( (lhs) > (rtmp) ))
		return 0;
	}
    }
    return 1;
}
#endif // scalar_iter_int_float_float_operatorIAOPgt

int operator> (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_operatorIAOPgt(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return (lhs) > (((IA_ConstDI<float> *)rhs.bdip)->value);
    } else {
	return scalar_iter_bo_operatorIAOPgt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_lt(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_lt
#define vec_scalar_int_float_float_pwise_lt
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_lt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_lt

static IA_DiscreteImage<int>
vec_iter_bo_pwise_lt(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) < (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_float_float_pwise_lt
#define scalar_vec_int_float_float_pwise_lt
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_lt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_lt
#define scalar_iter_int_float_float_pwise_lt
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_lt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_lt

static IA_DiscreteImage<int>
iter_vec_bo_pwise_lt(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_float_float_pwise_lt
#define iter_scalar_int_float_float_pwise_lt
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_lt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_lt

static IA_DiscreteImage<int>
iter_iter_bo_pwise_lt(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) < (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_lt ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_lt((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_lt((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_lt((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_pwise_lt(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) < (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_lt(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_pwise_lt(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_pwise_lt(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_lt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_lt
#define vec_scalar_int_float_float_pwise_lt
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_lt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) < (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_lt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_pwise_lt
#define iter_scalar_int_float_float_pwise_lt
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_lt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) < (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_lt

IA_DiscreteImage<int>
pwise_lt ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_lt((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) < (rhs));
    } else {
	return iter_scalar_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_lt subop=operator< float I(float) I(int)
//
#ifndef scalar_vec_int_float_float_pwise_lt
#define scalar_vec_int_float_float_pwise_lt
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_lt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) < (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_lt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_lt
#define scalar_iter_int_float_float_pwise_lt
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_lt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) < (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_lt

IA_DiscreteImage<int>
pwise_lt (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_pwise_lt(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (rhs.domain(), (lhs) < (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_lt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_le(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_le
#define vec_scalar_int_float_float_pwise_le
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_le(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_le

static IA_DiscreteImage<int>
vec_iter_bo_pwise_le(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) <= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_float_float_pwise_le
#define scalar_vec_int_float_float_pwise_le
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_le(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_le
#define scalar_iter_int_float_float_pwise_le
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_le(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_le

static IA_DiscreteImage<int>
iter_vec_bo_pwise_le(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_float_float_pwise_le
#define iter_scalar_int_float_float_pwise_le
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_le(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_le

static IA_DiscreteImage<int>
iter_iter_bo_pwise_le(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) <= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_le ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_le((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_le((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_le((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_pwise_le(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) <= (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_le(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_pwise_le(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_pwise_le(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_le(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_le
#define vec_scalar_int_float_float_pwise_le
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_le(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) <= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_le

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_pwise_le
#define iter_scalar_int_float_float_pwise_le
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_le(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) <= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_le

IA_DiscreteImage<int>
pwise_le ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_le((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) <= (rhs));
    } else {
	return iter_scalar_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_le subop=operator<= float I(float) I(int)
//
#ifndef scalar_vec_int_float_float_pwise_le
#define scalar_vec_int_float_float_pwise_le
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_le(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) <= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_le

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_le
#define scalar_iter_int_float_float_pwise_le
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_le(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) <= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_le

IA_DiscreteImage<int>
pwise_le (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_pwise_le(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (rhs.domain(), (lhs) <= (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_le(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_eq(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_eq
#define vec_scalar_int_float_float_pwise_eq
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_eq(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_eq

static IA_DiscreteImage<int>
vec_iter_bo_pwise_eq(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) == (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_eq
#define scalar_iter_int_float_float_pwise_eq
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_eq(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) == (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_eq

static IA_DiscreteImage<int>
iter_iter_bo_pwise_eq(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) == (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_eq ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_eq((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_eq((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) == (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_pwise_eq((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_pwise_eq(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_eq(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_eq subop=operator== I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_eq
#define vec_scalar_int_float_float_pwise_eq
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_eq(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) == (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_eq

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_eq
#define scalar_iter_int_float_float_pwise_eq
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_eq(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) == (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_eq

IA_DiscreteImage<int>
pwise_eq ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_eq((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) == (rhs));
    } else {
	return scalar_iter_bo_pwise_eq(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_ne(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_ne
#define vec_scalar_int_float_float_pwise_ne
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_ne(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_ne

static IA_DiscreteImage<int>
vec_iter_bo_pwise_ne(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) != (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_ne
#define scalar_iter_int_float_float_pwise_ne
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_ne(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) != (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_ne

static IA_DiscreteImage<int>
iter_iter_bo_pwise_ne(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) != (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_ne ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_ne((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_ne((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) != (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_pwise_ne((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_pwise_ne(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_pwise_ne(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative pwise_ne subop=operator!= I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_ne
#define vec_scalar_int_float_float_pwise_ne
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_ne(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) != (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_ne

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_ne
#define scalar_iter_int_float_float_pwise_ne
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_ne(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) != (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_ne

IA_DiscreteImage<int>
pwise_ne ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_ne((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) != (rhs));
    } else {
	return scalar_iter_bo_pwise_ne(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_ge(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_ge
#define vec_scalar_int_float_float_pwise_ge
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_ge(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_ge

static IA_DiscreteImage<int>
vec_iter_bo_pwise_ge(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) >= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_float_float_pwise_ge
#define scalar_vec_int_float_float_pwise_ge
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_ge(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_ge
#define scalar_iter_int_float_float_pwise_ge
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_ge(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_ge

static IA_DiscreteImage<int>
iter_vec_bo_pwise_ge(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_float_float_pwise_ge
#define iter_scalar_int_float_float_pwise_ge
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_ge(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_ge

static IA_DiscreteImage<int>
iter_iter_bo_pwise_ge(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) >= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_ge ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_ge((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_ge((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_ge((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_pwise_ge(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) >= (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_ge(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_pwise_ge(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_pwise_ge(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_ge(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_ge
#define vec_scalar_int_float_float_pwise_ge
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_ge(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) >= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_ge

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_pwise_ge
#define iter_scalar_int_float_float_pwise_ge
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_ge(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) >= (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_ge

IA_DiscreteImage<int>
pwise_ge ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_ge((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) >= (rhs));
    } else {
	return iter_scalar_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_ge subop=operator>= float I(float) I(int)
//
#ifndef scalar_vec_int_float_float_pwise_ge
#define scalar_vec_int_float_float_pwise_ge
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_ge(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) >= (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_ge

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_ge
#define scalar_iter_int_float_float_pwise_ge
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_ge(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) >= (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_ge

IA_DiscreteImage<int>
pwise_ge (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_pwise_ge(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (rhs.domain(), (lhs) >= (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_ge(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(float) I(float) I(int)
//
static IA_DiscreteImage<int>
vec_vec_bo_pwise_gt(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef vec_scalar_int_float_float_pwise_gt
#define vec_scalar_int_float_float_pwise_gt
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_gt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_gt

static IA_DiscreteImage<int>
vec_iter_bo_pwise_gt(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (*(ls++)) > (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef scalar_vec_int_float_float_pwise_gt
#define scalar_vec_int_float_float_pwise_gt
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_gt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_gt
#define scalar_iter_int_float_float_pwise_gt
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_gt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_gt

static IA_DiscreteImage<int>
iter_vec_bo_pwise_gt(IA_FloatDiscreteImage lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

#ifndef iter_scalar_int_float_float_pwise_gt
#define iter_scalar_int_float_float_pwise_gt
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_gt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_gt

static IA_DiscreteImage<int>
iter_iter_bo_pwise_gt(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = ( (ltmp) > (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}

IA_DiscreteImage<int>
pwise_gt ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_DiscreteImage<int>	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_pwise_gt((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_pwise_gt((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_pwise_gt((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return scalar_vec_bo_pwise_gt(((IA_ConstDI<float> *)lhs.bdip)->value,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) > (((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_pwise_gt(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return iter_vec_bo_pwise_gt(lhs,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return iter_scalar_bo_pwise_gt(lhs,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return iter_iter_bo_pwise_gt(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> I(float) float I(int)
//
#ifndef vec_scalar_int_float_float_pwise_gt
#define vec_scalar_int_float_float_pwise_gt
static IA_DiscreteImage<int>
vec_scalar_bo_pwise_gt(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*(ls++)) > (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // vec_scalar_int_float_float_pwise_gt

// scalar-scalar operation is trivial

#ifndef iter_scalar_int_float_float_pwise_gt
#define iter_scalar_int_float_float_pwise_gt
static IA_DiscreteImage<int>
iter_scalar_bo_pwise_gt(IA_FloatDiscreteImage lhs,float rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = ( (ltmp) > (rhs) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // iter_scalar_int_float_float_pwise_gt

IA_DiscreteImage<int>
pwise_gt ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_pwise_gt((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (lhs.domain(), (((IA_ConstDI<float> *)lhs.bdip)->value) > (rhs));
    } else {
	return iter_scalar_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise non-commutative pwise_gt subop=operator> float I(float) I(int)
//
#ifndef scalar_vec_int_float_float_pwise_gt
#define scalar_vec_int_float_float_pwise_gt
static IA_DiscreteImage<int>
scalar_vec_bo_pwise_gt(float lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = rhs->domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (lhs) > (*(rs++)) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_vec_int_float_float_pwise_gt

// scalar-scalar operation is trivial

#ifndef scalar_iter_int_float_float_pwise_gt
#define scalar_iter_int_float_float_pwise_gt
static IA_DiscreteImage<int>
scalar_iter_bo_pwise_gt(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = ( (lhs) > (rtmp) );
	}
    }
    return IA_DiscreteImage<int>(domain, vec, sz, 1);
}
#endif // scalar_iter_int_float_float_pwise_gt

IA_DiscreteImage<int>
pwise_gt (float lhs, const IA_FloatDiscreteImage &rhs)
{
    if (rhs.type() == IA_VectorDI<float>::s_type()) {
	return scalar_vec_bo_pwise_gt(lhs,(IA_VectorDI<float> *)rhs.bdip);
    } else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_DiscreteImage<int> (rhs.domain(), (lhs) > (((IA_ConstDI<float> *)rhs.bdip)->value));
    } else {
	return scalar_iter_bo_pwise_gt(lhs,rhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqrt I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_float_float_sqrt
#define vec_scalar_float_float_sqrt
static IA_FloatDiscreteImage
vec_uo_sqrt(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqrt(*(ls++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_sqrt

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_sqrt
#define iter_scalar_float_float_sqrt
static IA_FloatDiscreteImage
iter_uo_sqrt(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = sqrt(ltmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_sqrt

IA_FloatDiscreteImage
sqrt ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_sqrt((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (arg.domain(), sqrt(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_sqrt(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// unary pointwise sqr I(float) I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	unary-op.templ,v $
// Revision 1.2  93/05/27  11:49:04  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:50:00  thoth
// Initial revision
// 

#ifndef vec_scalar_float_float_sqr
#define vec_scalar_float_float_sqr
static IA_FloatDiscreteImage
vec_uo_sqr(const IA_VectorDI<float> *lhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = sqr(*(ls++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_sqr

// scalar-scalar operation is trivial

#ifndef iter_scalar_float_float_sqr
#define iter_scalar_float_float_sqr
static IA_FloatDiscreteImage
iter_uo_sqr(IA_FloatDiscreteImage lhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    *(ds++) = sqr(ltmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // iter_scalar_float_float_sqr

IA_FloatDiscreteImage
sqr ( const IA_FloatDiscreteImage &arg)
{
    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_uo_sqr((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (arg.domain(), sqr(((IA_ConstDI<float> *)arg.bdip)->value));
    } else {
	return iter_uo_sqr(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_max(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), *(rs++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_max
#define vec_scalar_float_float_float_max
static IA_FloatDiscreteImage
vec_scalar_bo_max(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), rhs);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_max

static IA_FloatDiscreteImage
vec_iter_bo_max(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(*(ls++), rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_max
#define scalar_iter_float_float_float_max
static IA_FloatDiscreteImage
scalar_iter_bo_max(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(lhs, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_max

static IA_FloatDiscreteImage
iter_iter_bo_max(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = max(ltmp, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
max ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_max((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_max((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_max((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_max((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), max(((IA_ConstDI<float> *)lhs.bdip)->value, ((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_max(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_max((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_max(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_max(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative max I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_max
#define vec_scalar_float_float_float_max
static IA_FloatDiscreteImage
vec_scalar_bo_max(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = max(*(ls++), rhs);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_max

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_max
#define scalar_iter_float_float_float_max
static IA_FloatDiscreteImage
scalar_iter_bo_max(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = max(lhs, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_max

IA_FloatDiscreteImage
max ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_max((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), max(((IA_ConstDI<float> *)lhs.bdip)->value, rhs));
    } else {
	return scalar_iter_bo_max(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(float) I(float) I(float)
//
static IA_FloatDiscreteImage
vec_vec_bo_min(const IA_VectorDI<float> *lhs,const IA_VectorDI<float> *rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	const float *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), *(rs++));
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

#ifndef vec_scalar_float_float_float_min
#define vec_scalar_float_float_float_min
static IA_FloatDiscreteImage
vec_scalar_bo_min(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), rhs);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_min

static IA_FloatDiscreteImage
vec_iter_bo_min(const IA_VectorDI<float> *lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(*(ls++), rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_min
#define scalar_iter_float_float_float_min
static IA_FloatDiscreteImage
scalar_iter_bo_min(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(lhs, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_min

static IA_FloatDiscreteImage
iter_iter_bo_min(IA_FloatDiscreteImage lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = lhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float ltmp;
	IA_DIVIter<float>	liter(lhs);
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    liter(ltmp);
	    riter(rtmp);
	    *(ds++) = min(ltmp, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}

IA_FloatDiscreteImage
min ( const IA_FloatDiscreteImage &lhs,
	      const IA_FloatDiscreteImage &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	static IA_FloatDiscreteImage	rval;
	ia_throw( IA::PSET_MISMATCH, __FILE__,__LINE__);
	return rval;
    }

    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_vec_bo_min((IA_VectorDI<float> *)lhs.bdip,(IA_VectorDI<float> *)rhs.bdip);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return vec_scalar_bo_min((IA_VectorDI<float> *)lhs.bdip,((IA_ConstDI<float> *)rhs.bdip)->value);
	} else {
	    return vec_iter_bo_min((IA_VectorDI<float> *)lhs.bdip,rhs);
	}
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_scalar_bo_min((IA_VectorDI<float> *)rhs.bdip,((IA_ConstDI<float> *)lhs.bdip)->value);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return IA_FloatDiscreteImage (lhs.domain(), min(((IA_ConstDI<float> *)lhs.bdip)->value, ((IA_ConstDI<float> *)rhs.bdip)->value));
	} else {
	    return scalar_iter_bo_min(((IA_ConstDI<float> *)lhs.bdip)->value,rhs);
	}
    } else {
	if (rhs.type() == IA_VectorDI<float>::s_type()) {
	    return vec_iter_bo_min((IA_VectorDI<float> *)rhs.bdip,lhs);
	} else if (rhs.type() == IA_ConstDI<float>::s_type()) {
	    return scalar_iter_bo_min(((IA_ConstDI<float> *)rhs.bdip)->value,lhs);
	} else {
	    return iter_iter_bo_min(lhs,rhs);
	}
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative min I(float) float I(float)
//
#ifndef vec_scalar_float_float_float_min
#define vec_scalar_float_float_float_min
static IA_FloatDiscreteImage
vec_scalar_bo_min(const IA_VectorDI<float> *lhs,float rhs)
{
    const IA_IntPointSet domain = lhs->domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	const float *ls = lhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = min(*(ls++), rhs);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // vec_scalar_float_float_float_min

// scalar-scalar operation is trivial

#ifndef scalar_iter_float_float_float_min
#define scalar_iter_float_float_float_min
static IA_FloatDiscreteImage
scalar_iter_bo_min(float lhs,IA_FloatDiscreteImage rhs)
{
    const IA_IntPointSet domain = rhs.domain();
    const unsigned sz = domain.card();
    float *const vec = new float[sz];

    {
	float *ds = vec;
	float rtmp;
	IA_DIVIter<float>	riter(rhs);
	for (unsigned i=0; i<sz; i++) {
	    riter(rtmp);
	    *(ds++) = min(lhs, rtmp);
	}
    }
    return IA_FloatDiscreteImage(domain, vec, sz, 1);
}
#endif // scalar_iter_float_float_float_min

IA_FloatDiscreteImage
min ( const IA_FloatDiscreteImage &lhs, float rhs)
{
    if (lhs.type() == IA_VectorDI<float>::s_type()) {
	return vec_scalar_bo_min((IA_VectorDI<float> *)lhs.bdip,rhs);
    } else if (lhs.type() == IA_ConstDI<float>::s_type()) {
	return IA_FloatDiscreteImage (lhs.domain(), min(((IA_ConstDI<float> *)lhs.bdip)->value, rhs));
    } else {
	return scalar_iter_bo_min(rhs,lhs);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction reduce_plus subop=operator+ float I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_op_nz,v $
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

static float vec_reduce_reduce_plus(const IA_VectorDI<float> *arg)
{
    const float *ls = arg->vec;

    float	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_float_float_reduce_plus
#define const_reduce_float_float_reduce_plus
static float const_reduce_reduce_plus(unsigned sz, float arg)
{
    float	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static float iter_reduce_reduce_plus(const IA_FloatDiscreteImage &arg)
{
    IA_DIVIter<float>	iter(arg);

    float	temp;
    iter(temp);

    float	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

float reduce_plus ( const IA_FloatDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_reduce_reduce_plus((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return const_reduce_reduce_plus(arg.domain().card(),
				   ((IA_ConstDI<float> *)arg.bdip)->value);
    } else {
	return iter_reduce_reduce_plus(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max subop=max float I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static float vec_reduce_max(const IA_VectorDI<float> *arg)
{
    const float *ls = arg->vec;

    float	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_float_float_max
#define const_reduce_float_float_max
static float const_reduce_max(unsigned sz, float arg)
{
    float	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static float iter_reduce_max(const IA_FloatDiscreteImage &arg)
{
    IA_DIVIter<float>	iter(arg);

    float	temp;
    iter(temp);

    float	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

float max ( const IA_FloatDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_reduce_max((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return const_reduce_max(arg.domain().card(),
				   ((IA_ConstDI<float> *)arg.bdip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min subop=min float I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	reduce_fn_nz,v $
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

static float vec_reduce_min(const IA_VectorDI<float> *arg)
{
    const float *ls = arg->vec;

    float	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_float_float_min
#define const_reduce_float_float_min
static float const_reduce_min(unsigned sz, float arg)
{
    float	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static float iter_reduce_min(const IA_FloatDiscreteImage &arg)
{
    IA_DIVIter<float>	iter(arg);

    float	temp;
    iter(temp);

    float	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

float min ( const IA_FloatDiscreteImage &arg)
{
    if (arg.domain().card()==0)
	abort(); // XXX unfinished code

    if (arg.type() == IA_VectorDI<float>::s_type()) {
	return vec_reduce_min((IA_VectorDI<float> *)arg.bdip);
    } else if (arg.type() == IA_ConstDI<float>::s_type()) {
	return const_reduce_min(arg.domain().card(),
				   ((IA_ConstDI<float> *)arg.bdip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}

