// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log:	FloatDiscreteImage.h,v $
// Revision 1.4  93/05/27  11:21:48  thoth
// Copyright Notices
// 
// Revision 1.3  93/05/26  17:00:47  thoth
// Provide some compositions that will be frequently used.
// 
// Revision 1.2  93/04/29  11:19:48  thoth
// Workaround for CFront implementation ugliness.
// 
// Revision 1.1  93/04/17  18:59:25  thoth
// Initial revision
// 


#ifndef FloatDI_h_
#define FloatDI_h_

#include "DiscreteImage.h"

class IA_FloatDiscreteImage: public IA_DiscreteImage<float>
{
  public:
    IA_FloatDiscreteImage():IA_DiscreteImage<float>() {}

    IA_FloatDiscreteImage(const IA_FloatDiscreteImage& im)
    :IA_DiscreteImage<float>(im) {}
    IA_FloatDiscreteImage(IA_IntPointSet ps, float value)
    :IA_DiscreteImage<float>(ps,(float)value) {}
    IA_FloatDiscreteImage(IA_IntPointSet ps, float *vp, unsigned sz,
			  int giveaway=0)
    :IA_DiscreteImage<float>(ps, vp, sz, giveaway) {}

    IA_FloatDiscreteImage(const IA_OtherDI<float> &img)
    :IA_DiscreteImage<float>(img) {}

    IA_FloatDiscreteImage(IA_IntPointSet ps, float (*f)(const IA_IntPoint&))
    :IA_DiscreteImage<float>(ps,f) {}

    IA_FloatDiscreteImage( const IA_DiscreteImage<float> &d)
    :IA_DiscreteImage<float>(d) {}

    virtual ~IA_FloatDiscreteImage(){ }

#include	"FloatImageOps.h"
#if 0
    static IA_FloatDiscreteImage read_PGM(istream &);
    static IA_FloatDiscreteImage read_PGM(const char *fname);

    ostream& write_PGM(ostream &, unsigned) const;
    ostream& write_PGM(ostream &) const;
    void write_PGM(const char *fname, unsigned) const;
    void write_PGM(const char *fname) const;
#endif
};

inline int operator!=(const IA_FloatDiscreteImage &lhs,
	       const IA_FloatDiscreteImage &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_FloatDiscreteImage &lhs, float rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(float lhs, const IA_FloatDiscreteImage &rhs) {
    return ! (rhs == lhs);
}

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_DiscreteImage<float>&);

inline IA_FloatDiscreteImage compose(double (*f)(double),
				     const IA_DiscreteImage<float>& fi) {
    return compose(f, fi, (float*)0, (double*)0, (double*)0);
}

inline IA_FloatDiscreteImage compose(double (*f)(double),
				     const IA_FloatDiscreteImage& fi) {
    return compose(f, fi, (float*)0, (double*)0, (double*)0);
}

#endif
