// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char FloatDI_rcsid[] = "$Id: FloatDiscreteImage.c,v 1.4 93/06/10 17:24:05 thoth Exp $";

//
// $Log:	FloatDiscreteImage.c,v $
// Revision 1.4  93/06/10  17:24:05  thoth
// instantiations for IAAIO
// 
// Revision 1.3  93/05/27  11:36:24  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/26  17:00:34  thoth
// instantiate all the compositions.
// 
// Revision 1.1  93/04/17  18:59:16  thoth
// Initial revision
// 


#include	"FloatDiscreteImage.h"
#include	"VectorDI.h"
#include	"ConstDI.h"
#include	"OtherDI.h"
#include	"ErrorDI.h"
#include	"DIVIter.h"
#include	"DIPIter.h"
#include	"IPSIter.h"

#include	<math.h>
#include	<fstream.h>

//
//
//


//
// below are included the implementations of every image-image
// and image-scalar operation we could think of for integer images.
//

template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}

template <class T>
inline T sqr(T v)
{
    return v*v;
}

#include "FloatImageOps.c"

//
//
//

class blah : public IA_OtherDI<float> {
  public:
    blah() 
    :IA_OtherDI<float>(IA_IntPointSet()) {}
    ostream &print_this(ostream &o) const { return o;}
    float operator()(const IA_IntPoint &) const { return 0; }
    IA_OtherDI<float>* clone_self() const { return 0; }
};
static void dummy001()
{
    IA_IntPoint		ip;
    IA_IntPointSet	ps;
    IA_FloatDiscreteImage	i1;
    IA_FloatDiscreteImage
	i2(i1),
	i3(ps,0.0),
	i4(ps, (float*)0, 0, 1),
	i5(ps, (float*)0, 0),
	i6(blah()),
	i7(ps, (float(*)(const IA_IntPoint&))0),
	i10(IA_DiscreteImage<float>());
    i1 = i1.restrict(i2.range());
    i1 = i1.xlated(ip);
    (IA_DiscreteImage<float>&)i1 = 2;
    (void)i1.type();
    i1[ip] = i1(ip);
    i1 = i1.restrict(i2.domain());
    (void)i1.extend(i2);
    (void)i1.reduce((float (*)(const float&,const float&)) 0, 0);
    (void)i1.reduce((float (*)( float, float)) 0, 0);
    cout << (IA_DiscreteImage<float>&)i1;

    IA_FloatDiscreteImage::read_IAA("");
    IA_FloatDiscreteImage::read_IAA("","");

    i1.write_IAA("");
    i1.write_IAA("","");

    IA_DIVIter<float>	iter1(i1), iter2;
    IA_DIPIter<float>	iter3(i2), iter4;
    iter1 = iter2;
    iter3 = iter4;

    compose(i1, (IA_IntPoint(*)(const IA_IntPoint&))0);
    compose(i1, *(IA_PPCompClosure<IA_IntPoint, IA_IntPoint>*)0);
    compose((float(*)(float))0, i1);
    compose((double(*)(double))0, (IA_DiscreteImage<float>&)i1);
    compose((u_char(*)(float))0, i1, (u_char*)0);

    IA_ValueSet<float>	vs(i1.range());
    // I shouldn\'t have to do the following two lines
    // vs.value_type_compare(0,0);
}
