// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log: ErrorDI.h,v $
// Revision 1.9  1993/05/27  11:19:42  thoth
// Copyright Notices
//
// Revision 1.8  93/05/18  21:40:31  thoth
// *** empty log message ***
// 
// Revision 1.7  93/03/10  13:34:56  thoth
// range method no longer returns valueset due to
// difficulties with template implementation.
// 
// Revision 1.6  93/02/20  15:12:09  thoth
// Many methods that throw have been removed (let the BaseDI throw for us).
// 
// Revision 1.5  93/02/08  12:59:59  thoth
// ErrorDI does not need another pointset and refcount.  BaseDI
// already takes care of this.
// Fixed memory leak.
// 
// Revision 1.4  93/01/19  14:56:07  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.3  92/11/14  09:46:07  jnw
// modified to use () and [] instead of val and ref
// 
// Revision 1.2  92/11/13  13:50:18  jnw
//  Updated to include all sorts of new goodies
// 
// Revision 1.1  92/10/05  11:45:05  jnw
// Initial revision
// 

#ifndef ErrorDI_h_
#define ErrorDI_h_

#include <stdlib.h>
#include "BaseDI.h"

// ErrorDI generates members of a class of BaseDIs whose only valid operation
// is decr_ref().  This is used to trap operations occurring upon
// uninitialized images.

template <class T>
class IA_ErrorDI:public IA_BaseDI<T> {

public:

    IA_ErrorDI() :IA_BaseDI<T>(IA_IntPointSet()) { }

    int extensivep() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    T operator ()(const IA_IntPoint &) const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

    T& operator [](const IA_IntPoint &) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

#if 0
    T& operator [](int) { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }

    T operator ()(int) const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return *(new T());
    }
#endif

    static IA_DiscreteImageType s_type() { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    IA_DiscreteImageType type() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    IA_IntPointSet domain() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return this->ps;
    }

    IA_ValueSet<T> range() const { 
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return 0;
    }

    // ~IA_ErrorDI() { } // gratuitous

    IA_BaseDI<T>* clone_self_extensively() const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return (IA_BaseDI<T> *)this;
    }

    virtual ostream& print_this(ostream& o) const {
	ia_throw( IA::IMAGE_REQUIRE_VALUE, __FILE__,__LINE__);
	return o;
    }
    
};

#endif
