// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char ConstDIVIterrcsid[] = "$Id: ConstDIVIter.c,v 1.5 93/05/27 11:28:15 thoth Exp $";

// $Log:	ConstDIVIter.c,v $
// Revision 1.5  93/05/27  11:28:15  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/17  18:46:56  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.3  93/02/20  12:43:31  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.2  93/01/19  14:55:51  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/11/12  17:01:15  jnw
// Initial revision
// 
// Revision 1.1  92/10/05  11:45:52  jnw
// Initial revision
// 

#include "ConstDIVIter.h"

template <class T>
IA_ConstDIVIter<T>::IA_ConstDIVIter(const IA_ConstDI<T> *img)
: IA_BaseDIVIter<T>(img)
{
    this->num_left = img->domain().card();
}

template <class T>
IA_ConstDIVIter<T>::IA_ConstDIVIter(const IA_ConstDIVIter<T> &iter)
: IA_BaseDIVIter<T>(iter.domain)
{
    this->num_left = iter.num_left;
}

template <class T>
int IA_ConstDIVIter<T>::next(T& pixel_value)
{
    if (this->num_left--) {
	pixel_value = this->cdip()->value;
	return 1;
    }
    return 0;
}





